<?php defined('IN_ADMIN') or exit;

class supesite75 extends import implements ICmsImport
{
    protected $config = array(
    pagesize => array(
    'category' => 30,
    'article' => 20,
    'picture' => 20,
    'comment' => 20,
    'member' => 20
    ),
    data => array(
    'thumb_search' => '',
    'thumb_replace' => '',
    'thumb_prefix' => 'attachments/',
    'attach_search' => '',
    'attach_replace' => '',
    'attach_prefix' => 'attachments/',
    'content_search' => array(
    '="http://supesite.import.loc/attachments/'
    ),
    'content_replace' => array(
    "=\"{UPLOAD_URL}attachments/"
    )
    )
    );

    function __construct($options)
    {
        parent::__construct($options);

        $this->relation_base_path .= __CLASS__ . '/';
        $this->tables = array(
        'member' => '#table_members',
        'member_detail' => '',
        'member_group' => '#table_usergroups',
        'category' => '#table_categories',
        'article' => '#table_spaceitems',
        'article_addon' => '#table_spacenews',
        'comment' => '#table_spacecomments'
        );
        $this->ids = array(
        'member' => 'uid',
        'group' => 'groupid',
        'category' => 'catid',
        'category_parent' => 'upid',
        'article' => 'itemid',
        'comment' => 'cid'
        );
    }

    function config($options)
    {
        $data = array();

        if ($options['data'])
        {
            $query = $this->import_db->get($this->get_category_sql("COUNT(`{$this->ids['category']}`) AS `total`"));
            $data['data']['category'] = $query['total'];
        }

        if ($options['member'])
        {
            $query = $this->import_db->get("SELECT COUNT(`{$this->ids['member']}`) AS `total` FROM `{$this->tables['member']}`");
            $data['member']['total'] = $query['total'];
        }

        $this->_after_config($data);
        return $data;
    }

    function detail($options)
    {
        $data = array();

        if ($options['member'])
        {
            $query = "SELECT COUNT(`{$this->ids['member']}`) AS `total` FROM `{$this->tables['member']}`";
            $query = $this->import_db->get($query);
            $data['member']['total'] = $query['total'];
        }

        if ($options['data'])
        {
            $cat_sql = '';

            // 计算栏目数
            $sql = $this->get_category_sql("COUNT(`{$this->ids['category']}`) AS `total`");
            $query = $this->import_db->get($sql);
            $data['data']['total']['category'] = $query['total'];

            // 计算文章数
            if ($options['data']['article'])
            {
                $sql = "SELECT COUNT(`{$this->ids['article']}`) AS `total` FROM `{$this->tables['article']}`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['article'] = $query['total'];
            }

            // 计算组图数
            if ($options['data']['picture'])
            {
                $data['data']['total']['picture'] = 0;
            }

            // 计算评论数
            $modelid = array();
            if ($options['data']['article'])
            {
                $modelid[] = 1;
            }
            if ($options['data']['picture'])
            {
                $modelid[] = 2;
            }
            if (!empty($modelid) && $options['data']['comment'])
            {
                $sql = "SELECT COUNT(`{$this->ids['comment']}`) AS `total` FROM `{$this->tables['comment']}`";
                $query = $this->import_db->get($sql);
                $data['data']['total']['comment'] = $query['total'];
            }
        }

        return $data;
    }

    function import($options)
    {
        $type = $options['type'];
        $start = intval($options['start']);
        $pagesize = $this->pagesize($type);
        $data = array();

        switch ($type)
        {
            case 'category':
                $channel_relation = $this->get_relation('channel');

                // 先导入频道
                if (empty($channel_relation))
                {
                    if ($channels = $this->import_db->select("SELECT * FROM `#table_channels` WHERE `type` <> 'system'"))
                    {
                        foreach ($channels as $channel)
                        {
                            $this->handle_charset($channel);

                            $category = self::$category;
                            $category['name'] = $channel['name'];
                            $category['alias'] = $channel['nameid'];
                            $category['sort'] = $channel['displayorder'];
                            $category['psn'] = $this->handle_path($channel['name'], $channel['url'], $channel['nameid'], '');
                            $category['enablecontribute'] = $channel['allowpost'];

                            if ($catid = self::$model_category->add($category))
                            {
                                $channel_relation[$channel['nameid']] = $catid;
                            }
                            else
                            {
                                $data['error'][] = '频道：' . $channel['nameid'];
                            }
                        }

                        $this->save_relation('channel', $channel_relation);
                    }
                }

                if (!empty($channel_relation) && $categorys = $this->import_db->select($this->get_category_sql("`{$this->ids['category']}`, `{$this->ids['category_parent']}`", "AND `type` IN ('" . implode("', '", array_keys($channel_relation)) . "') LIMIT $start, $pagesize")))
                {
                    $category_relation = $this->get_relation('category');
                    foreach ($categorys as $c)
                    {
                        $catid = $c[$this->ids['category']];

                        // 如果之前的操作已经添加过了，跳过
                        if (isset($category_relation[$catid]))
                        {
                            continue;
                        }

                        $parentids = array($catid);
                        $parentid = $c[$this->ids['category_parent']];
                        while($parentid)
                        {
                            $parent = $this->import_db->get($this->get_category_sql("`{$this->ids['category']}`, `{$this->ids['category_parent']}`", " AND `{$this->ids['category']}` = $parentid"));
                            $parentids[] = $parent[$this->ids['category']];
                            $parentid = $parent[$this->ids['category_parent']];
                        }
                        $parentids = array_reverse($parentids);

                        foreach ($parentids as $parentid)
                        {
                            if (isset($category_relation[$parentid]))
                            {
                                continue;
                            }

                            // 添加栏目，由于是按照从前到后的顺序来添加，假定按照这个顺序添加的栏目，父栏目都已经存在
                            if ($query = $this->import_db->get ( $this->get_category_sql ( '*', " AND `{$this->ids['category']}` = '$parentid'" ) ))
                            {
                                $category = self::$category;

                                $this->handle_charset($query);

                                if ($query[$this->ids['category_parent']])
                                {
                                    $category ['parentid'] = $category_relation[$query[$this->ids['category_parent']]];
                                }
                                else
                                {
                                    $category ['parentid'] = isset($channel_relation[$query['type']]) ? $channel_relation[$query['type']] : '';
                                }
                                $category ['name'] = $query ['name'];
                                $category['alias'] = $query ['prehtml'] ? $query ['prehtml'] : $query [$this->ids['category']];
                                $category['sort'] = $query['displayorder'];

                                // 发布点
                                $query['parentdir'] = $category[$this->ids['category_parent']] ? table('category', $category_relation[$category[$this->ids['category_parent']]], 'path') : '';
                                $category['psn'] = $this->handle_path($query['name'], $query['url'], $category['alias'], $query['parentdir']);

                                if ($new_catid = self::$model_category->add($category))
                                {
                                    // 将新的ID关系对应保存起来
                                    $category_relation[$parentid] = $new_catid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $parentid;
                                }
                            }
                            else
                            {
                                continue;
                            }
                        }
                    }
                }

                $this->save_relation('category', $category_relation);
                $data['start'] = $start + $pagesize;
                break;

            case 'article':
                // 根据之前的栏目获得要转换的文章
                $category_relation = $this->get_relation('category');
                $article_relation = $this->get_relation('article');

                if (!empty($category_relation) && ($result = $this->import_db->select("SELECT * FROM `{$this->tables['article']}` WHERE `{$this->ids['category']}` IN (" . implode(',', array_keys($category_relation)) .") LIMIT $start, $pagesize")))
                {
                    foreach ($result as $article)
                    {
                        if (isset($article_relation[$article[$this->ids['article']]]))
                        {
                            continue;
                        }

                        $this->handle_charset($article);
                        $content = self::$article;

                        // 处理可能的分页
                        if ($addon_infos = $this->import_db->select("SELECT * FROM `{$this->tables['article_addon']}` WHERE `{$this->ids['article']}` = '{$article[$this->ids['article']]}'"))
                        {
                            $count = 0;
                            foreach ($addon_infos as $addon_info)
                            {
                                $this->handle_charset($addon_info);

                                if ($count == 0)
                                {
                                    $content['tags'] = implode(' ', unserialize($addon_info['relativetags']));
                                    $content['source'] = $addon_info['newsfrom'];
                                    $content['author'] = $addon_info['newauthor'];

                                    if (!empty($addon_info['newsurl']))
                                    {
                                        $article['islink'] = 1;
                                        $content['url'] = $addon_info['newsurl'];
                                        break;
                                    }

                                    $content['content'] = $addon_info['message'];
                                }
                                else
                                {
                                    $content['content'] .= $this->pagevar . $addon_info['message'];
                                }
                                $count++;
                            }

                            if ($count > 1)
                            {
                                $content['content'] = $this->pagevar . $content['content'];
                            }

                            $content['content'] = $this->handle_content($content['content'], $options);
                        }
                        else
                        {
                            continue;
                        }

                        $content['catid'] = $category_relation[$article[$this->ids['category']]];
                        $content['title'] = $article['subject'];
                        $content['color'] = $article['fontcolor'] ? '#' . substr($article['fontcolor'], 0, 6) : '';
                        $content['editor'] = $article['username'];
                        $content['status'] = $article['grade'] ? 3 : 6;

                        // 处理缩略图
                        if ($article['picid'])
                        {
                            // attachments
                            $thumb = $this->import_db->get("SELECT `filepath` FROM `#table_attachments` WHERE `aid` = '{$article['picid']}'");
                            $content['thumb'] = $this->handle_thumb($thumb['filepath'], $options);
                        }

                        if ($article['islink'])
                        {
                            $content['modelid'] = 3;

                            $contentid = self::$model_link->add($content);
                        }
                        else
                        {
                            $content['iscontribute'] = ($article['fromtype'] == 'userpost') ? 1 : 0;
                            $content['allowcomment'] = $article['allowreply'];

                            $contentid = self::$model_article->add($content);
                        }

                        if ($contentid)
                        {
                            $published = '';
                            $publishedby = '';
                            if ($content['status'] == 6)
                            {
                                $published = $article['dateline'];
                                $publishedby = $article['uid'];
                            }
                            $this->db->update("UPDATE `#table_content` SET `created` = '{$article['dateline']}', `createdby` = '{$article['uid']}',  `published` = '$published',  `publishedby` = '$publishedby', `pv` = '{$article['viewnum']}' WHERE `contentid` = $contentid");
                            $article_relation[$article[$this->ids['article']]] = $contentid;
                        }
                        else
                        {
                            // 出错
                            $data['error'][] = $article[$this->ids['article']];
                        }
                    }

                    $this->save_relation('article', $article_relation);
                }

                $data['start'] = $start + $pagesize;
                console($data['start']);
                break;

            case 'picture':
                $data['start'] = $start + $pagesize;
                break;

            case 'comment':
                // 根据之前的内容获得要转换的评论
                $content_relation = $this->get_relation('article');
                foreach ($this->get_relation('picture') as $key => $value)
                {
                    $content_relation[$key] = $value;
                }
                $comment_relation = $this->get_relation('comment');

                if (!empty($content_relation))
                {
                    foreach ($content_relation as $key => $value)
                    {
                        if ($comments = $this->import_db->select("SELECT * FROM `{$this->tables['comment']}` WHERE `itemid` = '$key'"))
                        {
                            foreach ($comments as $c)
                            {
                                if (isset($comment_relation[$c[$this->ids['comment']]]))
                                {
                                    continue;
                                }

                                // 处理编码问题
                                $this->handle_charset($c);

                                $comment['contentid'] = $value;
                                $comment['disabled'] = $c['status'] ? 0 : 1;

                                // 回复(盖楼)
                                /*
                                array (
                                'message' => '<div id="cid_4_2" class="old"><div id="cid_4_1" class="old"><div id="cid_4_1_title" class="old_title"><span class="author">SupeSite社区门户火星网友 [import]  (127.0.*.*) 的原贴：</span><span class="color_red">1</span></div><div id="cid_4_1_detail" class="detail"><span name="cid_4_info">额，来个评论。</span></div></div><div id="cid_4_2_title" class="old_title"><span class="author">SupeSite社区门户火星网友 [import]  (127.0.*.*) 的原贴：</span><span class="color_red">2</span></div><div id="cid_4_2_detail" class="detail"><span name="cid_4_info">回复？不就是嵌套么</span></div></div><div class="new"><span name="cid_4_info">三层盖楼，哦不...</span></div>',
                                )
                                * */
                                // <div id="cid_4_2" class="old"><div id="cid_4_1" class="old"><div id="cid_4_1_title" class="old_title"><span class="author">SupeSite社区门户火星网友 [import]  (127.0.*.*) 的原贴：</span><span class="color_red">1</span></div><div id="cid_4_1_detail" class="detail"><span name="cid_4_info">额，来个评论。</span></div></div><div id="cid_4_2_title" class="old_title"><span class="author">SupeSite社区门户火星网友 [import]  (127.0.*.*) 的原贴：</span><span class="color_red">2</span></div><div id="cid_4_2_detail" class="detail"><span name="cid_4_info">回复？不就是嵌套么</span></div></div><div class="new"><span name="cid_4_info">三层盖楼，哦不...</span></div>
                                // [floor][name][cmstop]-127.0.*.*[/name]<div class="reply"><span class="f_l c_red">[cmstop]-127.0.*.*</span><br/>测试盖楼</div>第二层[/floor][reply]第三层
                                if (strpos($c['message'], 'author">'))
                                {
                                    preg_match('/<div.*"author">(.*?)<\/span>.*<span.*?>(.*?)</', $c['message'], $result);
                                    $comment['content'] = $result[2] ? $result[2] : '';
                                }
                                else
                                {
                                    $comment['content'] = strip_tags($c['message']);
                                }

                                $comment['content'] = preg_replace('//', "", $c['message']);

                                if ($c['hideauthor'])
                                {
                                    $comment['anonymous'] = 1;
                                }

                                if ($commentid = self::$model_comment->add($comment))
                                {
                                    // 更新一些字段
                                    $createdby = $c['uid'];

                                    $this->db->update("UPDATE `#table_comment` SET `support` = '{$c['click_33']}', `against` = '{$c['click_34']}', `ip` = '{$c['ip']}', `created` = '{$c['dateline']}', `createdby` = '$createdby' WHERE `commentid` = $commentid");

                                    $comment_relation[$c[$this->ids['comment']]] = $commentid;
                                }
                                else
                                {
                                    // error
                                    $data['error'][] = $c[$this->ids['comment']];
                                }
                            }
                        }
                    }

                    $this->save_relation('comment', $comment_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            case 'member':
                if ($members = $this->import_db->select("SELECT * FROM `{$this->tables['member']}`" . ($this->tables['member_detail'] ? " m LEFT JOIN `{$this->tables['member_detail']}` d ON m.`{$this->ids['member']}` = d.`{$this->ids['member']}`" : '') . " LIMIT $start, " . $pagesize))
                {
                    $member_relation = $this->get_relation('member');
                    $member_group_relation = $this->get_relation('member_group');

                    // 转换会员组
                    if (empty($member_group_relation))
                    {
                        if ($groups = $this->import_db->select("SELECT * FROM `{$this->tables['member_group']}`"))
                        {
                            $cmstop_group_relation = array(
                            1 => 1,
                            2 => 2,
                            3 => 5,
                            12 => 6
                            );

                            foreach ($groups as $g)
                            {
                                $this->handle_charset($g);

                                $group = array(
                                'name' => $g['grouptitle'],
                                'allowlogin' => $g['allowview'],
                                'allowcontribute' => $g['allowpost'],
                                'allowcomment' => $g['allowcomment']
                                );

                                // 如果在对应关系里面，直接更新
                                if (isset($cmstop_group_relation[$g[$this->ids['group']]]))
                                {
                                    $groupid = $cmstop_group_relation[$g[$this->ids['group']]];
                                    $this->db->update("UPDATE `#table_member_group` SET " . $this->handle_key_value_update($group) . " WHERE `groupid` = $groupid");
                                }
                                else
                                {
                                    // 插入
                                    $groupid = self::$model_member_group->add($group);
                                }
                                $member_group_relation[$g[$this->ids['group']]] = $groupid;
                            }
                        }
                        $this->save_relation('member_group', $member_group_relation);
                    }

                    foreach ($members as $m)
                    {
                        if (isset($member_relation[$m[$this->ids['member']]]))
                        {
                            continue;
                        }

                        // 处理编码问题
                        $this->handle_charset($m);

                        // 数据库直接插入
                        $member = array(
                        'userid' => $m[$this->ids['member']],
                        'username' => $m['username'],
                        'password' => $m['password'],
                        'email' => $m['email'] ? $m['email'] : $this->default_email,
                        'groupid' => $member_group_relation[$m[$this->ids['group']]],
                        'regip' => $m['ip'],
                        'regtime' => $m['dateline'],
                        'lastloginip' => $m['ip'],
                        'lastlogintime' => $m['lastlogin'],
                        'credits' => $m['credit']
                        );

                        $member = $this->handle_key_value($member);
                        if ($userid = $this->db->insert("INSERT INTO `#table_member` ({$member['key']}) VALUES ({$member['value']})"))
                        {
                            $userid = $m[$this->ids['member']];

                            // 详细信息
                            $member = array(
                            'userid' => $userid,
                            'authstr' => $m['authstr']
                            );

                            $member = $this->handle_key_value($member);
                            $this->db->insert("INSERT INTO `#table_member_detail` ({$member['key']}) VALUES ({$member['value']})");

                            $member_relation[$m[$this->ids['member']]] = $userid;
                        }
                        else
                        {
                            // error
                            $data['error'][] = $m[$this->ids['member']];
                        }
                    }

                    $this->save_relation('member', $member_relation);
                }

                $data['start'] = $start + $pagesize;
                break;

            default:
                break;
        }

        return $data;
    }

    private function get_category_sql($select, $addon = '')
    {
        return "SELECT $select FROM `{$this->tables['category']}` WHERE `ischannel` = 0 AND `type` IN (SELECT `nameid` FROM `#table_channels` WHERE `type` <> 'system') " . $addon;
    }
}
