<?php

/*
    [CmsTop] (C)2009-2010 CmsTop Inc.

    CmsTop 数据转换程序

    根据需要可将原系统的 会员、栏目、文章、组图、评论 等数据转换到 CmsTop 中

    适用于如下的CMS系统
	* Phpcms 2007 / 2008
	* SupeSite 7.5
	* DedeCMS 5.6
	* Php168 v6
	* 帝国CMS 6.5
	* 动易（SiteFactory）3.5

    请将该程序放在 后台管理地址对应的目录下（CmsTop 媒体版对应 ./public/admin/，CmsTop 大众版对应
    ./admin/），通过访问形如 http://admin.cmstop.com/convert/ 或 http://cmstop.com/admin/convert/ 
    的地址，进入转换页面。

    $Id$
 */

define('CONVERT_VERSION', '1.0');
define('CMSTOP_START_TIME', microtime(true));
define('RUN_CMSTOP', true);
define('IN_ADMIN', 1);

header('Content-Type:text/html;charset=utf-8');

if (file_exists('../../../cmstop.php'))
{
    require '../../../cmstop.php';
    require_once ROOT_PATH . 'version.php';
}
else if (file_exists('../../cmstop/cmstop.php'))
{
    require '../../cmstop/cmstop.php';
    require_once CMSTOP_PATH . 'version.php';
}
else 
{
    die('<p>请将转换程序放置在正确的目录：</p>
	<dl>
	<dt>CmsTop 媒体版</dt>
	<dd>放在 ./public/admin/ 目录下，以形如 http://admin.cmstop.com/convert/ 路径访问</dd>

	<dt>CmsTop 大众版</dt>
	<dd>放在 ./admin/ 目录下，以形如 http://cmstop.com/admin/convert/ 路径访问</dd>
	</dl>');
}

define('BASE_PATH', dirname(__FILE__) . DS);
define('BASE_URL', ADMIN_URL . 'convert/');

loader::set_app('system');

ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_STRICT);
set_time_limit(0);

$user = online();
if (!$user || $user['groupid'] != 1) exit('请使用超级管理员账号 <a href="' . ADMIN_URL . '">登陆</a> 后台后，重新访问本页面。');

$cache_path = CACHE_PATH . 'convert/' . $user['userid'] . '/';

loader::import('cms.interface', BASE_PATH);
loader::import('cms.abstract', BASE_PATH);

if ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest')
{
    $action = _param('action');
    switch ($action)
    {
    case 'config':
	if ($_REQUEST['importtype'])
	{
	    $cmstype = _param('cmstype');
	    $cmsversion = _param('cmsversion');

	    $import = $cmstype . $cmsversion;
	    if ($cmstype && loader::import('cms.' . $cmstype . '.' . $import, BASE_PATH))
	    {
		cache_write('cms.php', array('cmstype' => $cmstype, 'cmsversion' => $cmsversion), $cache_path);

		$options = array_map('trim', $_REQUEST['import']);
		if(!isset($options['driver'])) $options['driver'] = 'mysql';
		if(!isset($options['host'])) $options['host'] = 'localhost';
		if(!isset($options['port'])) $options['port'] = 3306;
		if(!isset($options['charset'])) $options['charset'] = 'utf8';
		if(!isset($options['dbname'])) $options['dbname'] = 'cmstop';
		if(!isset($options['username'])) $options['username'] = 'root';
		if(!isset($options['password'])) $options['password'] = '';
		if(!isset($options['pconnect'])) $options['pconnect'] = '0';
		if(!isset($options['prefix'])) $options['prefix'] = 'cmstop_';
		try 
		{
		    new PDO($options['driver'].':host='.$options['host'].';port='.$options['port'].';dbname='.$options['dbname'].';charset='.$options['charset'], $options['username'], $options['password'], array(PDO::ATTR_PERSISTENT => ($options['pconnect'] ? true : false)));
		    cache_write('db.php', $options, $cache_path);

		    $import = _instance();
		    $result = $import->config($_REQUEST['importtype']);
		    $result['state'] = true;
		    $result['importtype'] = $_REQUEST['importtype'];

		    echo json_encode($result);
		}
		catch (Exception $e) {
		    echo json_encode(array('state' => false, 'message' => '数据库连接失败' . ($e->getMessage() ? "\n" . $e->getMessage() : '')));
		}
	    }
	    else 
	    {
		echo json_encode(array('state' => false, 'message' => '请检查选择的 CMS 类型或版本是否正确'));
	    }
	} else {
	    echo json_encode(array('state' => false, 'message' => '请选择要导入的内容'));
	}
	break;

    case 'detail':
	$config = array();

	$importtype = $_REQUEST['importtype'];
	$member = $_REQUEST['member'];
	$data = $_REQUEST['data'];

	$import = _instance();

	$importtype['member'] && $config['member'] = $member;
	$importtype['data'] && $config['data'] = $data;
	$result = $import->detail($config);
	if ($importtype['data'])
	{
	    $config['data']['total'] = $result['data']['total'];
	    $config['data']['pagesize'] = $import->pagesize();
	}
	if ($importtype['member'])
	{
	    $config['member']['total'] = $result['member']['total'];
	    $config['member']['pagesize'] = $import->pagesize('member');
	}

	$config['state'] = true;

	echo json_encode($config);
	break;

    case 'execute':
	$import = _instance();
	$result = $import->import($_REQUEST);
	$result['state'] = true;           
	echo json_encode($result);
	break;

    case 'unload':
	@unlink($cache_path . 'lock');
	@unlink($cache_path . 'db.php');
	break;

    default:
	echo json_encode(array('state' => false, 'message' => '未知操作'));
	break;
    }
    exit;
}
else
{
?>
<!doctype html>
<html>
<head>
    <meta charset="UTF-8" />
    <title><?php echo CMSTOP_VERSION; ?> 数据转换程序</title>
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <script type="text/javascript">
    var base_url = '<?php echo BASE_URL; ?>', ADMIN_URL = '<?php echo ADMIN_URL; ?>', UPLOAD_URL = '<?php echo UPLOAD_URL; ?>';
    </script>
</head>
<body>
    <div class="doc-960">
	<h1 class="logo"><a class="help" href="" onclick="tips.init(); return false;">查看帮助</a><?php echo CMSTOP_VERSION; ?> 数据转换程序<span> <?php echo CONVERT_VERSION; ?></span></h1>

	<div class="progress">
	    <ul>
		<li class="current-prev done" rel="config_cmsotp"><span class="first">配置 CmsTop</span></li>
		<li class="current" rel="config_cms">配置要转换的CMS</li>
		<li rel="config_detail">转换详细配置</li>
		<li rel="import_console">正在转换</li>
		<li class="last" rel="import_result">转换结果</li>
	    </ul>
	</div>

	<div class="slider">

	    <!-- CMS -->
	    <div class="content" rel="config_cms">
		<form id="config_cms" action="?action=config" method="POST">
		<div class="card">
		    <p>
			<label class="title" for="cmstype">选择CMS</label>
			<select name="cmstype" id="cmstype">
			    <option value="0">类型</option>
			    <option value="phpcms">phpcms</option>
			    <option value="supesite">Supesite</option>
			    <option value="dedecms">dedecms</option>
			    <option value="php168">php168</option>
			    <option value="empirecms">帝国CMS</option>
			    <!-- <option value="excms">EXCMS</option> -->
			    <option value="sitefactory">动易(SiteFactory)</option>
			</select>

			<select name="cmsversion" id="cmsversion">
			    <option value="0">版本</option>
			    <option value="2008" rel="phpcms">2008</option>
			    <option value="2007" rel="phpcms">2007</option>
			    <!-- <option value="30" rel="phpcms">3.0</option> -->

			    <option value="75" rel="supesite">7.5</option>

			    <option value="56" rel="dedecms">5.6</option>

			    <option value="v6" rel="php168">v6</option>

			    <option value="65" rel="empirecms">6.5</option>

			    <option value="132" rel="excms">1.3.2</option>

			    <option value="3500" rel="sitefactory">3.5</option>
			</select>
		    </p>
		    <p class="line"></p>
		    <p>
			<label class="title" for="cms_driver">数据库类型</label>
			<select name="import[driver]" id="cms_driver">
			    <option value="mysql">MySQL</option>
			    <option value="mssql">MS SQL Server</option>
			</select>
		    </p>
		    <p>
			<label class="title" for="cms_host">主机地址</label>
			<input type="text" id="cms_host" name="import[host]" value="127.0.0.1" />
		    </p>
		    <p>
			<label class="title" for="cms_port">端口</label>
			<input type="text" id="cms_port" name="import[port]" value="3306" />
		    </p>
		    <p>
			<label class="title" for="cms_username">用户名</label>
			<input type="text" id="cms_username" name="import[username]" />
		    </p>
		    <p>
			<label class="title" for="cms_password">密码</label>
			<input type="text" id="cms_password" name="import[password]" />
		    </p>
		    <p>
			<label class="title" for="cms_dbname">数据库名称</label>
			<input type="text" id="cms_dbname" name="import[dbname]" />
		    </p>
		    <p>
			<label class="title" for="cmsdbprefix">数据库表前缀</label>
			<input type="text" id="cmsdbprefix" name="import[prefix]" />
		    </p>
		    <p>
			<label class="title">字符集</label>
			<label><input checked="checked" type="radio" name="import[charset]" value="gbk" />gbk</label>
			<label><input type="radio" name="import[charset]" value="gb2312" />gb2312</label>
			<label><input type="radio" name="import[charset]" value="utf8" />utf8</label>
			<label><input type="radio" name="import[charset]" value="latin1" />latin1</label>
		    </p>
		    <p>
			<label class="title">持久连接</label>
			<label><input type="radio" name="import[pconnect]" value="1" />是</label>
			<label><input checked="checked" type="radio" name="import[pconnect]" value="0" />否</label>
		    </p>

		    <p class="line"></p>

		    <p>
			<label class="title">要转换什么数据</label>
			<label><input type="checkbox" id="importdata" checked="checked" name="importtype[data]" value="1" />栏目及内容</label>
			<label><input type="checkbox" id="importmember" checked="checked" name="importtype[member]" value="1" />会员</label>
		    </p>
		</div>
		<div class="button">
		    <a class="" href="" rel="next" callback="app.config">保存并进入下一步</a>
		</div>
		</form>
	    </div>


	    <div class="content" rel="config_detail">
		<form id="config_detail" action="?action=detail" method="post">
		<p class="hide">
			<input type="checkbox" name="importtype[data]" value="1" id="importtype_data" />
			<input type="checkbox" name="importtype[member]" value="1" id="importtype_member" />
		</p>
		<div class="card">
		    <p class="section">
			<label class="title">正在配置</label>
			<span class="status"></span>
		    </p>

		    <p class="hide line"></p>

		    <div id="config_data" class="hide">
			    <p id="data_status">
				<label class="title">栏目数</label>
			    <span></span>
			    </p>
			    <p>
				<label class="title">转换数据</label>
				<label><input type="checkbox" checked="checked" name="data[article]" value="1" />文章</label>
				<label><input type="checkbox" checked="checked" name="data[picture]" value="1" />组图</label>
				<label><input type="checkbox" checked="checked" name="data[comment]" value="1" />评论</label>
			    </p>
			    <div id="config_data_detail">
				<p>
					<label class="title">缩略图路径</label>
					<input type="text" name="data[thumb_search]" /> 替换为 
					<input type="text" name="data[thumb_replace]" />
				    </p>
				    <p>
					<label class="title">追加缩略图前缀</label>
					<input type="text" name="data[thumb_prefix]" />
					&nbsp;&nbsp;&nbsp;&nbsp;确保缩略图文件已放在 ./public/upload 下对应的目录里
				    </p>
				    <p>
					<label class="title">附件路径</label>
					<input type="text" name="data[attach_search]" /> 替换为 
					<input type="text" name="data[attach_replace]" />
				    </p>
				    <p>
					<label class="title">追加附件前缀</label>
					<input type="text" name="data[attach_prefix]" />
					&nbsp;&nbsp;&nbsp;&nbsp;确保附件已放在 ./public/upload 下对应的目录里
				    </p>
				    <p>
					<label class="title">替换内容中的</label>
					<input type="text" name="data[content_search][]" /> 为 
					<input type="text" name="data[content_replace][]" /> <a class="action addmore" href="">+</a> <a class="action remove" href="">-</a>
				    </p>
			    </div>
		    </div>

		    <p class="hide line"></p>

		    <div id="config_member">
			    <p id="member_status">
				<label class="title">会员数</label>
				<span>&nbsp;</span>
			    </p>
			    <p class="hide" rel="phpcms2008">
				<label class="title" for="member_authkey">会员密码密钥</label>
				<input type="text" id="member_authkey" name="member[authkey]" /> 
				&nbsp;&nbsp;&nbsp;&nbsp;请填写 phpcms2008 目录 ./include/config.inc.php 94 行中的 PASSWORD_KEY
			    </p>
		    </div>

		    <p class="line"></p>

		    <div>
			    <p>
				<label class="title">每次处理多少</label>
				<label><input class="txt-l-r w-25" type="text" id="pagesize_category" size="3" /> 栏目</label>&nbsp;&nbsp;&nbsp;
				<label><input class="txt-l-r w-25" type="text" id="pagesize_article" size="3" /> 文章</label>&nbsp;&nbsp;&nbsp;
				<label><input class="txt-l-r w-25" type="text" id="pagesize_picture" size="3" /> 组图</label>&nbsp;&nbsp;&nbsp;
				<label><input class="txt-l-r w-25" type="text" id="pagesize_comment" size="3" /> 评论</label>&nbsp;&nbsp;&nbsp;
				<label><input class="txt-l-r w-25" type="text" id="pagesize_member" size="3" /> 会员</label>
			    </p>
		    </div>
		</div>
		<div class="button">
		    <a class="" href="" rel="next" callback="app.start">开始导入</a>
		    <a class="" href="" rel="prev">返回上一步</a>
		</div>
		</form>
	    </div>

	    <div id="import_console" class="content" rel="import_console">
		<div class="card">
		    <p class="section">
			<label class="title">正在执行</label>
			<span id="import_status"></span>
			<br />
		    </p>

		    <p class="hide line"></p>

		    <div id="console">
		    </div>
		</div>
		<div class="button">
		    <a class="disabled" href="" rel="next" callback="app.result">查看结果</a>
		    <a class="disabled" href="" rel="prev">返回上一步</a>
		</div>
	    </div>

	    <div id="import_result" class="content" rel="import_result">
		<div class="card">
		    <p class="section">
			<label class="title">转换结果</label>
			<span>&nbsp;</span>
			<br />
		    </p>

		    <div id="result_div">
		    </div>
		</div>
		<div class="button">
		    <a href="" rel="prev">返回上一步</a>
		</div>
	    </div>
	</div>
    </div>
    <div class="hide" id="tips_overlay">
    </div>
    <div class="hide" id="tips_content">
    &nbsp;
    </div>
    <script type="text/javascript" src="js/jquery.js"></script>
    <script type="text/javascript" src="<?php echo IMG_URL; ?>js/config.js"></script>
    <script type="text/javascript" src="js/jquery.form.js"></script>
    <script type="text/javascript" src="js/app.js"></script>
    <script type="text/javascript">
    (function($) {
	$(function() {
	    app.init();
	});
    })(jQuery);
    </script>
</body>
</html>
<?php
}

function _param($param)
{
    return (isset($_REQUEST[$param]) && preg_match("/[0-9a-zA-Z_]+/", $_REQUEST[$param])) ? trim($_REQUEST[$param]) : '';
}

function _instance()
{
    global $cache_path;
    static $charsets = array(
	'UTF8' => 'UTF-8', 
	'UTF-8' => 'UTF-8', 
	'GBK' => 'GBK', 
	'gb2312' => 'gb2312', 
	'latin1' => 'latin1'
    );

    $options = cache_read('db.php', $cache_path);
    $cms = cache_read('cms.php', $cache_path);
    $import = $cms['cmstype'] . $cms['cmsversion'];
    loader::import('cms.' . $cms['cmstype'] . '.' . $import, BASE_PATH);

    $options['cmscharset'] = $charsets[strtoupper($options['charset'])];
    $options['cmstopcharset'] = $charsets[strtoupper(config('db', 'charset'))];

    return new $import($options);
}
?>
