/*
[CmsTop] (C)2009-2010 CmsTop Inc.

CmsTop 数据转换程序依赖 JS

$Id$
*/

var btn,
error = undefined,
importtype = undefined,
app = {
    init: function() {
        tips.init();
        slider.init();

        importtype = {
            member: false,
            category: false,
            article: false,
            picture: false,
            comment: false
        };

        this.listen_ajax();
        this._init_version();
        this._unload();
    },

    _init_error: function() {
        error = {
            member: [],
            category: [],
            article: [],
            picture: [],
            comment: []
        };
    },

    _init_version: function() {
        var options = $('option', '#cmsversion').not(':first').detach();
        $('#cmstype').change(function() {
            $('option', '#cmsversion').not(':first').remove();
            var value = $(this).find(':selected').val();
            $('#cmsversion').append(options.filter("[rel='" + value + "']")).val(0);
        }).trigger('change');
    },

    config: function() {
        var that = this;
        $('#config_cms').ajaxSubmit({
            success: function(json) {
                if (json.state) {
                    var next = false, cmstype = $('#cmstype option:selected').text(), cmsversion = $('#cmsversion option:selected').text();

                    $('.status').text(cmstype + ' ' + cmsversion);
                    $('#config_detail').find('p[rel], label[rel]').hide().filter('[rel*=' + $('#cmstype option:selected').val() + $('#cmsversion option:selected').val() + ']').show();

                    // category & data
                    if (json.importtype.data) {
                        $('#importtype_data').attr('checked', true);
                        if (json.data.category) {
                            next = true;
                            importtype.category = true;
                            $('#config_data').show().prev('.line').show();
                            $('#data_status span').text(json.data.category);
                        } else {
                            importtype.category = false;
                        }
                    } else {
                        $('#config_data').hide().prev('.line').hide();
                        $('#importtype_data').attr('checked', false);
                    }

                    // member
                    if (json.importtype.member) {
                        importtype.member = true;
                        $('#importtype_member').attr('checked', true);
                        if (json.member.total) {
                            next = true;
                            $('#config_member').show().prev('.line').show();
                            $('#member_status span').text(json.member.total);
                        }
                    } else {
                        importtype.member = false;
                        $('#config_member').hide();
                        $('#importtype_member').attr('checked', false);
                    }

                    if (next) {
                        slider.show(btn);
                        app.add_more();
                        config.init(json.config);
                    } else {
                        app.show("没有数据需要导入，请检查配置后重新尝试");
                    }
                } else {
                    app.show(json.message);
                }
                return false;
            },
            dataType: 'json'
        });
    },

    start: function() {
        var that = this, form = $('#config_detail');

        form.ajaxSubmit({
            success: function(json) {
                if (json.state) {
                    slider.show(btn);
                    cmd.init();
                    cmd.echo('数据转换开始...');
                    cmd.echo();

                    that._init_error();

                    if (json.member) {
                        var m = json.member;
                        if (m.total) {
                            bp.step({
                                data: 'action=execute&type=member&' + $.param(m),
                                pagesize: config.pagesize('member') ? config.pagesize('member') : m.pagesize,
                                total: m.total,
                                name: '会员'
                            }, 'member');
                        } else {
                            cmd.echo('未找到会员数据，跳过会员转换');
                            cmd.echo();
                        }
                    }

                    if (json.data) {
                        var d = json.data;
                        if (d.total) {
                            if (d.total.category) {
                                bp.step({
                                    data: 'action=execute&type=category&' + $.param(d),
                                    pagesize: config.pagesize('category') ? config.pagesize('category') : d.pagesize.category,
                                    total: d.total.category,
                                    name: '栏目'
                                }, 'category');
                            } else {
                                cmd.echo('未找到栏目数据，跳过栏目转换');
                                cmd.echo();
                            }

                            if (d.article) {
                                importtype.article = true;
                                if (d.total.article) {
                                    bp.step({
                                        data: 'action=execute&type=article&' + $.param(d),
                                        pagesize: config.pagesize('article') ? config.pagesize('article') : d.pagesize.article,
                                        total: d.total.article,
                                        name: '文章'
                                    }, 'article');
                                } else {
                                    cmd.echo('未找到文章数据，跳过文章转换');
                                    cmd.echo();
                                }
                            } else {
                                importtype.article = false;
                            }

                            if (d.picture) {
                                importtype.picture = true;
                                if (d.total.picture) {
                                    bp.step({
                                        data: 'action=execute&type=picture&' + $.param(d),
                                        pagesize: config.pagesize('picture') ? config.pagesize('picture') : d.pagesize.picture,
                                        total: d.total.picture,
                                        name: '组图'
                                    }, 'picture');
                                } else {
                                    cmd.echo('未找到组图数据，跳过组图转换。');
                                    cmd.echo();
                                }
                            } else {
                                importtype.picture = false;
                            }

                            if (d.comment) {
                                importtype.comment = true;
                                if (d.total.comment) {
                                    bp.step({
                                        data: 'action=execute&type=comment&' + $.param(d),
                                        pagesize: config.pagesize('comment') ? config.pagesize('comment') : d.pagesize.comment,
                                        total: d.total.comment,
                                        name: '评论'
                                    }, 'comment');
                                } else {
                                    cmd.echo('未找到评论数据，跳过评论转换');
                                    cmd.echo();
                                }
                            } else {
                                importtype.comment = false;
                            }
                        }
                    }

                    bp.execute();
                } else {
                    app.show(json.message);
                }
            },
            dataType: 'json'
        });
    },

    result: function() {
        var div = $('#result_div').empty(), show = false;

        if (importtype.member && !$.isEmptyObject(error.member)) {
            show = true;
            echo('会员', error.member);
        }

        if (importtype.category && !$.isEmptyObject(error.category)) {
            show = true;
            echo('栏目', error.category);
        }

        if (importtype.article && !$.isEmptyObject(error.article)) {
            show = true;
            echo('文章', error.article);
        }

        if (importtype.picture && !$.isEmptyObject(error.picture)) {
            show = true;
            echo('组图', error.picture);
        }

        if (importtype.comment && !$.isEmptyObject(error.comment)) {
            show = true;
            echo('评论', error.comment);
        }

        if (show) {
            slider.show(btn);
        } else {
            app.show('转换没有发生错误');
        }

        function echo(typename, error) {
            div.append('<p id="data_status"><label class="title">失败的' + typename + ' ID</label><input type="text" value="' + error.join(',') + '" /></p>');
            div.append('<p class="line"></p>');
        }
    },
    
    _unload: function() {
        window.onbeforeunload = function() {
            if (confirm("确定要离开此页面吗？\n\n点击确定离开页面，点击取消留在此页"))
            {
				$.ajax({
					url: base_url + '?action=unload', 
					async: false
				});
            } else {
                return false;
            }
        };
    }, 

    show: function(msg) {
        alert(msg);
    },

    lock: function() {
        $('div.button a').addClass('disabled');
    },

    unlock: function() {
        $('div.button a').removeClass('disabled');
    },

    listen_ajax: function() {
        var message = $('#ajax_message');
        if (!message.size()) {
            message = $('<div id="ajax_message">加载中...</div>').appendTo('body');
        }
        message.hide();
        
        $.ajaxSetup({
            beforeSend: function() {
                app.lock();
                message.show();
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                app.show(textStatus ? textStatus : errorThrown);
                bp.clear();
            },  
            complete: function() {
                app.unlock();
                message.hide();
            }
        });
    },

    add_more: function() {
        $('#config_data_detail .addmore').click(function() {
            var a = $(this), p = a.parent();
            p.after(p.clone(true)).next('p').find('input').val('');
            return false;
        });
        
        $('#config_data_detail .remove').click(function() {
            if ($('#config_data_detail .remove').size() > 1) {
                $(this).parent().remove();
            }
            return false;
        });
    },
    
    _build_checkbox: function(config) {
        var i = 0, d = config.data, j = d.length, result = '';
        for (; i < j; i++) {
            var g = d[i];
            result += '<label><input type="checkbox" name="' + config.name + '" value="' + g.id + '"' + (config.checkall ? ' checked="checked"' : '') + ' />' + g.name + '</label> ';
        }
        return result;
    },

    _build_option: function(config) {
        var i = 0, d = config.data, j = d.length, result = '';
        for (; i < j; i++) {
            var g = d[i];
            result += '<option value="' + g.id + '"' + (g.id == config.select ? ' selected="selected"' : '') + '>' + g.name + '</option>';
        }
        return result;
    }
},

slider = {
    _contents: undefined,
    _nav: undefined,
    init: function() {
        var that = this;
        this._contents = $('.content');
        this._nav = $('.progress ul');

        this._contents.not(':first').hide();
        this._contents.find('.button a').click(function() {
            if ($(this).hasClass('disabled')) {
                return false;
            }
            btn = $(this);
            var callback = btn.attr('callback');
            if (callback) {
                eval(callback + '()');
            } else {
                that.show(btn);
            }
            return false;
        });
    },

    show: function(btn) {
        var btn = $(btn),
        content = btn.closest('.content'),
        op;

        this._nav.find('li').removeClass('current current-prev done');
        if (btn.attr('rel') == 'prev') {
            this._nav.find('li[rel=' + content.attr('rel') + ']').prev('li').prev('li').addClass('current-prev');
            op = content.hide().prev('.content').show().attr('rel');
            this._nav.find('li[rel=' + op + ']').addClass('current').prevAll('li').addClass('done');
        } else {
            op = content.hide().next('.content').show().attr('rel');
            this._nav.find('li[rel=' + op + ']').addClass('current').prev('li').addClass('current-prev done').prevAll('li').addClass('done');
        }
    }
},

cmd = {
    _console: undefined,

    _index: 1,

    init: function() {
        this._console = $('#console');
        this.clear();
    },

    echo: function(msg) {
        this._console.append('<p><span>' + (this._index++) + '</span>' + (msg ? msg : '&nbsp;') + '</p>');
        this._console.stop().animate({scrollTop: '+200'});
    },

    clear: function() {
        this._console.empty();
        this._index = 1;
    }
},

bp = {
    _opt: {
        url: base_url,
        type: 'POST',
        data: undefined,
        dataType: 'json',
        async: false,
        timeout: 600000,
        pagesize: undefined,
        name: '数据',
        total: 0
    },

    _e: [],
    _r: undefined,
    _queue: [],
    _result_queue: [],

    step: function(options, result) {
        this._queue.push(options);
        this._result_queue.push(result);
    },

    _config: function() {
        this._e = [];

        var config = this._queue.shift();
        this._r = this._result_queue.shift();
        if (config) {
            $.extend(this._opt, config);
            return this;
        }

        return false;
    },

    execute: function(start) {
        var start = start ? start : 0, message = $('#ajax_message');

        if (start === 0) {
            if (!this._config()) {
                cmd.echo('数据转换完成。');
                $('.button .disabled', '#import_console').removeClass('disabled');
                message.hide();
                return;
            } else {
                cmd.echo(this._opt.name + '转换开始...');
                message.show();
            }
        }

        var that = this, o = this._opt;

        $.ajax({
            url: o.base_url,
            type: o.type,
            data: (o.data ? o.data + '&' : '') + 'start=' + start + '&pagesize=' + o.pagesize,
            success: function(json) {
                if (json && json.state) {
                    var success = start + o.pagesize;

                    json.error && $.merge(that._e, json.error);

                    cmd.echo(o.name + '转换：' + (start + 1) + ' - ' + (success > o.total ? o.total : success) + ' 条已转换...');

                    if (json.start && json.start >= o.total) {
                        error[that._r] = that._e;
                        cmd.echo(o.name + '转换完成，共转换 ' + o.total + ' 条数据');
                        cmd.echo();

                        that.execute();
                    } else {
                        that.execute(json.start);
                    }
                } else {
                    var message = '未知错误';
                    if (json) message = json.message;
                    cmd.echo(o.name + '转换出错：' + message);
                }
            },
            dataType: o.dataType
        });
    }, 
    
    clear: function() {
        this._e = [];
        this._r = undefined;
        this._queue = [];
        this._result_queue = [];
    }
}, 

config = {
    init: function(config) {
        var p = config.pagesize, d = config.data;
        
        this.pagesize('category', p.category);
        this.pagesize('member', p.member);
        this.pagesize('article', p.article);
        this.pagesize('picture', p.picture);
        this.pagesize('comment', p.comment);
        
        $('[name*=thumb_search]', '#config_data_detail').val(d.thumb_search);
        $('[name*=thumb_replace]', '#config_data_detail').val(d.thumb_replace);
        $('[name*=thumb_prefix]', '#config_data_detail').val(d.thumb_prefix);
        $('[name*=attach_search]', '#config_data_detail').val(d.attach_search);
        $('[name*=attach_replace]', '#config_data_detail').val(d.attach_replace);
        $('[name*=attach_prefix]', '#config_data_detail').val(d.attach_prefix);
        
        for (var i = 0, j = d.content_search.length; i < j; i++) {
            var txt_searchs = $('[name*=content_search]', '#config_data_detail');
            if (!txt_searchs.eq(i).size()) {
                txt_searchs.eq(i - 1).parent().find('.addmore').trigger('click');
            }
            $('[name*=content_search]', '#config_data_detail').eq(i).val(d.content_search[i]);
            $('[name*=content_replace]', '#config_data_detail').eq(i).val(d.content_replace[i].replace('{UPLOAD_URL}', UPLOAD_URL));
        }
    }, 
    
    pagesize: function(type, val) {
        if (parseInt(val)) {
            $('#pagesize_' + type).val(val);
        } else {
            return parseInt($('#pagesize_' + type).val());
        }
    }
}, 

tips = {
    _content: undefined, 
    _overlay: undefined, 
    
    init: function() {
        var that = this;
        this.show();
        
        this._content.load(base_url + 'view/about.html');
        this._content.find('a.next, a.prev').live('click', function() {
            that._content.load($(this).attr('href'));
            that.resize_to($(this).attr('rel-width'));
            $('#ajax_message').hide();
            app.unlock();
            return false;
        });
        this._content.find('.close').live('click', function() {
            that.hide();
            return false;
        });
        
        $('#ajax_message').hide();
        app.unlock();
    }, 
    
    show: function() {
        this._content = $('#tips_content').show();
        this._overlay = $('#tips_overlay').show();
    },
    
    hide: function() {
        this._content.hide();
        this._overlay.hide();
    }, 
    
    resize_to: function(width) {
        var width = width ? width : 560;
        this._content.css({
            'width': width + 'px', 
            'margin-left': Math.floor(width / 2) * -1 - 15 + 'px'
        });
    }
};