<?php
class admin_groupMod extends commonMod
{
    
    // 管理组首页
    public function index()
    {
        $list = $this->model->table('admin_group')->select();
        $this->assign('list', $list);
        $this->display();
    }

    // 管理组添加
    public function add()
    {
        if (empty($_POST['psot_do'])) {
            $this->display();
            return;
        }
        $data = array();
        $data['name'] = in($_POST['name']);

        if (empty($data['name'])) {
            $this->jserror('管理组名称不能为空！');
        }
        
        $admin = $this->model->table('admin_group')->where('id=1')->find(); //查询最高管理员权限
        
        $data['power_value'] = $admin['power_value'];
         
        // 数据库操作
        $this->model->table('admin_group')->data($data)->insert();
        $this->jssuccess('管理组添加成功！');
    }

    // 管理组修改
    public function edit()
    {
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
            }
            $condition['id'] = $id;
            $info = $this->model->table('admin_group')->where($condition)->find(); //获取当前用户信息
            if (empty($info)) {
                $this->error('该管理组不存在！');
                return;
            }
            $this->assign('info', $info);
            $this->display();
            return;
        }
        $data = array();
        $data['name'] = in($_POST['name']);

        if (empty($data['name'])) {
            $this->jserror('管理组名称不能为空！');
        }

        // 数据库操作
        $condition = array();
        $condition['id'] = intval($_POST['id']);
        $this->model->table('admin_group')->data($data)->where($condition)->update();
        $this->jssuccess('管理组修改成功！');
    }

    // 删除管理组
    public function del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }

        if ($id == 1) {
            $this->jserror('管理组保护无法删除！');
            return;
        }

        $condition['id'] = $id;
        $this->model->table('admin_group')->where($condition)->delete();        
        $this->jssuccess('管理组删除成功！');
    }
    
    // 权限设置
    public function auth_edit()
    {  
        if (empty($_POST['psot_do'])) {
            $id=intval($_GET[0]);
            if(empty($id))
			{
				$this->error('参数传递错误');
			}
            
            $info=$this->model->table('admin_group')->where('id='.$id)->find();
            $info['power_value']=explode(',',$info['power_value']); //将权限id分割为数组
            $list=$this->model->table('resource')->where('pid=0')->select();
            $this->assign('list',$list);
			$this->assign('info',$info);
            $this->display();
            return;
        }
        $id=intval($_POST['id']);
        $power_value=in($_POST['auth']);
		$data['power_value']=implode(',',$power_value);
		$this->model->table('admin_group')->data($data)->where('id='.$id)->update();
		$this->jssuccess('权限设置成功！');
    }
    
    public function getauth($pid)
	{
		if(empty($pid))
		{
			return false;
		}
		return $this->model->table('resource')->where('pid='.$pid)->select();
	}

}

?>