<?php

class admin_menuMod extends commonMod
{
    // 菜单首页
    public function index()
    {
        $this->assign('list', $this->getCat());
        $this->display();
    }

    // 菜单添加
    public function add()
    {
        if (empty($_POST['psot_do'])) {
            $this->assign('list', $this->getCat());
            $this->display();
            return;
        }
        $data = array();
        $data['name'] = in($_POST['name']);
        $data['pid'] = intval($_POST['pid']);
        $data['sorter'] = in($_POST['sorter']);
        $data['url'] = in($_POST['url']);
        $data['target'] = intval($_POST['target']);

        if (empty($data['name'])) {
            $this->jserror('菜单名不能为空！');
            return;
        }
        if (empty($data['url'])) {
            $this->jserror('菜单链接不能为空！');
            return;
        }
        if (empty($data['target'])) {
            $this->jserror('菜单目标不能为空！');
            return;
        }

        // 数据库操作
        $this->model->table('admin_menu')->data($data)->insert();
        $this->jssuccess('菜单添加成功！');
    }

    // 菜单修改
    public function edit()
    {
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
            }
            $condition['id'] = $id;
            $info = $this->model->table('admin_menu')->where($condition)->find(); //获取当前菜单信息
            $this->assign('list', $this->getCat());
            $this->assign('info', $info);
            $this->display();
            return;
        }
        $data = array();
        $data['name'] = in($_POST['name']);
        $data['pid'] = intval($_POST['pid']);
        $data['sorter'] = in($_POST['sorter']);
        $data['url'] = in($_POST['url']);
        $data['target'] = intval($_POST['target']);

        if (empty($data['name'])) {
            $this->jserror('菜单名不能为空！');
            return;
        }
        if (empty($data['url'])) {
            $this->jserror('菜单链接不能为空！');
            return;
        }
        if (empty($data['target'])) {
            $this->jserror('菜单目标不能为空！');
            return;
        }

        // 数据库操作
        $condition = array();
        $condition['id'] = intval($_POST['id']);
        $this->model->table('admin_menu')->data($data)->where($condition)->update();
        $this->jssuccess('菜单修改成功！');
    }

    // 菜单隐藏
    public function hide()
    {
        $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
        }
        
        $condition = array();
        $condition['id'] = $id;
        $data['hide']=intval($_GET[1]);
        $this->model->table('admin_menu')->data($data)->where($condition)->update();
        $this->success('菜单状态修改成功！');
    }

    // 删除菜单
    public function del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }
        $condition['id'] = $id;
        $this->model->table('admin_menu')->where($condition)->delete();        
        $this->jssuccess('菜单删除成功！');
    }

    // 获取分类树
    public function getCat($id = 0)
    {
        $data = $this->model->table('admin_menu')->where('status=1')->select();
        $cat = new Category(array(
            'id',
            'pid',
            'name',
            'cname')); 
        return $cat->getTree($data, $id);
    }

}

?>