<?php

class articleMod extends commonMod
{

    //参数读取和设置
    public function setting($name = '', $value = null)
    {
        return $this->modelsetting('article',$name,$value);
    }

    // 管理预设
    public function default_manage()
    {
        if (empty($_POST['psot_do'])) {

        $condition['mark']=$this->setting('mark');
        $info = $this->model->table('model')->where($condition)->find();
        $this->assign('info', unserialize($info['config']));
        $this->display();
        return;

        }

        $data = array();
        $data['default_type']=intval($_POST['default_type']);
        $data['default_class_tpl']=in($_POST['default_class_tpl']);
        $data['default_content_tpl']=in($_POST['default_content_tpl']);
        $data['default_num']=intval($_POST['default_num']);
        $data['default_author']=in($_POST['default_author']);
        $data['default_picoff']=intval($_POST['default_picoff']);
        $data['default_onepic']=intval($_POST['default_onepic']);
        $data['default_gettag']=intval($_POST['default_gettag']);

        $condition['mark']=$this->setting('mark');
        $moddata['config']=serialize($data);
        $this->model->table('model')->data($moddata)->where($condition)->update();
        $this->jssuccess('模型预设设置成功！');
        
    }

    // 文章列表页面
    public function index()
    {
        $cid = intval($_GET[0]); //获取所属分类信息
        $mid = $this->model_id();
        $condition = array();
        $where = "";

        $url = __URL__ . '/index-page-{page}.html'; //分页基准网址
        // 分类下的文章
        if (!empty($cid)) {
            $condition['id'] = $cid;
            $cur_cat = $this->model->table('channel')->where($condition)->find(); //获取当前栏目信息
            $this->assign('cur_cat', $cur_cat);
            unset($condition);
            $condition['cid'] = $cid; //增加设定记录数条件
            $cuwhere = ' AND cid=' . $cid;
            $where = ' AND A.cid=' . $cid; //查询条件
            $url = __URL__ . '/index-' . $cid . '-{page}.html'; //分页基准网址

        }

        $page = new Page();
        $listRows = 20; //每页显示记录
        $cur_page = $page->getCurPage($url);
        $limit_start = ($cur_page - 1) * $listRows;
        $limit = $limit_start . ',' . $listRows;

        $where1 = 'WHERE A.mid=' . $mid; //查询条件
        if($_SESSION[$this->config['spot'] . 'admin_gid']<>1){
        $auth_class=module('plus')->auth_class();//获取有权限的栏目
        if(!empty($auth_class)){
        $where2 =' AND A.cid in ('.$auth_class.') ';
        $count_where =' AND cid in ('.$auth_class.') ';
        }
        }
        $langid=$this->getlangid();//获取语言ID
        if(!empty($langid)){
        $count_where2= ' AND lang='.$langid;
        $where3= ' AND A.lang='.$langid;
        }

        $count = $this->model->table('content')->where('mid='.$mid.$count_where.$cuwhere.$count_where2)->count(); //总记录数

        $sql = "SELECT A.id,A.cid,A.mid,A.title,A.style_color,A.style_bold,A.style_italic,A.url,A.status,A.pic,A.hits,A.good,A.time,A.time,B.ext_mid,B.name as cname FROM {$this->model->pre}content A LEFT JOIN {$this->model->pre}channel B ON A.cid = B.id {$where1}{$where}{$where2}{$where3} ORDER BY A.id DESC LIMIT {$limit}";
        $list = $this->model->query($sql); //执行查询

        if(!empty($langid)){
        $clist_where['lang']=$langid;
        }
        $clist_where['mid'] = $mid;
        $clist = $this->model->table('channel')->where($clist_where)->order('id desc')->select(); //获取模型内栏目列表
        

        $this->assign('clist', $clist);
        $this->assign('list', $list);
        $this->assign('cid', $cid);
        $this->assign('cat', $this->getCat());
        $this->assign('count_page', $count_page);
        $this->assign('mid', $mid);
        $this->assign('page', $this->page($url, $count, $listRows));
        $this->display();


    }

    // 文章搜索页面
    public function search()
    {
        $mid = $this->model_id();
        $keyword = in($_POST['keyword']);

        $url = __URL__ . '/search-page-{page}.html'; //分页基准网址
        $page = new Page();
        $listRows = 20; //每页显示记录
        $cur_page = $page->getCurPage($url);
        $limit_start = ($cur_page - 1) * $listRows;
        $limit = $limit_start . ',' . $listRows;

        if($_SESSION[$this->config['spot'] . 'admin_gid']<>1){
        $auth_class=module('plus')->auth_class();//获取有权限的栏目
        if(!empty($auth_class)){
        $where2 =' AND A.cid in ('.$auth_class.') ';
        $count_where =' AND cid in ('.$auth_class.') ';
        }
        }

        $langid=$this->getlangid();
        if(!empty($langid)){
        $count_where2= ' AND lang='.$langid;
        $where3= ' AND A.lang='.$langid;
        }
        //获取结束

        $condition = ' title like "%' . $keyword . '%" AND mid=' . $this->model_id().$count_where.$count_where2;
        $count = $this->model->table('content')->where($condition)->count(); //总记录数

        $where = ' AND A.title like "%' . $keyword . '%"';
        $where1 = 'WHERE A.mid=' . $mid; //查询条件
        $sql = "SELECT A.id,A.cid,A.mid,A.title,A.style_color,A.style_bold,A.style_italic,A.url,A.status,A.pic,A.hits,A.good,A.time,A.time,B.name as cname FROM {$this->model->pre}content A LEFT JOIN {$this->model->pre}channel B ON A.cid = B.id {$where1}{$where}{$where2}{$where3} ORDER BY A.id DESC LIMIT {$limit}";
        $list = $this->model->query($sql); //执行查询

        if(!empty($langid)){
        $clist_where['lang']=$langid;
        }
        $clist_where['mid'] = $mid;
        $clist = $this->model->table('channel')->where($clist_where)->order('id desc')->select(); //获取模型内栏目列表
        $this->assign('clist', $clist);
        $this->assign('cat', $this->getCat());
        $this->assign('count_page', $count_page);
        $this->assign('mid', $mid);
        $this->assign('keyword', $keyword);
        $this->assign('list', $list);
        $this->assign('page', $this->page($url, $count, $listRows));
        $this->display();

    }


    // 发布文章
    public function add()
    {
       
        if (empty($_POST['psot_do'])) {
            $cid = intval($_GET[0]);
            $cat = $this->getCat(); //获取格式化后的分类树
            $this->assign('mid', $this->model_id()); //模型ID
            $this->assign('model_info', unserialize($this->setting('config'))); //获取模型预设
            $this->assign('cat', $cat); //分类
            $this->assign('cid', $cid); 
            $this->display();
            return;
        }
        // 获取数据
        $this->auth_class(intval($_POST['cid'])); //权限栏目认证

        $data = array();
        $data['cid'] = intval($_POST['cid']); //文章分类
        $data['hits'] = in($_POST['hits']); //是否置顶
        $data['good'] = in($_POST['good']); //是否推荐
        $data['sorter'] = intval($_POST['sorter']); //文章排序
        $data['title'] = in($_POST['title']); //文章标题
        $data['style_color'] = in($_POST['style_color']); //标题颜色
        $data['style_bold'] = in($_POST['style_bold']); //标题加粗
        $data['style_italic'] = in($_POST['style_italic']); //标题斜体
        $data['url'] = in($_POST['url']); //文章跳转地址
        $data['views'] = intval($_POST['views']); //文章浏览量
        $data['pic'] = in($_POST['pic']); //文章缩略图
        $data['description'] = in($_POST['description']); //摘要
        $data['keywords'] = in($_POST['keywords']); //关键词
        $data['status'] = html_in($_POST['status']); //是否发布
        $data['author'] = in($_POST['author']); //作者
        $data['time'] = strtotime(in($_POST['time'])); //时间
        $data['mid'] = intval($this->model_id()); //模型ID
        $data['lang'] = $this->getlangid(); //语言id

        if (empty($data['description'])) {
        $data['description']=in(substr(deletehtml($_POST['content']), 0, 250)); //自动提取描述   
        }

        if (empty($_POST['pinyin'])) {
            $py = new Pinyin();
            $title_pinyin = preg_replace("/[^\x{4e00}-\x{9fa5}\w]/u", '', $data['title']);
            $data['pinyin'] = substr($py->output($title_pinyin, $utf8 = true), 0, 50);
        } else {
            $title_pinyin = preg_replace("/[^\w]/u", '', $_POST['pinyin']);
            $data['pinyin'] = in($title_pinyin); //标题拼音
        }

        // 验证数据
        if (empty($data['title'])) {
            $this->error('标题不能为空！');
            return;
        }
        if (empty($data['cid'])) {
            $this->error('栏目未选择！');
            return;
        }

        if(!empty($_POST['picoff'])){
        $data2['content'] = html_in(module('plus')->index($_POST['content'])); //内容
        }else{
        $data2['content'] = html_in($_POST['content']); //内容
        }

        if(empty($data['pic'])){
          if(!empty($_POST['onepic'])){
            $data['pic']= in(module('plus')->onepic(html_out($data2['content']))); //获取第一张图片为缩略图
          }
        }

        if(empty($data['keywords'])){
          if(!empty($_POST['gettag'])){
            $data['keywords']= in(module('plus')->getkeyword($data['title'],$data['description'])); //获取关键词
          }
        }
		
        // 数据库操作
        $id = $this->model->table('content')->data($data)->insert();
        $data2['aid'] = $id; //文章ID
        $data2['cid'] = intval($_POST['cid']); //文章分类
        $this->model->table('content_data')->data($data2)->insert();
        // tag cloud
        if (!empty($data['keywords'])) {
            module('plus')->addtag($data['keywords'],$id);
        }

        //扩展模型
        if (!empty($_POST['my_id'])) {
            module('plus')->addplus($_POST,$id);  //扩展模型
        }
		
		$_POST['id']=$id;
		$ext_data=$_POST;
		$this->plus_hook('content','add',$ext_data);   //插件钩子

        $this->content_success('内容添加成功！',$id,$data['cid']);


    }

    // 编辑文章
    public function edit()
    {

        
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
            }
            
            $condition['id'] = $id;
            $info = $this->model->table('content')->where($condition)->find(); //获取当前分类信息
            if (empty($info)) {
                $this->error('该内容不存在或被删除！');
                return;

            }

            $this->auth_class($info['cid']); //权限栏目认证
			
            $contentid['aid'] = $id;
            $content = $this->model->table('content_data')->where($contentid)->find(); //获取当前文章内容
            $cat = $this->getCat(); //获取格式化后的分类树

            $channel_condition['id'] = $info['cid'];
            $channel_info = $this->model->table('channel')->field('ext_mid')->where($channel_condition)->find(); //查询所属栏目信息
            if ($channel_info['ext_mid']) {
                $my_condition['id'] = $channel_info['ext_mid'];
                $my_model = $this->model->table('plus_model')->where($my_condition)->find(); //获取当前附加模型信息
                $my_list_condition['pid'] = $my_model['id'];
                $my_list = $this->model->table('plus_model')->where($my_list_condition)->select();
                $field_condition['my_aid'] = $id;
                $field_list = $this->model->table($my_model['table'])->where($field_condition)->select();
            }


            $this->assign('model_info', unserialize($this->setting('config'))); //获取模型预设
            $this->assign('mid', $this->model_id()); //模型ID
            $this->assign('info', $info); //文章信息
            $this->assign('content', $content);
            $this->assign('cat', $cat); //分类
            $this->assign('my_model', $my_model); //附加模型
            $this->assign('my_list', $my_list); //附加模型列表
            $this->assign('field_list', $field_list); //附加表列表
            $this->display();
            return;
        }
        $this->auth_class(intval($_POST['cid'])); //权限栏目认证
        // 获取数据
        $data = array();
        $data['cid'] = intval($_POST['cid']); //文章分类
        $data['hits'] = in($_POST['hits']); //是否置顶
        $data['good'] = in($_POST['good']); //是否推荐
        $data['sorter'] = intval($_POST['sorter']); //文章排序
        $data['title'] = in($_POST['title']); //文章标题
        $data['style_color'] = in($_POST['style_color']); //标题颜色
        $data['style_bold'] = in($_POST['style_bold']); //标题加粗
        $data['style_italic'] = in($_POST['style_italic']); //标题斜体
        $data['url'] = in($_POST['url']); //文章跳转地址
        $data['views'] = intval($_POST['views']); //文章浏览量
        $data['pic'] = in($_POST['pic']); //文章缩略图
        $data['description'] = in($_POST['description']); //摘要
        $data['keywords'] = in($_POST['keywords']); //关键词
        $data['status'] = html_in($_POST['status']); //是否发布
        $data['author'] = in($_POST['author']); //作者
        $data['time'] = strtotime(in($_POST['time'])); //时间

        if (empty($data['description'])) {
        $data['description']=in(substr(deletehtml($_POST['content']), 0, 250)); //自动提取描述   
        }

        if (empty($_POST['pinyin'])) {
            $py = new Pinyin();
            $title_pinyin = preg_replace("/[^\x{4e00}-\x{9fa5}\w]/u", '', $data['title']);
            $data['pinyin'] = substr($py->output($title_pinyin, $utf8 = true), 0, 50);
        } else {
            $title_pinyin = preg_replace("/[^\w]/u", '', $_POST['pinyin']);
            $data['pinyin'] = in($title_pinyin); //标题拼音
        }

        // 验证数据
        if (empty($data['title'])) {
            $this->error('标题不能为空！');
            return;
        }
        if (empty($data['cid'])) {
            $this->error('栏目为选择！');
            return;
        }

        if(!empty($_POST['picoff'])){
        $data2['content'] = html_in(module('plus')->index($_POST['content'])); //内容
        }else{
        $data2['content'] = html_in($_POST['content']); //内容
        }


        if(empty($data['pic'])){
          if(!empty($_POST['onepic'])){
            $data['pic']= in(module('plus')->onepic(html_out($data2['content']))); //获取第一张图片为缩略图
          }
        }

        if(empty($data['keywords'])){
          if(!empty($_POST['gettag'])){
            $data['keywords']= in(module('plus')->getkeyword($data['title'],$data['description'])); //自动分词
          }
        }

        // 数据库操作
        $condition['id'] = intval($_POST['id']);
        $this->model->table('content')->data($data)->where($condition)->update();
        
        $data2['cid'] = intval($_POST['cid']); //文章分类
        $contentid['aid'] = intval($_POST['id']);
        $this->model->table('content_data')->data($data2)->where($contentid)->update();
        // tag cloud
        if (!empty($data['keywords'])) {
            module('plus')->edittag($data['keywords'],$condition['id']);
        }

        //扩展模型
        if (!empty($_POST['my_id'])) {
            module('plus')->editplus($_POST);  //扩展模型
        }
        //扩展模型结束
		$ext_data=$_POST;
		$this->plus_hook('content','edit',$ext_data);   //插件钩子
        $this->content_success('内容编辑成功！',$condition['id'],$data['cid']);

    }


    // 获取分类树，$id，分类id,$id=0，获取所有分类结构树
    public function getCat($id = 0)
    {
        $langid=$this->getlangid();
        if(!empty($langid)){
            $condition['lang']=$langid;
        }

        // 查询分类信息
        $data = $this->model->field('id,pid,name,mid,type')->table('channel')->where($condition)->select();
        // array('id','pid','name','cname'),字段映射，格式化后的分类名次问cname
        $cat = new Category(array(
            'id',
            'pid',
            'name',
            'cname')); //初始化无限分类
        return $cat->getTree($data, $id); //获取分类数据树结构
    }


    //获取模型信息
    public function model_info()
    {
        $conditionmod['mark'] = "article";
        return $this->model->table('model')->where($conditionmod)->find();
    }
    //获取模型ID
    public function model_id()
    {
        $conditionmod['mark'] = "article";
        $model = $this->model->table('model')->where($conditionmod)->find();
        return $model['id'];
    }

    // 删除文章
    public function del()
    {
        
        $id = intval($_GET[0]);
		
        if (empty($id)) {
            $this->error('参数传递错误！');
            return;
        }
		$_POST['id']=$id;
        $condition['id'] = $id;
        $info = $this->model->table('content')->field('id,cid')->where($condition)->find();
        $this->auth_class($info['cid']); //权限栏目认证

		$list_condition['id'] = $info['cid'];
        $list_info = $this->model->table('channel')->field('ext_mid')->where($list_condition)->find(); //查询栏目信息

        if ($list_info['ext_mid']) {
            module('plus')->del_ext_field($list_info['ext_mid'],$id); //扩展模型字段删除
        }

        $condition['id'] = $id;
        $this->model->table('content')->where($condition)->delete();
        $contentid['aid'] = $id;
        $this->model->table('content_data')->where($contentid)->delete();
		
		$this->plus_hook('content','del',$id); //插件钩子
		
        $this->success('内容删除成功！', __URL__.'/index-'.$info['cid']);
        return;
    }


    // 修改状态
    public function state()
    {

        
        if (empty($_GET[0]) || empty($_GET[1]) || (!isset($_GET[2]))) {
            $this->jserror('参数传递错误！');
            return;
        }

        $condition['id'] = $_GET[1];
        $info = $this->model->table('content')->field('id,cid')->where($condition)->
            find();
        if(!$this->auth_class_if($info['cid'])){//权限栏目认证
            $this->jserror('您无权限修改状态！');
            return;
        }

        if (in_array($_GET[0], array(
            'hits',
            'good',
            'status')) && in_array($_GET[2], array(0, 1))) {
            $field = $_GET[0];
            $data[$field] = intval($_GET[2]);
            $condition['id'] = intval($_GET[1]);
            if ($this->model->table('content')->data($data)->where($condition)->update()) {
                $this->jssuccess('修改成功！');
            } else {
                $this->jserror('修改失败');
                return;
            }
        } else {
            $this->jserror('非法操作');
            return;
        }
    }


    // 批量操作
    public function batch_manage()
    {
        
        $mode = intval($_POST['mode']);
        $checkbox = $_POST['id'];
        if (empty($checkbox)) {
            $this->error('未选择文章！');
            exit;
        }
        $in = implode(',', $checkbox);
        $condition = "id in($in)";
        $condition2 = "aid in($in)";
        $post_id=intval($_POST['post_id']);
        switch ($mode) {
            case 1:
                $ary = explode(",", $in);
                foreach ($ary as $val) {

                    $info = $this->model->table('content')->field('id,cid')->where('id=' . $val)->
                        find(); //获取文章信息
                    $channel_info = $this->model->table('channel')->field('id,ext_mid')->where('id=' .
                        $info['cid'])->find(); //获取栏目信息
                    if ($channel_info['ext_mid']) {
                        module('plus')->del_ext_field($channel_info['ext_mid'],$val); //扩展模型字段删除
                    }
                    $this->model->table('content')->where('id=' . $val)->delete(); //删除主表内容
                    $this->model->table('content_data')->where('aid=' . $val)->delete(); //删除内容部内容
                }
                break;
            case 2:
                $this->model->table('content')->data('status=0')->where($condition)->update();
                break;
            case 3:
                $this->model->table('content')->data('status=1')->where($condition)->update();
                break;
            case 4:
                $data['cid'] = in($_POST['cid']);
                $this->model->table('content')->data($data)->where($condition)->update();

                $data2['cid'] = in($_POST['cid']);
                $this->model->table('content_data')->data($data2)->where($condition2)->update();
                break;
        }
		$this->plus_hook('content','batch_manage',$in); //插件钩子获取批量操作ID
		
        $this->success('批量操作成功！', __URL__.'/index-'.$post_id);
        return;
    }
}

?>