<?php

class article_channelMod extends commonMod
{

    // 添加文章分类
    public function add()
    {
        $this->auth(7); //权限认证
        if (empty($_POST['psot_do'])) {
            $mid = intval($_GET[0]); //模型ID获取

            // 列出模板文件
            $lang_open=$this->config['LANG_OPEN'];

            if(!$lang_open){
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH'));
            }else{
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH').__LANG__); 
            }
            
            $model_list = $this->model->table('plus_model')->where('pid=0')->select();
            
            $this->assign('model_list', $model_list); //扩展模型列表
            $this->assign('model_info', unserialize($this->modelsetting('article','config'))); //获取模型预设
            $this->assign('mid', $mid); //模型ID
            $this->assign('cat', $this->getCat()); //获取格式化后的分类树
            $this->assign('tpl_dir', $tpl_dir); //模版文件获取
            $this->display();
            return;
        }
        // 获取数据
        $data = array();
        $data['pid'] = intval($_POST['pid']); //上一级分类id
        $data['size'] = in($_POST['size']); //前台分页数
        $data['name'] = in($_POST['name']); //分类名称
        $data['seoname'] = in($_POST['seoname']); //seo分类名称
        $data['keywords'] = in($_POST['keywords']); //关键词，目的分类列表页面SEO优化
        $data['description'] = in($_POST['description']); //关键词描述，目的分类列表页面SEO优化
        $data['pic'] = in($_POST['pic']); //栏目形象图
        $data['type'] = in($_POST['type']); //栏目属性
        $data['hide'] = in($_POST['hide']); //菜单显示
        $data['sorter'] = in($_POST['sorter']); //菜单排序
        $data['url'] = in($_POST['url']); //外部链接
        $data['tpl_list'] = in($_POST['tpl_list']); //列表模板
        $data['tpl_content'] = in($_POST['tpl_content']); //文章模板
        $data['ext_mid'] = in($_POST['ext_mid']); //扩展模型
        $data['lang'] = $this->getlangid(); //语言id

        //隐藏信息
        $data['mid'] = in($_POST['mid']); //模型ID

		if (empty($_POST['pinyin'])) {
		$data['pinyin']=module('plus')->pinyin($data['name']); //为空自动转换
		}else
		{
		$data['pinyin']=module('plus')->ifpinyin($_POST['pinyin']); //过滤
		}

        // 验证数据
        if (empty($data['name'])) {
            $this->error('栏目名称不能为空！');
            return;
        }
        if (empty($data['mid'])) {
            $this->error('模型ID错误！');
            return;
        }
        // 数据库操作
        if ($cid=$this->model->table('channel')->data($data)->insert()) //插入数据
        {
            
            $this->auth_class_add($cid,$data['name']);//权限添加
			
			$this->plus_hook('channel','add',$cid); //插件钩子
            
            $this->class_success('栏目添加成功！',$cid);
            
        } else {
            $this->error('栏目添加失败！');
        }


    }

    // 编辑文章分类
    public function edit()
    {
        $this->auth(8); //权限认证
        // 没有提交数据，显示编辑页面
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]); //获取栏目ID
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
                
            }
            $condition['id'] = $id;
            $info = $this->model->table('channel')->where($condition)->find(); //获取当前分类信息
            if (empty($info)) {
                $this->error('该分类不存在或被删除！');
                return;
            }
            
            // 列出模板文件
            $lang_open=$this->config['LANG_OPEN'];
            if(!$lang_open){
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH'));
            }else{
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH').__LANG__); 
            }
            
            $model_list = $this->model->table('plus_model')->where('pid=0')->select();
            
            $this->assign('model_list', $model_list); ////扩展模型列表           
            $this->assign('info', $info); //栏目信息
            $this->assign('cat', $this->getCat()); //获取格式化后的分类树
            $this->assign('tpl_dir', $tpl_dir); //模版文件获取
            $this->display();
            return;
        }
        
        // 获取数据
        $data = array();
        $data['pid'] = intval($_POST['pid']); //上一级分类id
        $data['size'] = in($_POST['size']); //前台分页数
        $data['name'] = in($_POST['name']); //分类名称
        $data['seoname'] = in($_POST['seoname']); //seo分类名称
        $data['keywords'] = in($_POST['keywords']); //关键词，目的分类列表页面SEO优化
        $data['description'] = in($_POST['description']); //关键词描述，目的分类列表页面SEO优化
        $data['pic'] = in($_POST['pic']); //栏目形象图
        $data['type'] = in($_POST['type']); //栏目属性
        $data['hide'] = in($_POST['hide']); //菜单显示
        $data['sorter'] = in($_POST['sorter']); //菜单排序
        $data['url'] = in($_POST['url']); //外部链接
        $data['tpl_list'] = in($_POST['tpl_list']); //列表模板
        $data['tpl_content'] = in($_POST['tpl_content']); //文章模板
        $data['ext_mid'] = in($_POST['ext_mid']); //扩展模型

        //隐藏信息
        $data['id'] = in($_POST['id']); //ID

		if (empty($_POST['pinyin'])) {
		$data['pinyin']=module('plus')->pinyin($data['name']); //为空自动转换
		}else
		{
		$data['pinyin']=module('plus')->ifpinyin($_POST['pinyin'],$data['id']); //过滤
		}
                
        // 验证数据
        if (empty($data['name'])) {
            $this->error('栏目名称不能为空！');
            return;
        }
        if ($data['pid'] == $data['id']) {
            $this->error('不可以将当前栏目设置为上一级栏目！');
            return;
        }
        
        // 不能将自己的上一级分类，移动到自己的子栏目中
        $cat = $this->getCat($data['id']); //获取$data['id']的所有下级栏目
        if (!empty($cat)) {
            foreach ($cat as $vo) {
                if ($data['pid'] == $vo['id']) {
                    $this->error('不可以将上一级栏目移动到子栏目！');
                    return;
                }
            }
        }
        // 数据库操作
        $condition = array();
        $condition['id'] = $data['id'];
        $this->model->table('channel')->data($data)->where($condition)->update();
        
        $this->auth_class_edit($data['id'],$data['name']);//权限修改
		
        $this->plus_hook('channel','edit',$data); //插件钩子
        
        $this->class_success('栏目修改成功！',$data['id']);

    }

    // 删除分类
    public function del()
    {
        
        $id = intval($_GET[0]); //获取传递信息
        if (empty($id)) {
            $this->jserror('参数传递错误！');
            return;
        }
        $this->auth(9); //权限认证
        // 检测子栏目是否存在
        $condition = array();
        $condition['pid'] = $id;
        if ($this->model->table('channel')->where($condition)->count()) {
            $this->jserror('请先删除该栏目下面的子栏目！');
            return;
        }
		unset($condition); //将上一次查询条件清空
		$condition_aid['cid'] = $id;
		if ($this->model->table('content')->where($condition_aid)->count()) {
            $this->jserror('请先删除该栏目下面的内容！');
            return;
        }
        $condition['id'] = $id;
        $this->model->table('channel')->where($condition)->delete(); //删除栏目
        $condition2['cid'] = $id;
        $this->model->table('content')->where($condition2)->delete(); //删除栏目文章信息
        $condition3['cid'] = $id;
        $this->model->table('content_data')->where($condition3)->delete(); //删除栏目文章内容
        
        //权限操作
        $auth_condition['cid']=$id;
        $this->model->table('resource')->where($auth_condition)->delete(); //删除权限栏目
        //权限操作结束
		
		$this->plus_hook('channel','del',$id); //插件钩子

        $this->jssuccess('栏目删除成功！');
    }


    // 获取分类树，$id，分类id,$id=0，获取所有分类结构树
    public function getCat($id = 0)
    {
        $langid=$this->getlangid();
        if(!empty($langid)){
            $condition['lang']=$langid;
        }

        $data = $this->model->field('id,pid,name')->table('channel')->where($condition)->select();
        $cat = new Category(array('id', 'pid', 'name', 'cname')); //初始化无限分类
        return $cat->getTree($data, $id); //获取分类数据树结构
    }
}

?>