<?php

// 分类管理
class channelMod extends commonMod
{
    public function __construct()
    {
        parent::__construct();
    }
    // 分类首页
    public function index()
    {
        $model_list = $this->model->table('model')->order('id asc')->select(); //模型列表
        $this->assign('model_list', $model_list);
        $this->assign('cat', $this->getCat());
        $this->display();
    }

    // 栏目添加
    public function add()
    {
        $this->auth(7);//权限认证
        if (empty($_POST['psot_do'])) {
            if(!$lang_open){
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH'));
            }else{
            $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH').__LANG__); 
        }

        $model_list = $this->model->table('model')->select();
        $this->assign('model_list', $model_list); //模型列表
        $this->assign('cat', $this->getCat());
        $this->assign('tpl_dir', $tpl_dir); //模版文件获取
        $this->display();
        return;
        }

        if(!module('common')->auth_if(7)) {
          $this->jserror('无权限进行操作！');
          return; 
        }

        $data['mid']=intval($_POST['mid']);//模型ID
        $data['pid']=intval($_POST['pid']);//上级栏目ID
        $data['name']=in($_POST['name']);//栏目名称
        $data['pinyin']=in($_POST['pinyin']);//栏目拼音
        $data['size']=intval($_POST['size']);//分页
        $data['type']=intval($_POST['type']);//栏目属性
        $data['tpl_list']=in($_POST['tpl_list']);//栏目模板
        $data['tpl_content']=in($_POST['tpl_content']);//内容模板
        $data['lang'] = $this->getlangid(); //语言id

        if(empty($data['mid'])){
        $this->jserror('模型未选择或者未添加模型!');
        }

        if(empty($data['name'])){
        $this->jserror('栏目名称不能为空！');
        }
        if(empty($data['size'])){
        $this->jserror('分页数不能为空！');
        }
        if(empty($data['tpl_list'])){
        $this->jserror('栏目模板不能为空！');
        }
        if(empty($data['tpl_content'])){
        $this->jserror('内容模板不能为空！');
        }

        if(empty($data['pinyin'])){
            $data['pinyin']=module('plus')->pinyin($data['name']); //为空自动转换
        }else{
            $data['pinyin']=module('plus')->ifpinyin($_POST['pinyin']); //过滤
        }

        // 数据库操作
        if ($cid=$this->model->table('channel')->data($data)->insert()) //插入数据
        {
            $this->auth_class_add($cid,$data['name']);//权限添加
            $this->plus_hook('channel','add',$cid); //插件钩子
            $this->jssuccess('栏目添加成功！');
        } else {
            $this->jserror('栏目添加失败！');
        }



    }

    public function getCat($id = 0)
    {
        $langid=$this->getlangid();
        if(!empty($langid)){
            $where='WHERE A.lang='.$langid;
        }
        $sql = "SELECT A.id,A.pid,A.type,A.sorter,A.name,B.add_name,B.add_url,B.edit_name,B.edit_url,B.del_url,B.id as model_id,B.name as model_name FROM {$this->model->pre}channel A LEFT JOIN {$this->model->pre}model B ON A.mid = B.id {$where} ORDER BY A.sorter DESC , A.id ASC";
        $data = $this->model->query($sql);
        $cat = new Category(array('id', 'pid', 'name', 'cname'));
        return $cat->getTree($data, $id);
    }
	
	// AJAX排序
    public function sorter()
    {
        $data['sorter']=intval($_POST['sorter']);
        $condition['id']=intval($_POST['id']);
       if($this->auth_if(8)){
        $this->model->table('channel')->data($data)->where($condition)->update(); 
        $this->jssuccess('排序成功！');
       }else{
        $this->jserror('您无权进行栏目操作！');
       }
		
	}

    // 批量添加栏目
    public function add_all()
    {
       
       $this->auth(7);//权限认证
       if (empty($_POST['psot_do'])) {
        
        // 列出模板文件
        $lang_open=$this->config['LANG_OPEN'];
        if(!$lang_open){
        $tpl_dir = module('plus')->dirhtml(__ROOTDIR__ . "/" . $this->getconfig('TPL_TEMPLATE_PATH'));
        }else{
        $tpl_dir = module('plus')->dirhtml(__ROOTDIR__  . "/" . $this->getconfig('TPL_TEMPLATE_PATH').__LANG__); 
        }

        $model_list = $this->model->table('model')->select();
        $this->assign('model_list', $model_list); //模型列表
        $this->assign('cat', $this->getCat());
        $this->assign('tpl_dir', $tpl_dir); //模版文件获取
        $this->display();
        // 关闭模板文件
        return;
        }

        if(!module('common')->auth_if(7)) {
          $this->jserror('无权限进行操作！');
          return; 
        }

        $data['mid']=intval($_POST['mid']);//模型ID
        $data['pid']=intval($_POST['pid']);//上级栏目ID
        $data['size']=intval($_POST['size']);//内容模板
        $data['tpl_list']=in($_POST['tpl_list']);//栏目模板
        $data['tpl_content']=in($_POST['tpl_content']);//内容模板
        $data['type']=intval($_POST['type']);//栏目属性
		$data['lang'] = $this->getlangid(); //语言id

        
        $str = in($_POST['channel_name']);
        if(empty($str)){
        $this->jserror('栏目未填写');
        }
        if(empty($data['mid'])){
        $this->jserror('模型传输错误');
        }
        if(empty($data['size'])){
        $this->jserror('分页未填写');
        }
        if(empty($data['tpl_list'])){
        $this->jserror('栏目模版未选择');
        }
        if(empty($data['tpl_content'])){
        $this->jserror('内容模版未选择');
        }

        $strArray = explode("\n", $str);
        foreach ($strArray as $list) {
            $listname=explode("|", $list);
            $data['name']=in($listname[0]);//栏目名称
            $data['pinyin']=in($listname[1]);//栏目拼音
            if (empty($data['pinyin'])) {
              $this->jserror('栏目英文名添加未完整！');
              return;
            }
            $data['pinyin']=module('plus')->ifpinyin($data['pinyin']); //过滤
            $cid=$this->model->table('channel')->data($data)->insert();
            $this->auth_class_add($cid,$data['name']);//权限添加
            $this->plus_hook('channel','add',$cid); //插件钩子
        }
        $this->jssuccess('添加成功！');
        
    }

    //复制栏目
    public function copy_class()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->error('ID传输错误！');
        }

        $this->auth(7);//权限认证

        $info = $this->model->table('channel')->where('id=' . $id)->find(); //查询当前栏目ID
        if(empty($info)){
            $this->error('栏目不存在！');
        }

        foreach ($info as $key => $value) {
           if($key<>'id'){
             if($key=='pinyin'){
                $data['pinyin']=$value.module('plus')->getcode(); //拼音
                $data['pinyin']=module('plus')->ifpinyin($data['pinyin']); //过滤
             }else if($key=='name'){
                $data[$key]=$value.'_复制';
             }else{
                $data[$key]=$value;
             }
           }
        }
        $pid = $this->model->table('channel')->data($data)->insert(); //插入新的主栏目
        $this->auth_class_add($pid,$data['name']);//权限添加
        $count=$this->model->table('channel')->where('pid='.$info['id'])->count(); //查询子栏目数量
        $this->plus_hook('channel','add',$pid); //插件钩子

        if($count<>0){ //如果子栏目不为0则进行子栏目的插入
            $this->copy_add_class($pid,$info);
        }
        $this->success('栏目复制成功！', __URL__);
        
    }

    //复制添加栏目
    public function copy_add_class($pid,$info) 
    {

        $list = $this->model->table('channel')->where('pid='.$info['id'])->order('id asc')->select();

            foreach ($list as $class) { //循环出查询到的子栏目

                foreach ($class as $key => $value) {
                  if($key<>'id'){
                    if($key=='pinyin'){
                       $data['pinyin']=$value.module('plus')->getcode(); //拼音
                       $data['pinyin']=module('plus')->ifpinyin($data['pinyin']); //过滤
                    }else if($key=='pid'){
                       $data[$key]=$pid;  //上级ID
                    }else{
                       $data[$key]=$value;  //其他值
                    }
                  }
                }
                $copyid = $this->model->table('channel')->data($data)->insert(); //插入子栏目
                $this->auth_class_add($copyid,$data['name']);//权限添加
                $this->plus_hook('channel','add',$copyid); //插件钩子
                $count=$this->model->table('channel')->where('pid='.$class['id'])->count(); 
                if($count<>0){ //如果又执行
                    $this->copy_add_class($copyid,$class); //如果有下级栏目进行递归
                }

            }

    }


    

}

?>