<?php
class loginMod extends commonMod
{
    public function __construct()
    {
        parent::__construct();
    }

    // 登录页面
    public function index()
    {
        $this->display();
    }

    public function login()
    {
        // 获取数据
        $user = in($_POST['user']);
        $password = md5($_POST['password']);
        $checkcode = $_POST['checkcode'];
        // 数据验证
        if (empty($user)) {
            echo json_encode(array("msg" => '请输入用户名', "result" => '0'));
            return;
        }
        if (empty($_POST['password'])) {
            echo json_encode(array("msg" => '请输入密码', "result" => '0'));
            return;
        }
        if (empty($_POST['checkcode'])) {
            echo json_encode(array("msg" => '请输入验证码', "result" => '0'));
            return;
        }
        if ($checkcode != $_SESSION['verify']) {
            echo json_encode(array("msg" => '验证码错误', "result" => '0'));
            return;
        }

        // 数据库操作
        if ($this->_login($user, $password)) {
            echo json_encode(array("msg" => '登录成功！', "result" => '1'));
        } else {
            echo json_encode(array("msg" => '用户名或密码错误或帐号被禁用，请重新输入', "result" => '0'));
        }
    }


    // 用户登录
    private function _login($user, $password)
    {
        $condition['user'] = $user;
        $user_info = $this->model->table('admin')->where($condition)->find();
        // 用户名密码正确且没有锁定
        if (($user_info['password'] == $password) && ($user_info['status'] == 0)) {
            // 更新帐号信息
            $config = $this->config;
            $data = array();
            $data['logintime'] = time();
            $data['loginnum'] = $user_info['loginnum'] + 1;
            $data['ip'] = get_client_ip();
            $data2 = array();
            $data2['uid'] = $user_info['id'];
            $data2['user'] = $user_info['user'];
            $data2['time'] = time();
            $data2['ip'] = get_client_ip();


            if ($config['IP_STATUS'] == 0) //不获取地址

            {
                $data['address'] = '';
                $data2['address'] = '无记录';
            }

            if ($config['IP_STATUS'] == 1) //在线获取地址

            {
                require (CP_PATH . 'ext/query_ip.php');
                $data['address'] = getIPLoc(get_client_ip());
                $data2['address'] = getIPLoc(get_client_ip());
            }

            if ($config['IP_STATUS'] == 2) //通过IP库获取

            {
                $ip = new IpArea();
                $query_ip = $ip->get(get_client_ip(), true);
                $data['address'] = $query_ip['country'] . "&nbsp;&nbsp;" . $query_ip['area'];
                $data2['address'] = $query_ip['country'] . "&nbsp;&nbsp;" . $query_ip['area'];
            }

            $this->model->table('admin')->data($data)->where($condition)->update(); //更新登录信息

            //获取登录记录总条数判断大于或者等于50条时删除第一条再进行插入
            $login_data_cout = $this->model->table('login_data')->count();
            if ($login_data_cout <= 50) {
                $this->model->table('login_data')->data($data2)->where($condition)->insert();
            } else {
                $login_data_asc = $this->model->table('login_data')->field('id')->order('id asc')->
                    find();
                $condition3['id'] = $login_data_asc['id'];
                $this->model->table('login_data')->where($condition3)->delete();
                $this->model->table('login_data')->data($data2)->where($condition)->insert();
            }

            $condition2['id'] = $user_info['gid'];
            $group_info = $this->model->table('admin_group')->where($condition2)->find();
            // 设置登录信息
            $_SESSION[$config['spot'] . 'admin_spot'] = $config['spot'];
            $_SESSION[$config['spot'] . 'admin_uid'] = $user_info['id'];
            $_SESSION[$config['spot'] . 'admin_gid'] = $user_info['gid'];
            $_SESSION[$config['spot'] . 'admin_user'] = $user_info['user'];
            $_SESSION[$config['spot'] . 'admin_name'] = $user_info['name'];
            $_SESSION[$config['spot'] . 'admin_power'] = $group_info['power_value'];
            return true;
        }
        return false;
    }

    // 用户退出
    public function logout()
    {
        $config = $this->config;
        unset($_SESSION[$config['spot'] . 'admin_spot']);
        unset($_SESSION[$config['spot'] . 'admin_uid']);
        unset($_SESSION[$config['spot'] . 'admin_gid']);
        unset($_SESSION[$config['spot'] . 'admin_user']);
        unset($_SESSION[$config['spot'] . 'admin_name']);
        unset($_SESSION[$config['spot'] . 'admin_power']);
        echo "<script>window.location.href='__APP__'</script>";
    }

    // 生成验证码
    public function verify()
    {
        require_once (CP_PATH . 'lib/Image.class.php');
        Image::buildImageVerify();
    }

}

?>