<?php

class plus_diytplMod extends commonMod
{
    // 页面管理
    public function index()
    {
        $list = $this->model->table('plus_diytpl')->select(); //查询页面表所有数据
        $this->assign('list', $list);
        $this->display();
    }
    // 页面添加
    public function add()
    {
        if (empty($_POST['psot_do'])) {
            $this->display();
            return;
        }
        $data = array();
        $data['title'] = in($_POST['title']);
        $data['file'] = in($_POST['file']);
        $data['content'] = html_in($_POST['content']);

        if (empty($data['title'])) {
            $this->error('名称不能为空！');
            return;
        }

        if (empty($data['file'])) {
            $this->error('文件名不能为空！');
            return;
        }

        switch (substr(strrchr($data['file'], '.'), 1)) {
            case 'php':
            case 'PHP':
            case 'asp':
            case 'ASP':
            case 'aspx':
            case 'ASPX':
            case 'jsp':
            case 'JSP':
                $this->error('非法文件操作！');
                break;
            
            default:
                break;
        }

        $condition['file'] = $data['file'];
        $info = $this->model->table('plus_diytpl')->where($condition)->find();
        if ($info['file'] == $data['file']) {
            $this->error('文件名不能重复！');
            return;
        }
        if(file_exists(__ROOTDIR__.'/'.$data['file'])){
            $this->error('文件已存在！');
        }

        // 数据库操作
        $this->model->table('plus_diytpl')->data($data)->insert();
        $content=$this->tpl->compile($_POST['content']);
        if(@$this->file_create(__ROOTDIR__.'/'.$data['file'],$content))
        {
            $this->success('页面添加成功！');
        }else{
            $this->success('文件写入失败页面，只添加至数据库！');
        }
        
    }
    // 页面修改
    public function edit()
    {
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]); //获取ID
            if (empty($id)) {
                $this->error('参数传递错误！');
                return;
            }
            $condition['id'] = $id;
            $info = $this->model->table('plus_diytpl')->where($condition)->find(); //获取当前页面信息
            if (empty($info)) {
                $this->error('该页面不存在！');
                return;

            }

            $this->assign('info', $info);
            $this->display();
            return;
        }
        
        $data = array();
        $data['title'] = in($_POST['title']);
        $data['content'] = html_in($_POST['content']);

        if (empty($data['title'])) {
			$this->error('名称不能为空！');
            return;
        }
        // 数据库操作
        $condition2['id'] = intval($_POST['id']);
        $info = $this->model->table('plus_diytpl')->where($condition2)->find(); 
        $this->model->table('plus_diytpl')->data($data)->where($condition2)->update();
        $content=$this->tpl->compile($_POST['content']);
        if(@$this->file_create(__ROOTDIR__.'/'.$info['file'],$content))
        {
            $this->success('页面修改成功！');
        }else{
            $this->success('文件写入失败页面，只添加至数据库！');
        }
        
    }

    // 页面更新
    public function updata()
    {
        $id = intval($_GET[0]); //获取ID
        if (empty($id)) {
        $this->error('参数传递错误！');
        return;
        }
        // 数据库操作
        $condition['id'] = $id;
        $info = $this->model->table('plus_diytpl')->where($condition)->find(); 
        $content=$this->tpl->compile($info['content']);
        if(@$this->file_create(__ROOTDIR__.'/'.$info['file'],$content))
        {
            $this->success('页面更新成功！');
        }else{
            $this->success('页面更新失败！');
        }
        
    }

    // 删除页面
    public function del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }
        
        $condition['id'] = $id;
        $info = $this->model->table('plus_diytpl')->where($condition)->find(); //获取当前页面信息

        @unlink(__ROOTDIR__.'/'.$info['file']);
        $condition['id'] = $id;
        $this->model->table('plus_diytpl')->where($condition)->delete();
        $this->jssuccess('页面删除成功！');


    }

    public function file_create($folder, $data=' ') {
    $folder = strtr($folder,'\\','/');
    if(substr($folder,-1)=='/') {
    $path = rtrim($folder,'/');
    if(!is_dir($path)) return mkdir($path,0777,true);
    return true;
    }
    else {
    $path = dirname($folder);
    !is_dir($path) and mkdir($path,0777,true);
    return @file_put_contents($folder, $data);
      }
    }

}

?>