<?php

class plus_modelMod extends commonMod
{

    // 扩展模型
    public function index()
    {
        $list = $this->model->table('plus_model')->where('pid=0')->order('id desc')->select();
        $this->assign('list', $list);
        $this->display();
    }

    // 添加扩展模型
    public function add()
    {
        if (empty($_POST['psot_do'])) {
            $this->display();
            return;
        }
        

        $data = array();
        $data['name'] = in($_POST['name']); //模型名称
        $data['table'] = in('extend_model_' . $_POST['table']); //表名

        //验证数据
        if (empty($data['name'])) {
            $this->jserror('模型名称不能为空');
        }
        if (empty($data['table'])) {
            $this->jserror('模型表名不能为空');
        }

        $sql = "CREATE TABLE IF NOT EXISTS {$this->model->pre}{$data['table']}(
  `my_id` int(11) NOT NULL auto_increment,
  `my_aid` int(11) NOT NULL,
  PRIMARY KEY  (`my_id`),
  KEY `aid` (`my_aid`)
)"; //ID主键
        $this->model->query($sql); //创建表操作

        $this->model->table('plus_model')->data($data)->insert(); //插入模型数据

        $this->jssuccess('模型添加成功');
    }

    // 修改扩展模型
    public function edit()
    {

        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            $info = $this->model->table('plus_model')->where('id=' . $id)->find();
            $this->assign('info', $info);
            $this->display();
            return;
        }
        

        $data = array();
        $data['name'] = in($_POST['name']); //模型名称

        //验证数据
        if (empty($data['name'])) {
            $this->jserror('模型名称不能为空');
        }

        $condition = array();
        $condition['id'] = $_POST['id'];
        $this->model->table('plus_model')->data($data)->where($condition)->update();

        $this->jssuccess('模型修改成功');
    }

    // 删除扩展模型
    public function del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }
        

        $condition['id'] = $id;
        $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型信息

        $sql = "DROP TABLE {$this->model->pre}{$info['table']}";
        $this->model->query($sql); //删除创建的表

        $condition2 = array();
        $condition2['id'] = $id;
        $this->model->table('plus_model')->where($condition2)->delete();
        $condition3 = array();
        $condition3['pid'] = $id;
        $this->model->table('plus_model')->where($condition3)->delete();
        $this->jssuccess('模型删除成功！');
    }

    // 管理模型字段
    public function manage()
    {
        $id = intval($_GET[0]);

        $condition['id'] = $id;
        $condition2['pid'] = $id;
        $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型信息
        $list = $this->model->table('plus_model')->where($condition2)->select(); //获取当前模型的字段

        $this->assign('info', $info);
        $this->assign('list', $list);
        $this->display();
    }

    // 添加模型字段
    public function manage_add()
    {
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('ID传输错误！');
                return;
            }
            $condition['id'] = $id;
            $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型信息
            $this->assign('info', $info);
            $this->display();
            return;
        }
        
        $data = array();
        $data['name'] = in($_POST['name']); //字段描述
        $data['field'] = in('my_'.$_POST['field']); //字段名
        $data['type'] = in($_POST['type']); //字段类型
        $data['default_val'] = in($_POST['default_val']); //默认值
        $data['pid'] = intval($_POST['pid']); //所属模型
        
        $condition['id'] = $data['pid'];
        $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型信息

		
		switch ($data['type'])
		{
		case 3: //大型文本
		$type='text';
		break;
		case 6: //数字
		$type='int(11)';
		break;
		case 7: //货币
		$type='DECIMAL(9,2)';
		break;
        case 8: //时间
        $type='int(11)';
        break;
		default:
		$type='varchar(250)'; //普通
		}
        
        $sql="alter table {$this->model->pre}{$info['table']} ADD `{$data['field']}` {$type} NOT NULL ";
        $this->model->query($sql); //创建字段

        $this->model->table('plus_model')->data($data)->insert(); //插入模型数据
        $this->jssuccess('字段添加成功',__URL__.'/manage-'.$info['id']);

    }
    
    // 编辑模型字段
    public function manage_edit()
    {
        if (empty($_POST['psot_do'])) {
            $id = intval($_GET[0]);
            if (empty($id)) {
                $this->error('ID传输错误！');
                return;
            }
            $condition['id'] = $id;
            $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前字段信息
            
            $this->assign('info', $info);
            $this->display();
            return;
        }
        
        $data = array();
        $data['name'] = in($_POST['name']); //字段描述
        $data['default_val'] = in($_POST['default_val']); //默认值
        
        $condition['id'] = $_POST['id']; 
        $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型信息
        $this->model->table('plus_model')->data($data)->where($condition)->update(); //修改字段信息
        $this->jssuccess('字段信息修改成功',__URL__.'/manage-'.$info['pid']);

    }
    
    // 删除模型字段
    public function manage_del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }
        

        $condition['id'] = $id;
        $info = $this->model->table('plus_model')->where($condition)->find(); //获取当前模型字段信息
        
        $condition2['id'] = $info['pid'];
        $model_info = $this->model->table('plus_model')->where($condition2)->find(); //获取当前模型字段信息

        $sql="alter table {$this->model->pre}{$model_info['table']} DROP COLUMN {$info['field']}";
        $this->model->query($sql); //删除创建的表

        $this->model->table('plus_model')->where($condition)->delete();
        $this->jssuccess('字段删除成功！');
    }

}

?>