<?php

class plus_tagsMod extends commonMod
{
    
    // TAG管理
    public function index()
    {
        $url = __URL__ . '/index-page-{page}.html'; //分页基准网址
        $page = new Page();
        $listRows = 50; //每页显示记录
        $cur_page = $page->getCurPage($url);
        $limit_start = ($cur_page - 1) * $listRows;
        $limit = $limit_start . ',' . $listRows;

        $list = $this->model->table('content_tag')->order('id desc')->limit($limit)->select(); //查询替换表所有数据
        $count = $this->model->table('content_tag')->count(); //总记录数
        $this->assign('list', $list);
        $this->assign('page', $this->page($url, $count, $listRows));
        $this->display();

    }
    
    // TAG删除
    public function del()
    {
        $id = intval($_GET[0]);
        if (empty($id)) {
            $this->jserror('ID传输错误！');
            return;
        }
        
        $condition['id'] = $id;
        $this->model->table('content_tag')->where($condition)->delete();
        $this->jssuccess('TAG删除成功！');
    }
    
    // 批量删除
    public function del_all()
    {
        $mode = intval($_POST['mode']);
        $checkbox = $_POST['id'];
        if (empty($checkbox)) {
            $this->error('未选择TAG！');
            exit;
        }
        $in = implode(',', $checkbox);
        $condition = "id in($in)";
        $this->model->table('content_tag')->where($condition)->delete();
        $this->success('批量删除成功！');
        
    }
}

?>