<?php

class settingMod extends commonMod
{
    public function __construct()
    {
        parent::__construct();
        
    }

    // 显示系统设置页面
    public function index()
    {
        $this->assign('config', $this->getconfig());
        $this->display();
    }
    // 修改系统设置
    public function edit()
    {
        $config = $_POST; //接收表单数据
        $config_array = array();
        foreach ($config as $key => $value) {
        $config_array["config['" . $key . "']"] = $value;
        }
        set_config($config_array);
        $this->success('网站配置成功！',__URL__);
    }

}


// 修改配置的函数
function set_config($array, $config_file = '../inc/config.php')
{
    if (empty($array) || !is_array($array)) {
        return false;
    }

    $config = file_get_contents($config_file); //读取配置
    foreach ($array as $name => $value) {
        $name = str_replace(array("'", '"', '['), array("\\'", '\"', '\['), $name); //转义特殊字符，再传给正则替换
        if (is_string($value) && !in_array($value, array('true', 'false', '3306'))) {
            $value = "'" . $value . "'"; //如果是字符串，加上单引号
        }
        $config = preg_replace("/(\\$" . $name . ")\s*=\s*(.*?);/i", "$1={$value};", $config); //查找替换
    }
    // 写入配置
    if (file_put_contents($config_file, $config))
        return true;
    else
        return false;
}

?>