<?php 
if(file_exists('../data/install.lock'))
{
	header("location:../");
}

function file_mode_info($file_path)
{
    /* 如果不存在，则不可读、不可写、不可改 */
    if (!file_exists($file_path))
    {
        return false;
    }
    $mark = 0;
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN')
    {
        /* 测试文件 */
        $test_file = $file_path . '/cf_test.txt';
        /* 如果是目录 */
        if (is_dir($file_path))
        {
            /* 检查目录是否可读 */
            $dir = @opendir($file_path);
            if ($dir === false)
            {
                return $mark; //如果目录打开失败，直接返回目录不可修改、不可写、不可读
            }
            if (@readdir($dir) !== false)
            {
                $mark ^= 1; //目录可读 001，目录不可读 000
            }
            @closedir($dir);
            /* 检查目录是否可写 */
            $fp = @fopen($test_file, 'wb');
            if ($fp === false)
            {
                return $mark; //如果目录中的文件创建失败，返回不可写。
            }
            if (@fwrite($fp, 'directory access testing.') !== false)
            {
                $mark ^= 2; //目录可写可读011，目录可写不可读 010
            }
            @fclose($fp);
            @unlink($test_file);
            /* 检查目录是否可修改 */
            $fp = @fopen($test_file, 'ab+');
            if ($fp === false)
            {
                return $mark;
            }
            if (@fwrite($fp, "modify test.\r\n") !== false)
            {
                $mark ^= 4;
            }
            @fclose($fp);
            /* 检查目录下是否有执行rename()函数的权限 */
            if (@rename($test_file, $test_file) !== false)
            {
                $mark ^= 8;
            }
            @unlink($test_file);
        }
        /* 如果是文件 */
        elseif (is_file($file_path))
        {
            /* 以读方式打开 */
            $fp = @fopen($file_path, 'rb');
            if ($fp)
            {
                $mark ^= 1; //可读 001
            }
            @fclose($fp);
            /* 试着修改文件 */
            $fp = @fopen($file_path, 'ab+');
            if ($fp && @fwrite($fp, '') !== false)
            {
                $mark ^= 6; //可修改可写可读 111，不可修改可写可读011...
            }
            @fclose($fp);
            /* 检查目录下是否有执行rename()函数的权限 */
            if (@rename($test_file, $test_file) !== false)
            {
                $mark ^= 8;
            }
        }
    }
    else
    {
        if (@is_readable($file_path))
        {
            $mark ^= 1;
        }
        if (@is_writable($file_path))
        {
            $mark ^= 14;
        }
    }
    return $mark;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>DLKIT网站安装向导</title>
<link href="css/css.css" rel="stylesheet" type="text/css" />
</head>

<body>
<div id="main">
  <div class="top">
    <div class="logo"></div>
    <div id="tool">联系我们&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.dlcms.net"> 官方网站</a></div>
  </div>
  <div class="central">
    <div id="left">
      <ul>
        <li>
          <h1>1</h1>
          <div class="left_title">
            <h2>准备安装</h2>
            <p>欢迎您使用DLCMS内容管理系统！</p>
          </div>
        </li>
        <li>
          <h1>2</h1>
          <div class="left_title">
            <h2>阅读协议</h2>
            <p>请认真阅读软件使用协议，以免您的利益受到损害！</p>
          </div>
        </li>
        <li class="install">
          <h1>3</h1>
          <div class="left_title">
            <h2>环境检测</h2>
            <p>检测软件安装环境是否适合DLKIT！</p>
          </div>
        </li>
        <li>
          <h1>4</h1>
          <div class="left_title">
            <h2>基本设置</h2>
            <p>请设置网站的基本信息进行网站安装！</p>
          </div>
        </li>
        <li>
          <h1>5</h1>
          <div class="left_title">
            <h2>开始安装</h2>
            <p>开始愉快的网站安装之旅吧！</p>
          </div>
        </li>
      </ul>
    </div>
    <div class="right">
      <div class="right_title">安装环境检测</div>
      <div style="text-align:left; line-height:25px; margin-top:20px; font-size:12px;table-layout:fixed;">
        <p><a href="#">系统所需函数检测</a></p>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td width="120">图像函数库支持：</td>
    <td width="50"><?php if (function_exists("imageline")==1){echo '<font color=green><b>√</b></font>';} else {echo '<font color=red><b>×</b></font>';} ?></td>
    <td>此函数影响图片自动缩小和图片水印功能</td>
  </tr>
  <tr>
    <td>CURL函数支持：</td>
    <td><?php if (function_exists("curl_init")==1){echo '<font color=green><b>√</b></font>';} else {echo '<font color=red><b>×</b></font>';} ?></td>
    <td>此函数可能会影响到远程抓图等功能</td>
  </tr>
  <tr>
    <td>socket函数支持：</td>
    <td><?php if (function_exists("fsockopen")==1){echo '<font color=green><b>√</b></font>';} else {echo '<font color=red><b>×</b></font>';} ?></td>
    <td>此函数可能会影响到远程抓图等功能</td>
  </tr>
  <tr>
    <td colspan="3">&nbsp;</td>
    </tr>
</table>

        <p><a href="#">系统所需目录权限检测</a></p>
<table width="100%" border="0" cellspacing="0" cellpadding="0" style="table-layout:fixed;">
  <?php
  $dir=array('admin','data','inc','module','themes','upload','system','public');
  foreach ($dir as $value) {
    if(file_mode_info('../'.$value.'/')>11){
      
   ?>
  <tr>
    <td width="100"><?php echo $value; ?></td>
    <td><font color=green><b>√</b></font></td>
  </tr>
  <?php }else{ ?>
  <tr>
    <td width="50"><?php echo $value; ?></td>
    <td><font color=red><b>x</b></font></td>
  </tr>
  <?php } } ?>
  
      <td colspan="2">注意：如果目录没有相应的写入权限可能会造成程序无法自动升级</td>
    </tr>
</table>


        <div class="agree"  align="center">
          <form action="database.php">
            <input hidefocus="true" type="submit" class="button" value="确认进入下一步！" />
          </form>
        </div>
      </div>
    </div>
    <div style="clear:both"></div>
  </div>
</div>
<div class="foot">Copyright © 2012 独立网络 (dlcms.net)</div>
</body>
</html>