<?php
//公共类
class commonMod
{

    public $model; //数据库模型对象
    public $tpl; //模板对象
    public $config; //全局配置
    static $global; //静态变量，用来实现单例模式

    public function __construct()
    {   
        session_start();
        //如果还没有安装，则跳转到安装页面
        if(!file_exists('data/install.lock'))
        {
            $this->redirect(__ROOT__.'/install/');
        }


        
        //实例化数据库模型和模板
        if(!isset(self::$global['config']))
        {
            global $config;
            $this->config=self::$global['config']=$config;//配置
            $this->model=self::$global['model']=new cpModel($this->config);//实例化数据库模型类              
            $this->tpl=self::$global['tpl']=new cpTemplate($this->config);//实例化模板类      
        }
        else
        {
            $this->config=self::$global['config'];//配置
            $this->model=self::$global['model'];//数据库模型对象
            $this->tpl=self::$global['tpl'];//模板类对象
        }

        Plugin::init();

    }

    public function _empty()
    {
        $action_id = end(explode('_', $_GET['_action']));
        if (is_numeric($action_id)) {
            $_GET[0] = $action_id;
            $_GET['_action'] = 'index';
            module($_GET['_module'])->index();
        }
    }
     


    //模板变量解析
    protected function assign($name, $value)
    {
        return $this->tpl->assign($name, $value);
    }
    //模板输出
    protected function display($tpl = '')
    {
        $this->assign('sys', $this->config);
        $this->assign('lang',Lang::getPack(__LANG__));
        return $this->tpl->display($tpl);
    }

    //设置表名
    protected function table($table,$ignore_prefix=false)
    {
        return $this->model->table($table,$ignore_prefix);
    }


    //直接跳转
    protected function redirect($url)
    {
        header('location:' . $url, false, 301);
        exit;
    }

    //操作成功后跳转
    protected function success($msg, $url = null)
    {
        if ($url == null) {
            $url = __URL__;
        }
        header("Content-type: text/html; charset=utf-8");
        $msg = "alert('$msg');";
        echo "<script>$msg window.location.href='$url';</script>";
        exit;
    }

    //错误操作跳转
    protected function error($msg)
    {
        header("Content-type: text/html; charset=utf-8");
        $msg = "alert('$msg');";
        echo "<script>$msg history.go(-1);</script>";
        exit;
    }


    //错误提示
    protected function errormsg($msg)
    {
        header("HTTP/1.1 404 Not Found");  
        header("Status: 404 Not Found");
        $config=$this->config;
        header("Content-type: text/html; charset=utf-8");
        echo "<!DOCTYPE HTML>";
        echo "<html>";
        echo "<head>";
        echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
        echo "<title>$msg</title>";
        echo "</head>";
        echo "<body>";
        echo "<h1>$msg</h1>";
        echo "<h3>可供尝试的网址：</h3>";
        echo "<ul>";
        echo "<li>转到 <a href=\"" . __APP__ . "\">" . $config['sitename'] . "</a></li>";
        echo "<li>转到 <a href=\"#\" onClick=\"history.go(-1);\">上一个页面</a></li>";
        echo "</ul>";
        echo "DLCMS内容管理系统";
        echo "</body>";
        echo "</html>";
        exit;
    }

    //页面不存在
    protected function error404()
    {
        header('HTTP/1.1 404 Not Found');
        header('Status: 404 Not Found');
        $config=$this->config;
        header("Content-type: text/html; charset=utf-8");
        echo "<!DOCTYPE HTML>";
        echo "<html>";
        echo "<head>";
        echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
        echo "<title>您要查找的页面不存在！</title>";
        echo "</head>";
        echo "<body>";
        echo "<h1>您要查找的页面不存在！</h1>";
        echo "<h3>可供尝试的网址：</h3>";
        echo "<ul>";
        echo "<li>转到 <a href=\"" . __APP__ . "\">" . $config['sitename'] . "</a></li>";
        echo "<li>转到 <a href=\"#\" onClick=\"history.go(-1);\">上一个页面</a></li>";
        echo "</ul>";
        echo "DLCMS内容管理系统";
        echo "</body>";
        echo "</html>";
        exit;
    }

    //分页 $url:基准网址，$totalRows: $listRows列表每页显示行数$rollPage 分页栏每页显示的页数
    protected function page($url, $totalRows, $listRows = 10, $rollPage = 5, $mode =
        4)
    {
        require_once (CP_PATH . 'lib/Page.class.php');
        $page = new page();
        return $page->show($url, $totalRows, $listRows, $rollPage, $mode);
    }

    //lang
    public function getlang($lang)
    {
        $getlang= Lang::getPack(__LANG__);
        if(empty($getlang[$lang])){
            return $lang;
            }else{
            return $getlang[$lang]; 
            }        
    }

    //lang
    public function lang()
    {
        $lang=$this->config['LANG_OPEN'];
        if($lang==1){
            return __LANG__.'/';
        }       
    }

    //lang
    public function getlangid()
    {
        $condition['lang']=__LANG__;
        $info = $this->model->table('lang')->where($condition)->find();
        return $info['id']; 
    }

    public function nav_cid($id) //位置导航
    {
        $data = $this->model->field('id,pid,name,pinyin')->table('channel')->select();
        $cat = new Category(array(
            'id',
            'pid',
            'name',
			'pinyin',
            'cname')); //初始化位置导航
        return array_reverse($cat->getPath($data, $id)); 
    }

    // 获取该栏目下子栏目的ID
    public function getcat($cid)
    {
        $id = $cid;
        $data = $this->model->field('id,pid,name')->table('channel')->select();
        $cat = new Category(array(
            'id',
            'pid',
            'name',
            'cname')); //初始化无限分类

        $cat_for = $cat->getTree($data, $id); //获取分类数据树结构
        foreach ($cat_for as $v) {
            $cat_id .= $v['id'] . ",";
        }

        if (!empty($cat_id)) {
            return $cat_id . $id;
        } else {
            return $id;
        }


    }

    //插件参数读取和设置
    public function plus_setting($file='',$name = '', $value = null)
    {
        static $setting = array();
        $setting = empty($setting) ? require_once ($file. '/setting.php') :
            $setting;

        if (empty($name))
        {
            $condition['PLUS_NAME']=$setting['PLUS_NAME'];
            return $this->model->table('extend')->where($condition)->find(); //返回所有配置
        } else
        {
            if (is_null($value))
            {
                $condition['PLUS_NAME']=$setting['PLUS_NAME'];
                $info=$this->model->table('extend')->where($condition)->find();
                return isset($info[$name]) ? $info[$name] : false; //返回指定配置值
            } else
            {
                $condition['PLUS_NAME']=$setting['PLUS_NAME'];
                $data[$name] = $value;
                $this->model->table('extend')->data($data)->where($condition)->update();
                return true; //写入配置
            }
        }
    }



}

?>