<?php
if( !function_exists('tpl_parse_ext')) {
	template_ext($template);
}
//自定义模板标签解析函数
function template_ext($template)
{

    //替换语言获取
    $template = preg_replace("/{lang='(\S+)'}/iU", "<?php echo module('common')->getlang('$1') ?>", $template);

    //替换模板包含
    $template = preg_replace("/<!--#include file=\"(.*)\.html\"-->/iU",
        "{include file=\"".module('common')->lang()."$1\"}",
        $template);

    //替换模板包含2
    $template = preg_replace("/{include file=\"(.*)\.html\"}/iU",
        "{include file=\"$1\"}",
        $template);

    //替换循环
    $template = preg_replace("/<!--(\S+):{(.*)}-->/", "<?php $$1=module('label')->getlist(\"$2\"); $$1_i=0; if(!empty($$1)) foreach($$1 as $$1){  $$1_i++; ?> ",
        $template);


    //替换统计调用
    $template = preg_replace("/{type=\(count\) table=\(([a-zA-Z_]+)\) where=\((.*)\)}/iU",
        "<?php \$count=module('label')->getcount(\"$1\",$2); if(!empty(\$count)){echo \$count;} ?>",
        $template);
  

    //替换文件路径
    $template = preg_replace("/<(.*?)(src=|href=|value=|background=)\"(images\/|css\/|js\/|style\/)(.*?)\"(.*?)>/i",
        "<$1$2\"__ROOT__/<?php if(\$sys['LANG_OPEN']==1){ echo \$sys['TPL_TEMPLATE_PATH'].'".__LANG__."/'; }else{ echo \$sys['TPL_TEMPLATE_PATH']; } ?>$3$4\"$5>", $template);

    //替换数据碎片
    $template = preg_replace("/{my:(\S+)}/iU", "<?php echo module('fragment')->out('$1'); ?>",
        $template);

    //替换标签区块
    $template = preg_replace("/{diy:(\S+)}/iU", "<?php echo module('diylabel')->out('$1'); ?>", $template);

    //替换config标签
    $template = preg_replace("/{sys:([\s\S]*?)}/iU", "<?php echo \$sys['$1']; ?>", $template);

    //处理循环后}符号
    $template = preg_replace("/<!--\/([a-zA-Z_]+)-->/i", "<?php } ?>", $template);
    

    //替换内部循环分页
    $template = preg_replace("/<!--(.*):(.*)-->/iU", "<?php \$$1_i=0; if(!empty(\$$2)) foreach(\$$2 as $$1) { $$1_i++; ?>",
        $template);


    
    /* 替换菜单超链接 */
    $template = preg_replace("/\[([a-zA-Z_]+)\:curl\]/i",
        "<?php echo module('label')->getcurl($$1['id']); ?>", $template);

    /* 替换内容超链接 */
    $template = preg_replace("/\[([a-zA-Z_]+)\:aurl\]/i",
        "<?php echo module('label')->getaurl($$1['id']); ?>", $template);
        
    
    

    //处理{$list['titlex']} 样式文字
    $template = preg_replace("/\[([a-zA-Z_]+)\:titlex\]/i", "<?php \$titlex=\$$1['title']; if(!empty(\$$1['style_color'])){ \$titlex='<span style=\"color:'.\$$1['style_color'].' !important\">'.\$titlex.'</span>'; } if(\$$1['style_bold']==1){ \$titlex='<strong>'.\$titlex.'</strong>'; } if(\$$1['style_italic']==1){ \$titlex='<em>'.\$titlex.'</em>'; } echo \$titlex; ?>",
        $template);

    //处理{$list['titlex']} 样式文字+字数
    $template = preg_replace("/\[([a-zA-Z_]+)\:titlex \\\$len\=([0-9]+)\]/i",
        "<?php \$titlex=substrs(\$$1['title'],$2); if(!empty(\$$1['style_color'])){ \$titlex='<span style=\"color:'.\$$1['style_color'].' !important\">'.\$titlex.'</span>'; } if(\$$1['style_bold']==1){ \$titlex='<strong>'.\$titlex.'</strong>'; } if(\$$1['style_italic']==1){ \$titlex='<em>'.\$titlex.'</em>'; } echo \$titlex; unset(\$titlex) ?>",
        $template);

    //处理{$list['titlex']} 样式文字+字数
    $template = preg_replace("/\[([a-zA-Z_]+)\:titlex \\\$len\=([0-9]+) \\\$text\=\'(.*)\'\]/i",
        "<?php \$titlex=substrs(\$$1['title'],$2,'$3'); if(!empty(\$$1['style_color'])){ \$titlex='<span style=\"color:'.\$$1['style_color'].' !important\">'.\$titlex.'</span>'; } if(\$$1['style_bold']==1){ \$titlex='<strong>'.\$titlex.'</strong>'; } if(\$$1['style_italic']==1){ \$titlex='<em>'.\$titlex.'</em>'; } echo \$titlex; unset(\$titlex) ?>",
        $template);
        
    /* 自定义内容超链接带变量 */
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$aurl\]/i",
        "<?php echo module('label')->getaurl($$1['$2']); ?>", $template);
    /* 自定义内容超链接带变量 */
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$curl\]/i",
        "<?php echo module('label')->getcurl($$1['$2']); ?>", $template);
    /* 自定义内容超链接不带变量 */
    $template = preg_replace("/\[\\\$aurl\=([0-9a-zA-Z\_\$]+)\]/i",
        "<?php echo module('label')->getaurl($1); ?>", $template);
    /* 自定义内容超链接不带变量 */
    $template = preg_replace("/\[\\\$curl\=([0-9a-zA-Z\_\$]+)\]/i",
        "<?php echo module('label')->getcurl($1); ?>", $template);


    //字数显示标签
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$len\=([0-9]+)\]/i",
        "<?php echo substrs(\$$1['$2'],$3); ?>", $template);

    //字数显示标签+自定义后缀
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$len\=([0-9]+) \\\$text\=\'(.*)\'\]/i",
        "<?php echo substrs(\$$1['$2'],$3,'$4'); ?>", $template);


    /* 替换内容时间*/
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$format\=(.*)\]/iU",
        "<?php echo date('$3',\$$1['$2']) ?>", $template);

    /*关键词转tag*/
    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+) \\\$tag\=(\S+)\]/i",
        "<?php echo  module('label')->getkeywords(\$$1['$2'],'$3'); ?>", $template);


    //处理 $list_i 循环条件标签
    $template = preg_replace("/\[([a-zA-Z_]+)\:\i\]/i", "<?php echo \$$1_i ?>", $template);
    
    //处理 $list_i 循环条件标签
    $template = preg_replace("/\{([a-zA-Z_]+)\:\i\}/i", "\$$1_i", $template);
    
    //处理 #[list:id]# 循环条件标签
    $template = preg_replace("/\#\[([a-zA-Z_]+)\:([a-zA-Z_]+)\]\#/i", '".\$$1[\'$2\']."', $template);
    
    //处理 #$list['id']# 循环条件标签
    $template = preg_replace("/\#\\$(\S+)\#/i", '".$$1."', $template);
    


    
    //处理{$list['title']} 普通标签

    $template = preg_replace("/\[([a-zA-Z_]+)\:([a-zA-Z_]+)\]/iU", "<?php echo \$$1['$2']; ?>",$template);
    //处理{$list['title']} 普通标签
    $template = preg_replace("/\{([a-zA-Z_]+)\:([a-zA-Z_]+)\]}/i", "\$$1['$2']",$template);
    
        
    //替换判断
    $template = preg_replace("/{if:([\s\S]*?)}/i", "<?php if($1){ ?>", $template); //IF
    $template = preg_replace("/{else}/i", "<?php }else{ ?>", $template); //ELSE
    $template = preg_replace("/{end if}/i", "<?php } ?>", $template); //END IF
    




    //for 标签
    /*
    <!--{for $i=0;$i<10;$i++}-->    =>  <?php for($i=0;$i<10;$i++) { ?>
    <!--{/for}-->                   =>  <?php } ?>
    */
    $template = preg_replace("/<!--\{for\s+(.+?)\}-->/", "<?php for(\\1) { ?>", $template);


    return $template;

}
?>