<?php
/**
 * 
 * 将时间戳返回需要的时间格式
 * @param int $value
 * @param string $format 时间格式 如 Y-m-d
 */
function toDate($value, $format) {
	return date ( $format, $value );
}
/**
 * 
 * 显示图片的缩略图
 * @param string $value 
 * @param string $alt 图片alt属性
 */
function viewPic($value, $alt) {
	if (empty ( $value )) {
		return '<img src="__PUBLIC__/img/noPic.gif" alt="' . $alt . '" style="max-width:60px; max-height:60px;_height:expression(this.scrollHeight > 60 ? \'60px\' : \'auto\');_width:expression(this.scrollWidth > 60 ? \'60px\' : \'auto\');border:1px solid #ccc; padding:2px; margin-left:5px; ">';
	} else {
		return '<img onclick="openViewPic(this.src);" alt="' . $alt . '" src="' . $value . '" style="max-width:60px; max-height:60px;_height:expression(this.scrollHeight > 60 ? \'60px\' : \'auto\');_width:expression(this.scrollWidth > 60 ? \'60px\' : \'auto\');border:1px solid #ccc; padding:2px; margin-left:5px; ">';
	}
}
/**
 * 
 * 截取字符串函数,
 * @param string $value
 * @param int $num 字符串长度
 */
function strSub($value, $num) {
	if (strlen ( $value ) > $num) {
		return mb_substr ( $value, 0, $num, 'utf-8' ) . '...';
	} else {
		return $value;
	}
}
//所属模型选择
function boxSwtic($boxName) {
	switch ($boxName) {
		case 'manage' :
			return '<font color="#FF00F6">' . L ( 'MANAGE_BOX' ) . '</font>';
			break;
		case 'info' :
			return '<font color="#7AC6FF">' . L ( 'INFO_BOX' ) . '</font>';
			break;
		case 'back' :
			return '<font color="#80FF7A">' . L ( 'BACK_BOX' ) . '</font>';
			break;
		case 'core' :
			return '<font color="#7AC6FF">' . L ( 'CORE_BOX' ) . '</font>';
			break;
		default :
			break;
	}
}
//函数获取id
function get($id) {
	return $_REQUEST [$id];
}
//获得分站名称
function getCityName($cityId) {
	$model = M ( 'City' );
	$data = $model->find ( $cityId );
	return $data ['cityName'];
}
//返回搜索选项的搜索选择字段 @param unknown_type $fields 字段 @param unknown_type $model 模型
function dataSearch($modelName, $fields) {
	$model = M ( 'Modul' );
	$getModel = $model->where ( 'modelName = "' . strtolower ( $modelName ) . '"' )->find ();
	$fieldM = M ( 'Fields' );
	$getFields = $fieldM->where ( 'modulId=' . $getModel ['id'] . ' and fieldsName = "' . $fields . '"' )->find ();
	
	$returnData = '';
	if ($getFields ['source']) {
		//说明来源于模型
		$source = M ( ucfirst ( $getFields ['source'] ) );
		$getSource = $source->where ( $getFields ['getIf'] )->select ();
		foreach ( $getSource as $key ) {
			$returnData .= '<option value="' . $key ['id'] . '">' . $key [$getFields ['viewField']] . '</option>';
		}
	} else {
		//说明来源列表
		if ($getFields ['selectItem']) {
			$data = explode ( '&&&', $getFields ['selectItem'] );
			array_pop ( $data );
			$getSource = array ();
			$i = 0;
			foreach ( $data as $key ) {
				$getValue = explode ( '|', $key );
				$returnData .= '<option value="' . $getValue [1] . '">' . $getValue [0] . '</option>';
			}
		}
	}
	return $returnData;
}
//是否被搜索
function isListsearch($oprate, $id) {
	$model = M ( 'Fields' );
	$getData = $model->where ( 'id=' . $id )->find ();
	$returnData = '<select id="sear_' . $id . '" class="s_select" style="width:auto;min-width:auto"><option value="">关闭</option>';
	switch ($getData ['type']) {
		case 'text' :
		case 'number' :
		case 'intro' :
		case 'content' :
		case 'ajaxCity' :
		case 'ubb' :
			if ($oprate == 'input') {
				$returnData .= '<option value="input" selected="selected">启用</option>';
			} else {
				$returnData .= '<option value="input" >启用</option>';
			}
			$returnData .= '</select><span id="sspan' . $id . '"></span>';
			break;
		case 'select' :
			if ($oprate == 'select') {
				$returnData .= '<option value="select" selected="selected">启用</option>';
			} else {
				$returnData .= '<option value="select" >启用</option>';
			}
			$returnData .= '</select><span id="sspan' . $id . '"></span>';
			break;
		default :
			$returnData = '不支持';
			break;
	}
	return $returnData;
}
//为空返回
function space($value) {
	if ($value == '') {
		return '　';
	} else {
		return $value;
	}
}
//字段类型选择
function typeSwitch($fields) {
	switch ($fields) {
		case 'text' :
			return L ( 'INPUT_TEXT' );
			break;
		case 'number' :
			return L ( 'INPUT_NUMBER' );
			break;
		case 'nowTime' :
			return L ( 'INPUT_NOW_TIME' );
			break;
		case 'intro' :
			return L ( 'INPUT_INTRO' );
			break;
		case 'content' :
			return L ( 'INPUT_CONTENT' );
			break;
		case 'ubb' :
			return L ( 'INPUT_UBB' );
			break;
		case 'file' :
			return L ( 'INPUT_FILE' );
			break;
		case 'upfile' :
			return L ( 'INPUT_UPFILE' );
			break;
		case 'select' :
			return L ( 'INPUT_SELECT' );
			break;
		case 'mulselect' :
			return L ( 'INPUT_MULSELECT' );
			break;
		case 'ajaxCity' :
			return L ( 'INPUT_AJAXCITY' );
			break;
		case 'radio' :
			return L ( 'INPUT_RADIO' );
			break;
		case 'check' :
			return L ( 'INPUT_CHECK' );
			break;
		default :
			break;
	}
}
//视图指向
function point($oprate) {
	return '<div style="text-align:center">' . $oprate . ' → id</div>';
}

//是否显示在列表标题中 @param unknown_type $oprate=参数 @param unknown_type $id=id
function viewLists($oprate, $id) {
	if ($oprate == 0) {
		return '<span id="VL_' . $id . '_s"><a id="VL_' . $id . '" href="javascript:VL(' . $oprate . ',' . $id . ')" style="color:#FF3701">不显</a></span><span id="vspan' . $id . '"></span>';
	} else {
		return '<span id="VL_' . $id . '_s"><a id="VL_' . $id . '" href="javascript:VL(' . $oprate . ',' . $id . ')" style="color:green">显示</a></span><span id="vspan' . $id . '"></span>';
	}
}
//快速修改函数
function fun($oprate, $id) {
	$temp = explode ( '__', $id );
	if (is_array ( $temp )&&$temp[1] == 'fun') {
		return '<input id="f_' . $id . '" class="f_input" style="width:80px" value="' . $oprate . '" title="鼠标移开自动保存"/><span id="span' . $id . '"></span><a href="javascript:getFun(\'' . U ( 'control/getadminfun' ) . '\',\'获取函数\')">函数</a>';
	} else {
		return '<input id="f_' . $id . '" class="f_input" style="width:80px" value="' . $oprate . '" title="鼠标移开自动保存"/><span id="span' . $id . '">';
	}
}

//选择数据源数据 @param unknown_type $model = 模型 @param unknown_type $viewField = 显示字段 @param unknown_type $where = 查询条件
function _selectSourse($model, $viewField, $where, $selected = '') {
	$model = M ( ucfirst ( strtolower ( $model ) ) );
	if (empty ( $where )) {
		$where = '1=1';
	}
	$data = $model->where ( $where )->select ();
	$return = '';
	$array = array ();
	if (! empty ( $selected )) {
		$array = explode ( ',', $selected );
	}
	foreach ( $data as $key ) {
		//if (! empty ( $array ) && $array != '') {
		if (in_array ( $key ['id'], $array )) {
			$return .= '<option value="' . $key ['id'] . '" selected="selected">' . $key [$viewField] . '</option>';
		} else {
			$return .= '<option value="' . $key ['id'] . '">' . $key [$viewField] . '</option>';
		}
	
		//} else {
	//	$return .= '<option value="' . $key ['id'] . '">' . $key [$viewField] . '</option>';
	//}
	}
	return $return;
}
//列表中的数据来源查询
function dataFrom($value, $from) {
	$getOprate = explode ( '_', $from );
	$returnValue = '';
	$model = M ( ucfirst ( $getOprate [0] ) );
	if ($getOprate [2] == 'table') {
		//数据来源是表
		$getData = $model->where ( 'id = ' . $value )->find ();
		$returnValue = $getData [$getOprate [1]];
	} else {
		//否则 来自字段的选择
		$getData = $model->where ( 'id = ' . $getOprate [1] )->find ();
		$getSelect = explode ( '&&&', $getData ['selectItem'] );
		foreach ( $getSelect as $key ) {
			$getValue = explode ( '|', $key );
			if ($value == $getValue [1]) {
				return $getValue [0];
			}
		}
		$returnValue = '错误';
	}
	return $returnValue;
}

//下载列表选择项目
function _getMulSelect($value) {
	if (empty ( $value )) {
		return '';
	}
	$getData = explode ( '$$$', $value );
	$returnData = '';
	foreach ( $getData as $key ) {
		$returnData .= '<option value="' . $key . '">' . $key . '</option>';
	}
	return $returnData;
}
?>