<?php
/**
 * 
 * 时间戳转换时间
 * @param unknown_type $value 时间戳
 * @param unknown_type $formart 时间格式 如:Y-m-d 则显示 2012-12-12
 */
function _getTime($value, $formart) {
	return date ( $formart, $value );
}
/**
 * 
 * 字符串截取
 * @param unknown_type $value 字符串
 * @param unknown_type $length 要截取字符长的长度
 */
function _substr($value, $length) {
	return mb_substr ( $value, 0, $length, 'utf-8' );
}
//下载列表选择项目
function _downSelect($value) {
	if (empty ( $value )) {
		return '';
	}
	$getData = explode ( '$$$', $value );
	$returnData = '';
	foreach ( $getData as $key ) {
		$returnData .= '<option value="' . $key . '">' . $key . '</option>';
	}
	return $returnData;
}
/**
 * 
 * 获取下拉多选的值
 * @param string $value  值
 * @param string $models 如果是$isFields=FALSE 则指定对应的模型,否则指定字段所在的模型
 * @param string $fields 需要显示的字段信息 ,如果$bole=TRUE 那么直接使用本字段
 * @param bole $bole FALSE:指定其他模型 ,TRUE:无指定模型 调用fields的信息组
 */
function _getMulSelect($value, $models, $fields, $bole = false) {
	$return = array ();
	$i = 0;
	if ($bole == FALSE) {
		$model = M ( ucfirst ( strtolower ( $models ) ) );
		$returnData = $model->where ( 'id in (' . $value . ')' )->select ();
		foreach ( $returnData as $key ) {
			$return [$i ++] = $key [$fields];
		}
	} else {
		$model = M ( 'Modul' );
		$getModelId = $model->where ( 'modelName = "' . strtolower ( $models ) . '"' )->find ();
		$fields = M ( 'Fields' );
		$getFields = $fields->where ( 'modulId = ' . $getModelId ['id'] )->find ();
		$returnData = explode ( '&&&', $getFields ['selectItem'] );
		$getValue = implode ( ',', $value );
		foreach ( $returnData as $key ) {
			$getX = explode ( '|', $key );
			if (in_array ( $getX [1], $getValue )) {
				$return [$i ++] = $getX [0];
			}
		}
	}
	return implode ( ',', $return );
}
/**
 * 
 * 获取其他模型的内容
 * get model field value
 * @param int $id:对应的ID
 * @param string $modelName 要寻找的模型名称
 * @param string $field 要显示的模型字段
 */
function _getMFV($value, $models, $fields) {
	$modelName = ucfirst ( strtolower ( $models ) );
	$model = M ( $modelName );
	$getData = $model->where ( 'id = ' . $value )->find ();
	return $getData [$fields];
}
//获取get值
function get($id) {
	return $_REQUEST [$id];
}
/**
 * 
 * 显示图片
 * @param unknown_type $value
 * @param unknown_type $width 图片宽度
 * @param unknown_type $height 图片高度
 */
function getPic($value, $width, $height) {
	return '<img src="' . $value . '" style="width:' . $width . 'px;height:' . $width . 'px" />';
}
/**
 * 
 * 获取会员的头像
 * @param id $id:会员ID
 * @param bole $bole true: 返回头像图片 false 返回头像地址
 * @return string
 */
function getHead($value, $bole = true) {
	//根据id调用会员名
	//$model = M ( 'User' );
	//$getUserName = $model->where ( 'id=' . $value )->getField ( 'userName' );
	return '/uploads/avatar_small/' . base64_encode ( serialize ( $value ) ) . '_small.jpg';
	if ($bole) {
		if (file_exists ( 'uploads/avatar_small/' . base64_encode ( serialize ( $value ) ) . '_small.jpg' ) == 1) {
			return '<img style="width:53px; height:53px;" src="/uploads/avatar_small/' . base64_encode ( serialize ( $value ) ) . '_small.jpg" />';
		} else {
			return '<img style="width:53px; height:53px;" src="/Public/Images/noavatar.gif" />';
		}
	} else {
		if (file_exists ( 'uploads/avatar_small/' . base64_encode ( serialize ( $value ) ) . '_small.jpg' ) == 1) {
			return '/uploads/avatar_small/' . base64_encode ( serialize ( $value ) ) . '_small.jpg';
		} else {
			return '/Public/Images/noavatar.gif';
		}
	}
}
/**
 * 
 * 获取对应模型和字段的值
 * @param int $value = 要获取的值编号
 * @param string $model = 对应的模型
 * @param string $field = 对应的字段
 */
function _getFieldInfo($value, $models, $fields) {
	$modul = M ( 'Modul' );
	$getModel = $modul->where ( 'modelName = "' . strtolower ( $models ) . '"' )->find ();
	
	$fields = M ( 'Fields' );
	$getData = $fields->where ( 'fieldsName = "' . $fields . '" and modulId = ' . $getModel ['id'] )->order ( 'id desc' )->find ();
	
	$getX = explode ( '&&&', $getData ['selectItem'] );
	foreach ( $getX as $key ) {
		$getY = explode ( '|', $key );
		if ($getY [1] == $value) {
			return $getY [0];
		}
	}
	return false;
}
/**
 * 
 * 获取另一模型匹配数量
 * @param int $id :当前id
 * @param string $models :要获取的模型
 * @param string $fields :匹配字段
 * @param string $where :查询条件 没有输入 null
 */
function _getOtherMFVNum($value, $models, $fields, $where) {
	$m = M ( ucfirst ( strtolower ( $models ) ) );
	if ($where == NULL) {
		$getNum = $m->where ( $fields . ' = ' . $value )->count ();
	} else {
		$getNum = $m->where ( $fields . ' = ' . $value . ' and ' . $where )->count ();
	}
	return $getNum;
}
//根据ID调用城市
function getCity($id) {
	$model = M ( 'City' );
	$getCity = $model->where ( 'id=' . $id )->find ();
	return $getCity ['cityName'];
}
//选择城市
function selectCity($id) {
	$model = M ( 'City' );
	$getCity = $model->select ();
	$return = '';
	foreach ( $getCity as $key ) {
		if (( int ) $id == $key ['id']) {
			$return .= '<option value="' . $key ['id'] . '" selected="selected">' . $key ['cityName'] . '</option>';
		} else {
			$return .= '<option value="' . $key ['id'] . '">' . $key ['cityName'] . '</option>';
		}
	}
	return $return;
}
function Form($model, $field, $func, $width, $height, $editInfo) {
	$getFunc = explode ( ';', $func );
	$jsFun = '';
	$getJ = '';
	$notNull = false;
	foreach ( $getFunc as $key ) {
		if ($key != '') {
			$jsFun .= 'if(true == ' . $key . '){';
			$getJ .= '}';
			if ($key == 'chkNull(id)') {
				$notNull = true;
			}
		}
	}
	$jsFun .= $getJ;
	$modul = M ( 'Modul' );
	$getId = $modul->where ( 'modelName = "' . $model . '"' )->find ();
	$fields = M ( 'Fields' );
	$data = $fields->where ( 'modulId = ' . $getId ['id'] . ' and fieldsName = "' . $field . '"' )->find ();
	$return = '';
	$noBitian = true;
	$isChkCode = false;
	switch ($data ['type']) {
		case 'text' :
			if (strpos ( $jsFun, 'reChk' )) {
				$field = $field . 'chk';
			} else {
				$field;
			}
			if (strpos ( $jsFun, 'isPassword' )) {
				$return = '<input value="' . $editInfo [$field] . '" style="width:' . $width . 'px;height:' . $height . 'px" id="' . $field . '" name="' . $field . '" onpropertychange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" oninput="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" type="password">';
			} else {
				$return = '<input value="' . $editInfo [$field] . '" style="width:' . $width . 'px;height:' . $height . 'px" id="' . $field . '" name="' . $field . '" onpropertychange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" oninput="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" type="text">';
			}
			break;
		case 'number' :
			$return = '<input value="' . $editInfo [$field] . '" style="width:' . $width . 'px;height:' . $height . 'px" onkeyup="this.value=this.value.replace(/\D/g,\'\')" id="' . $field . '" name="' . $field . '" onpropertychange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" oninput="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" type="text">';
			break;
		case 'nowTime' :
			$return = '<input style="width:' . $width . 'px;height:' . $height . 'px;" type="text" value="' . mktime () . '" id="' . $field . '" name="' . $field . '"/>';
			$noBitian = false;
			break;
		case 'intro' :
			$return = '<textarea style="width:' . $width . 'px;height:' . $height . 'px"  onpropertychange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" oninput="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" id="' . $field . '" name="' . $field . '">' . $editInfo [$field] . '</textarea>';
			break;
		case 'content' :
			$return = '<script type="text/javascript" src="__PUBLIC__/Js/KindEditor/kindeditor.js"></script>
			<script type="text/javascript"> KE.show({ id : "' . $field . 'o"  ,urlType : "absolute"});</script>
			<textarea id="' . $field . 'o" style="htmlEdit" name="' . $field . 'o" >' . $editInfo [$field] . '</textarea>
				<script language="javascript">
											KE.show({
												id : "' . $field . 'o",
												width : "' . $width . 'px",
												height : "' . $height . 'px",
												afterChange : function(id) {
													$("#' . $field . '").val(KE.html("' . $field . 'o"));' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '
												}
											});
											
										</script>
                                        <textarea onpropertychange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" oninput="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" name="' . $field . '" id="' . $field . '" style="display:none">' . $editInfo [$field] . '</textarea>';
			break;
		case 'ajaxCity' :
			$return = '<input value="' . $editInfo [$field] . '" type="text" style="width:' . $width . 'px;height:' . $height . 'px" id="' . $field . '" name="' . $field . '" maxlength="100" size="20" onfocus="$(this).css(\'display\',\'none\');$(\'#_selectCity\').css(\'display\',\'inline\')" />
						<label id="_selectCity" style="display:none; width:auto;">
                <select id="s_province" name="s_province" style="width:auto;"></select>
                <select id="s_city" name="s_city" style="width:auto;"></select>
                <select id="s_county" name="s_county" style="width:auto;"></select>
                <script type="text/javascript" src="__PUBLIC__/Js/area.js"></script>
                <script type="text/javascript">
				_init_area();
				</script>
				<input type="button" value="确定" class="imgButton" onClick="$(\'#_selectCity\').hide();$(\'#' . $field . '\').css(\'display\',\'inline\');$(\'#' . $field . '\').val($(\'#s_province\').val()+\'-\'+$(\'#s_city\').val()+\'-\'+$(\'#s_county\').val());' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '">
				<input type="button" value="取消" class="imgButton" onClick="$(\'#_selectCity\').hide();$(\'#' . $field . '\').css(\'display\',\'inline\');' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '"></label>';
			break;
		case 'file' :
			$return = '<input style="width:1px; overflow:hidden; padding:0px; border:0px;" size="30" value="' . $editInfo [$field] . '" type="text" id="' . $field . '" name="' . $field . '" onpropertychange="$(\'#view' . $field . '\').attr(\'src\',this.value)"  />
						<input style="margin-left:-1px" type="button" name="btnok" value="上传图片" class="imgButton" style="float:left"  onclick="findPic(event,\'testto\',\'false\');" />
						<img src="' . __default ( $editInfo [$field], '__PUBLIC__/Images/noPic.gif' ) . '" id="view' . $field . '" style="float:left;border:1px solid #ccc; padding:2px; margin-left:5px;max-width:' . $width . 'px; max-height:' . $height . 'px;_height:expression(this.scrollHeight > ' . $height . ' ? \'' . $height . 'px\' : \'auto\');_width:expression(this.scrollWidth > ' . $width . ' ? \'' . $width . 'px\' : \'auto\');" onClick="window.open(this.src)"><div style="clear:both"></div>';
			break;
		case 'upfile' :
			$return = '<table cellpadding="0" cellspacing="0"><tr><td>
				<input style="width:1px; overflow:hidden; padding:0px; border:0px;" type="text" name="' . $field . 'C" id="' . $field . 'C" onfocus="document.all.' . $field . 'S.options[document.all.' . $field . 'S.length]=new Option(\'地址\'+(document.all.' . $field . 'S.length+1)+\'<>/Public/Uploads/soft/\'+this.value,\'地址\'+(document.all.' . $field . 'S.length+1)+\'<>\'+this.value);selectToText(\'' . $field . '\');" />
								<input style="width:1px; overflow:hidden; padding:0px; border:0px;"  value="' . $editInfo [$field] . '" type="text" name="' . $field . '" id="' . $field . '"  onfocus="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" />
								<select name="' . $field . 'S" id="' . $field . 'S" style="width:' . $width . 'px;height:' . $height . 'px; margin:0px; padding:0px;margin-left:-1px" size="2" ondblclick="return ModifyUrl(\'' . $field . '\');">' . _downSelect ( $editInfo [$field] ) . '</select>
								<td><input type="button" name="addurl" class="imgButton"  value="添加外部地址" onClick="AddUrl(\'' . $field . '\');"><br />
								<input type="button" name="modifyurl" class="imgButton" value="修改当前地址" onClick="return ModifyUrl(\'' . $field . '\');"><br />
								<input type="button" name="delurl" class="imgButton" value="删除当前地址"   onClick="DelUrl(\'' . $field . '\');"><br />
								<input  class="imgButton" type="button" name="delurl" value="从文件中选择" onClick="findSoft(event,\'' . $field . '\',\'false\');"></td></tr>
								</table>';
			break;
		case 'select' :
			$return .= '<select  onchange="' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" name="' . $field . '" id="' . $field . '" ><option value="">请选择</option>';
			if (! empty ( $data ['source'] ) && ! empty ( $data ['viewField'] )) {
				$return .= _selectSourse ( $data ['source'], $data ['viewField'], $data ['getIf'], $editInfo [$field] );
			} else {
				$selectNV = explode ( '&&&', $data ['selectItem'] );
				foreach ( $selectNV as $value ) {
					if ($value != "") {
						$str = explode ( '|', $value );
						if ($str [1] == $editInfo [$field]) {
							$return .= '<option value="' . $str [1] . '" selected="selected">' . $str [0] . '</option>';
						} else {
							$return .= '<option value="' . $str [1] . '">' . $str [0] . '</option>';
						}
					}
				}
			}
			
			$return .= '</select>';
			break;
		case 'mulselect' :
			$return .= '<input type="hidden" value="' . $editInfo [$field] . '" name="' . $field . '" id="' . $field . '">
			<select onChange="$(\'#' . $field . '\').val($(this).val());' . str_replace ( '(id', '(\'' . $field . '\'', $jsFun ) . '" style="margin-top:0px; border:0px; height:' . $height . 'px; width:' . $width . 'px" name="' . $field . 's" id="' . $field . 's" multiple="multiple" id="' . $field . '">';
			if (! empty ( $data ['source'] ) && ! empty ( $data ['viewField'] )) {
				$return .= _selectSourse ( $data ['source'], $data ['viewField'], $data ['getIf'], $editInfo [$field] );
			} else {
				$selectNV = explode ( '&&&', $data ['selectItem'] );
				foreach ( $selectNV as $value ) {
					if ($value != "") {
						$str = explode ( '|', $value );
						$valItem = explode ( ',', $editInfo [$field] );
						if (in_array ( $str [1], $valItem )) {
							$return .= '<option selected="selected" value="' . $str [1] . '">' . $str [0] . '</option>';
						} else {
							$return .= '<option value="' . $str [1] . '">' . $str [0] . '</option>';
						}
					}
				}
			}
			
			$return .= '</select>';
			break;
		default :
			$isChkCode = true;
			$return = '<input style="width:' . $width . 'px;height:' . $height . 'px;" id="chkCode" name="chkCode" onpropertychange="if(true == chkNull(\'chkCode\')){if(true == ajaxchkVerify(\'chkCode\')){}}" oninput="if(true == chkNull(\'chkCode\')){if(true == ajaxchkVerify(\'chkCode\')){}}" size="6" maxlength="4" type="text">
			<img style="cursor:pointer; padding-left:20px;" title="刷新验证码" src="' . U ( 'admin-index/verify' ) . '?' . mktime () . '" id="verifyImg" onBlur="freshVerifys()"/> <a href="javascript:freshVerifys()">看不清楚?</a>';
			$return .= '<span class="submit_wanning" id="err_chkCode" style="color:#f00">*必填项!</span>';
			break;
	}
	if ($isChkCode == false) {
		if (strpos ( $jsFun, 'reChk' )) {
			$return .= '<span style="color:#f00" class="submit_wanning" id="err_' . $field . '">检查重复!</span>';
		}
		if ($notNull == false || $noBitian == false) {
			$return .= '<span class="submit_wanning" id="err_' . $field . '"></span>';
		} else {
			if ($editInfo [$field] == '') {
				$return .= '<span class="submit_wanning" id="err_' . $field . '" style="color:#f00">*必填项!</span>';
			} else {
				$return .= '<span class="submit_wanning" id="err_' . $field . '"></span>';
			}
		}
	}
	return $return;
}
function __default($yuan, $quesheng) {
	if (! empty ( $yuan )) {
		return $yuan;
	} else {
		return $quesheng;
	}
}
// 选择数据源数据 @param unknown_type $model = 模型 @param unknown_type $viewField = 显示字段 @param unknown_type $where = 查询条件
function _selectSourse($model, $viewField, $where, $selected = '') {
	$model = M ( ucfirst ( $model ) );
	if (empty ( $where )) {
		$where = '1=1';
	}
	$data = $model->where ( $where )->select ();
	$return = '';
	$array = array ();
	if (! empty ( $selected )) {
		$array = explode ( ',', $selected );
	}
	foreach ( $data as $key ) {
		//if (! empty ( $array ) && $array != '') {
		if (in_array ( $key ['id'], $array )) {
			$return .= '<option value="' . $key ['id'] . '" selected="selected">' . $key [$viewField] . '</option>';
		} else {
			$return .= '<option value="' . $key ['id'] . '">' . $key [$viewField] . '</option>';
		}
	
		//} else {
	//	$return .= '<option value="' . $key ['id'] . '">' . $key [$viewField] . '</option>';
	//}
	}
	return $return;
}
/**
 * 
 * 显示下载列表
 * @param string $value 下载字段内容
 * @param string $nestedTags 嵌套标记对, 如 &lt;li&gt;***&lt;/li&gt;  &lt;span&gt;***&lt;/span&gt; &lt;td&gt;***&lt;/td&gt; 用***标识下载链接 默认输入 null
 */
function getDownSelect($value, $nestedTags) {
	if (empty ( $value )) {
		return '';
	}
	$getData = explode ( '$$$', $value );
	$returnData = '';
	foreach ( $getData as $key ) {
		$getX = explode ( '<>', $key );
		if (strstr ( strtolower ( $getX [1] ), 'http://' ) == false) {
			if ($nestedTags == null) {
				$returnData .= '<div><a  target="_blank" href="' . __ROOT__ . '/Public/Uploads/soft/' . $getX [1] . '">' . $getX [0] . '</a></div>';
			} else {
				$returnData .= str_replace ( '***', '<a target="_blank" href="' . __ROOT__ . '/Public/Uploads/soft/' . $getX [1] . '">' . $getX [0] . '</a>', $nestedTags );
			}
		} else {
			if ($nestedTags == null) {
				$returnData .= '<div><a  target="_blank" href="' . $getX [1] . '">' . $getX [0] . '</a></div>';
			} else {
				$returnData .= str_replace ( '***', '<a  target="_blank" href="' . $getX [1] . '">' . $getX [0] . '</a>', $nestedTags );
			}
		}
	}
	return $returnData;
}
//列表中的数据来源查询
function dataFrom($value, $from) {
	$getOprate = explode ( '_', $from );
	$returnValue = '';
	$model = M ( ucfirst ( $getOprate [0] ) );
	if ($getOprate [2] == 'table') {
		//数据来源是表
		$getData = $model->where ( 'id = ' . $value )->find ();
		$returnValue = $getData [$getOprate [1]];
	} else {
		//否则 来自字段的选择
		$getData = $model->where ( 'id = ' . $getOprate [1] )->find ();
		$getSelect = explode ( '&&&', $getData ['selectItem'] );
		foreach ( $getSelect as $key ) {
			$getValue = explode ( '|', $key );
			if ($value == $getValue [1]) {
				return $getValue [0];
			}
		}
		$returnValue = '错误';
	}
	return $returnValue;
}
/**
 * 
 * 将文本值转换成li形式的列表, 一般在商城选择参数 如 尺码 规格 大小 颜色 等地方用
 * @param unknown_type $value
 */
function formatText($value) {
	$v = explode ( chr ( 13 ), $value );
	$return = '';
	foreach ( $v as $key ) {
		$return .= '<li class="text_li">' . $key . '</li>';
	}
	return $return;
}