<?php
/**
 * 
 * 系统后台操作
 * @author si-yu.com
 * @time 2011/7/1
 *
 */
class ExtraAction extends Action {
	/**
	 * 
	 * 初始化后台
	 */
	function _initialize() {
		header ( "Content-type: text/html; charset=utf-8" );
		import ( "ORG.Io.Dir" );
		import ( "ORG.Util.Page" );
		$city = M ( 'City' );
		$city = $city->select ();
		$this->assign ( 'city', $city );
		Cookie::is_set ( 'city' );
		if (Cookie::get ( 'city' ) == '') {
			Cookie::set ( 'city', '1' );
			$this->assign ( 'cityName', '主站' );
		} else {
			$city = M ( 'City' );
			$getCityName = $city->find ( Cookie::get ( 'city' ) );
			$this->assign ( 'cityName', $getCityName ['cityName'] );
		}
		
		//获取当前模型
		$name = $this->getActionName ();
		$sysOprate = M ( 'Modul' );
		$getOprate = $sysOprate->where ( 'modelName = "' . strtolower ( $name ) . '"' )->find ();
		if (! empty ( $getOprate )) {
			//存在模型
			$viewOprate = $getOprate ['modelCnName'];
			$viewBox = $getOprate ['inBox'];
		} else {
			//自定义模型
			$viewBox = '';
			$viewOprate = '独立单页';
		}
		switch ($viewBox) {
			case 'manage' :
				$boxInfo = 'manage';
				break;
			case 'info' :
				$boxInfo = 'info';
				break;
			case 'back' :
				$boxInfo = 'back';
				break;
			case 'core' :
				$boxInfo = 'core';
				break;
			default :
				$boxInfo = 'manage';
				break;
		}
		$this->assign ( 'boxInfo', $boxInfo );
		$getFunction = str_replace ( __URL__, '', __ACTION__ );
		$viewEvent = '';
		switch ($getFunction) {
			case '/index' :
				$viewOprate = $viewOprate . '管理';
				break;
			case '/add' :
				$viewOprate = '新增' . $viewOprate;
				break;
			case '/edit' :
				$viewOprate = '修改' . $viewOprate;
				break;
			default :
				$viewOprate = $viewOprate . '管理';
				break;
		}
		//初始化管理员登录
		Session::is_set ( 'adminFlag' );
		if (Session::get ( 'adminFlag' ) == '') {
			$loginBg = true;
		} else {
			$loginBg = false;
			$admin = M ( 'Admin' );
			$getAdmin = $admin->where ( 'id = ' . Session::get ( 'adminFlag' ) )->find ();
			$adminLevel = M ( 'Admingroup' );
			$getAdminLevel = $adminLevel->where ( 'id = ' . $getAdmin ['adminGroup'] )->find ();
			//查询对应模块的管理权限
			$levelModel = strtolower ( $this->getActionName () );
			$getPageLevel = 0;
			$pageLevel = $getAdminLevel ['groupLevel'];
			$getStr = strstr ( $pageLevel, $levelModel . '=' );
			if ($getStr) {
				$getStr = str_replace ( $levelModel . '=', '', $getStr );
				$getPageLevel = substr ( $getStr, 0, 1 );
			}
			$this->assign ( 'getPageLevel', $getPageLevel );
			$this->assign ( 'admin', $getAdmin );
			$this->assign ( 'adminLevel', $getAdminLevel );
		}
		
		$this->assign ( 'loginBg', $loginBg );
		$this->assign ( 'viewOprate', $viewOprate );
		/**
		$updateFlag = 2;
		if ($updateFlag == 2) {
			$serverUrl = 'http://www.jmapcms.com';
			$updateUrl = $serverUrl . '/VERSIONS.txt'; //获取服务器版本
			$update = file_get_contents ( $updateUrl );
			$updateVersions = C ( 'SYSTEM_VERSIONS' );
			if ($update) {
				$getWebVersions = str_replace ( 'SYSTEM_VERSIONS=', '', $update );
				if ($getWebVersions != C ( 'SYSTEM_VERSIONS' )) {
					$updateFlag = 1;
					$updateVersions = $getWebVersions;
				}
			}
			$coreActivities = file_get_contents ( $serverUrl . '/index.php/authorization/index/webSite/' . $_SERVER ['HTTP_HOST'] );
		}
		$this->assign ( 'coreActivities', $coreActivities );
		$this->assign ( 'updateFlag', $updateFlag );
		$this->assign ( 'updateVersions', $updateVersions );
		 **/
		$this->assign ( 'coreActivities', 1 );
		$this->assign ( 'updateFlag', 0 );
		$this->assign ( 'updateVersions', 'v1.1' );
		
		//初始化权限设置  有4个页面需要用到
		$this->getModelName ();
	}
	public function _listtest($modul, $map, $order) {
		$model = M ( ucfirst ( strtolower ( $modul ) ) );
		$data = $model->where ( $map )->count ();
		if ($order == '') {
			$order = 'id desc';
		}
		$sql = $model->where ( $map )->order ( $order )->select ();
		$return = array ($data, $model->getLastSql () );
		return $return;
	}
	//查询输入是否重复
	public function repeat() {
		$model = M ( ucfirst ( strtolower ( $this->getActionName () ) ) );
		$map [$_REQUEST ['field']] = $_REQUEST ['value'];
		if ($_REQUEST ['getId']) {
			$map ['id'] = array ('neq', $_REQUEST ['getId'] );
		}
		$data = $model->where ( $map )->find ();
		if (empty ( $data )) {
			$this->ajaxReturn ( '', $model->getLastSql (), 0 );
		} else {
			$this->ajaxReturn ( '', $model->getLastSql (), 1 );
		}
		$this->ajaxReturn ( '', $model->getLastSql (), 1 );
	}
	public function _getInfo($model, $id, $assign = NULL) {
		if ($id == '') {
			$return = array (1, '使用动态查询,无法知道查询结果!' );
			return $return;
		}
		$models = M ( ucfirst ( strtolower ( $model ) ) );
		$sql = $models->where ( 'id=' . $id )->count ();
		$data = $models->find ( $id );
		$return = array ($sql, $models->getLastSql () );
		return $return;
	}
	public function _getList($model, $where = NULL, $order = NULL, $limit = NULL, $assign = NULL) {
		$models = M ( ucfirst ( strtolower ( $model ) ) );
		$count = $models->where ( $where )->order ( $order )->limit ( $limit )->count ();
		$getData = $models->where ( $where )->order ( $order )->limit ( $limit )->select ();
		$return = array ($count, $models->getLastSql () );
		return $return;
	}
	public function choosesite() {
		$city = M ( 'City' );
		$city = $city->select ();
		$this->assign ( 'city', $city );
		if (Cookie::get ( 'city' ) == '') {
			Cookie::set ( 'city', '1' );
			$this->assign ( 'theCity', 'beijing' );
		} else {
			$city = M ( 'City' );
			$getCityName = $city->find ( Cookie::get ( 'city' ) );
			$this->assign ( 'theCity', $getCityName ['cityName'] );
		}
		$this->display ();
	}
	/**
	 * 
	 * 设置分站城市
	 */
	public function setCity() {
		$city = M ( 'city' );
		$getCity = $city->find ( $_REQUEST ['id'] );
		Cookie::set ( 'city', $getCity ['id'] );
		$this->ajaxReturn ( $getCity ['cityName'], '', 1 );
	}
	/**
	 * 
	 * 获取模型名称
	 * @param unknown_type $modelBox 模型所属快
	 */
	public function getModelName() {
		$model = M ( 'Modul' );
		$getCoreLevel = $model->where ( 'inBox = "core"' )->select ();
		$getManageLevel = $model->where ( 'inBox = "manage"' )->select ();
		$getBackLevel = $model->where ( 'inBox = "back"' )->select ();
		$getInfoLevel = $model->where ( 'inBox = "info"' )->select ();
		//实例化
		$this->assign ( 'getCoreLevel', $getCoreLevel );
		$this->assign ( 'getManageLevel', $getManageLevel );
		$this->assign ( 'getBackLevel', $getBackLevel );
		$this->assign ( 'getInfoLevel', $getInfoLevel );
	}
	/**
	 * 
	 * 会员登录验证
	 */
	public function chkLogin() {
		if ($this->verifyCheck ( $_REQUEST ['chkCode'] ) == false) {
			$this->ajaxReturn ( '', '验证码错误!', 2 );
		}
		$model = M ( 'Admin' );
		$getAdmin = $model->where ( 'adminName = "' . $_REQUEST ['adminName'] . '" and adminPass = "' . $_REQUEST ['adminPass'] . '"' )->find ();
		if (empty ( $getAdmin )) {
			$this->ajaxReturn ( '', '用户名密码错误!', 1 );
		} else {
			Session::is_set ( 'adminFlag' );
			Session::set ( 'adminFlag', $getAdmin ['id'] );
			$this->ajaxReturn ( '', '', 3 );
		}
	}
	//检验验证码是否正确  
	public function verifyCheck($chkCode) {
		if (md5 ( $chkCode ) != Session::get ( 'verify' )) {
			return false;
		} else {
			return true;
		}
	}
	// 生成验证码  
	public function verify() {
		import ( "ORG.Util.Image" );
		Image::buildImageVerify ();
	}
	/**
	 * 
	 * 安全退出
	 */
	public function logout() {
		Session::is_set ( 'adminFlag' );
		Session::set ( 'adminFlag', '' );
		Session::clear ();
		$this->ajaxReturn ( 'logout' );
	}
	/**
     +----------------------------------------------------------
	 * Ajax方式返回数据到客户端 重定义
     +----------------------------------------------------------
	 * @access protected
     +----------------------------------------------------------
	 * @param mixed $data 要返回的数据
	 * @param String $info 提示信息
	 * @param boolean $status 返回状态
	 * @param String $status ajax返回类型 JSON XML
     +----------------------------------------------------------
	 * @return void
     +----------------------------------------------------------
	 */
	protected function ajaxReturn($data, $info = '', $status = 1, $type = '', $url = '') {
		// 保证AJAX返回后也能保存日志
		if (C ( 'LOG_RECORD' ))
			Log::save ();
		$result = array ();
		$result ['status'] = $status;
		$result ['info'] = $info;
		$result ['data'] = $data;
		$result ['url'] = $url;
		if (empty ( $type ))
			$type = C ( 'DEFAULT_AJAX_RETURN' );
		if (strtoupper ( $type ) == 'JSON') {
			// 返回JSON数据格式到客户端 包含状态信息
			header ( "Content-Type:text/html; charset=utf-8" );
			exit ( json_encode ( $result ) );
		} elseif (strtoupper ( $type ) == 'XML') {
			// 返回xml格式数据
			header ( "Content-Type:text/xml; charset=utf-8" );
			exit ( xml_encode ( $result ) );
		} elseif (strtoupper ( $type ) == 'EVAL') {
			// 返回可执行的js脚本
			header ( "Content-Type:text/html; charset=utf-8" );
			exit ( $data );
		} else {
			// TODO 增加其它格式
		}
	}
	public function index() {
		//列表过滤器，生成查询Map对象
		$name = $this->getActionName ();
		$this->searchFiels ( $name );
		$view = M ( 'Views' );
		if ($view->where ( 'viewA = "' . strtolower ( $name ) . '"' )->find ()) {
			$model = D ( $name . 'View' );
		} else {
			$model = D ( $name );
		}
		$map = $this->_search ();
		$keyword = $_REQUEST ['keyword'];
		if ($_REQUEST ['selectField']) {
			$keyword = $_REQUEST ['keyword'];
			if (substr ( $keyword, 0, 1 ) == '@') {
				$map [$_REQUEST ['selectField']] = str_replace ( '@', '', $keyword );
			} else {
				$map [$_REQUEST ['selectField']] = array ('like', '%' . $keyword . '%' );
			}
		}
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		$this->display ();
		return;
	}
	/**
	 * 
	 * 搜索条件查询
	 * @param unknown_type $model
	 */
	public function searchFiels($actionName) {
		$model = M ( 'Searchfields' );
		//调用选择搜索
		$getSelectSearch = $model->where ( '`modulName` = "' . $actionName . '" and `searchType` = "select"' )->select ();
		//调用关键词搜索信息
		$getInputSearch = $model->where ( '`modulName` = "' . $actionName . '" and `searchType` = "input"' )->select ();
		//调用枚举搜索
		$getEnumSearch = $model->where ( '`modulName` = "' . $actionName . '" and `searchType` = "enum"' )->select ();
		$this->assign ( 'getSelectSearch', $getSelectSearch );
		$this->assign ( 'getInputSearch', $getInputSearch );
		$this->assign ( 'getEnumSearch', $getEnumSearch );
	}
	/**
     +----------------------------------------------------------
	 * 取得操作成功后要返回的URL地址
	 * 默认返回当前模块的默认操作
	 * 可以在action控制器中重载
     +----------------------------------------------------------
	 * @access public
     +----------------------------------------------------------
	 * @return string
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	function getReturnUrl() {
		return __URL__ . '?' . C ( 'VAR_MODULE' ) . '=' . MODULE_NAME . '&' . C ( 'VAR_ACTION' ) . '=' . C ( 'DEFAULT_ACTION' );
	}
	
	/**
     +----------------------------------------------------------
	 * 根据表单生成查询条件
	 * 进行列表过滤
     +----------------------------------------------------------
	 * @access protected
     +----------------------------------------------------------
	 * @param string $name 数据对象名称
     +----------------------------------------------------------
	 * @return HashMap
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	protected function _search($name = '') {
		//生成查询条件
		if (empty ( $name )) {
			$name = $this->getActionName ();
		}
		$name = $this->getActionName ();
		$model = D ( $name );
		$map = array ();
		if (! empty ( $_REQUEST ['cid'] ) && $_REQUEST ['cid'] != '') {
			$map ['cid'] = $_REQUEST ['cid'];
		}
		if ($this->_issystem ( $name ) == 'no' && $this->isMap ( $name ) == 'no') {
			if (Cookie::get ( 'city' ) != 1) { //如果是分站
				if (C ( 'ROUTER_GET_MAIN' ) == true) { //分站需要获取主站的内容
					$map ['cityid'] = array (array ('eq', Cookie::get ( 'city' ) ), array ('eq', 1 ), 'or' );
				} else {
					$map ['cityid'] = Cookie::get ( 'city' );
				}
			} else { //如果是主站
				if (C ( 'MAIN_GET_ROUTER' ) != true) { //主站不需要获取分站的内容
					$map ['cityid'] = 1;
				}
			}
		}
		foreach ( $model->getDbFields () as $key => $val ) {
			if (isset ( $_REQUEST [$val] ) && $_REQUEST [$val] != '') {
				$map [$val] = $_REQUEST [$val];
			}
		}
		return $map;
	
	}
	/**
	 * 
	 * 判断是否视图被指向
	 * @param unknown_type $name ：模型名称
	 */
	public function isMap($name) {
		$model = M ( 'Views' );
		$getData = $model->where ( 'viewB = "' . strtolower ( $name ) . '"' )->find ();
		if (! empty ( $getData )) {
			return 'yes';
		} else {
			return 'no';
		}
	}
	
	/**
     +----------------------------------------------------------
	 * 根据表单生成查询条件
	 * 进行列表过滤
     +----------------------------------------------------------
	 * @access protected
     +----------------------------------------------------------
	 * @param Model $model 数据对象
	 * @param HashMap $map 过滤条件
	 * @param string $sortBy 排序
	 * @param boolean $asc 是否正序
     +----------------------------------------------------------
	 * @return void
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	protected function _list($model, $map, $sortBy = '', $asc = false) {
		//排序字段 默认为主键名
		if (isset ( $_REQUEST ['_order'] )) {
			$order = $_REQUEST ['_order'];
		} else {
			$order = ! empty ( $sortBy ) ? $sortBy : $model->getPk ();
		}
		//排序方式默认按照倒序排列
		//接受 sost参数 0 表示倒序 非0都 表示正序
		if (isset ( $_REQUEST ['_sort'] )) {
			$sort = $_REQUEST ['_sort'] ? 'asc' : 'desc';
		} else {
			$sort = $asc ? 'asc' : 'desc';
		}
		//取得满足条件的记录数
		$count = $model->where ( $map )->count ();
		if ($count > 0) {
			import ( "@.ORG.Page" );
			//创建分页对象
			if (! empty ( $_REQUEST ['listRows'] )) {
				$listRows = $_REQUEST ['listRows'];
			} else {
				$listRows = '';
			}
			$p = new Page ( $count, $listRows );
			//分页查询数据
			

			$voList = $model->where ( $map )->order ( "`" . $order . "` " . $sort )->limit ( $p->firstRow . ',' . $p->listRows )->findAll ();
			//echo $model->getlastsql();
			//分页跳转的时候保证查询条件
			foreach ( $map as $key => $val ) {
				if (! is_array ( $val )) {
					$p->parameter .= "$key=" . urlencode ( $val ) . "&";
				}
			}
			//分页显示
			$page = $p->show ();
			//列表排序显示
			$sortImg = $sort; //排序图标
			$sortAlt = $sort == 'desc' ? '升序排列' : '倒序排列'; //排序提示
			$sort = $sort == 'desc' ? 1 : 0; //排序方式
			//模板赋值显示
			$this->assign ( 'list', $voList );
			$this->assign ( 'sort', $sort );
			$this->assign ( 'order', $order );
			$this->assign ( 'sortImg', $sortImg );
			$this->assign ( 'sortType', $sortAlt );
			$this->assign ( "page", $page );
		}
		Cookie::set ( '_currentUrl_', __SELF__ );
		return;
	}
	
	function insert() {
		//B('FilterString');
		$name = $this->getActionName ();
		$model = D ( $name );
		$data = $model->create ();
		$data ['cityid'] = Cookie::get ( 'city' );
		if (false == $data) {
			$this->error ( $model->getError () );
		}
		//保存当前数据对象
		$list = $model->add ( $data );
		
		if ($list !== false) { //保存成功
			$this->ajaxReturn ( 1, '数据发布成功!', 4 );
		} else {
			//失败提示
			//$model->getlastsql()  调试最后一次插入语句
			$this->ajaxReturn ( 1, '数据发布成功!', 0 );
		}
	}
	
	public function add() {
		$name = $this->getActionName ();
		//如果视图存在 自动创建视图现象
		$view = M ( 'views' );
		$getView = $view->where ( 'viewA like "' . $this->lowfirst ( $name ) . '"' )->find ();
		if ($getView) {
			$fields = M ( $getView ['viewB'] );
			$getViewB = $fields->where ( 'issystym = 0' )->select ();
			$this->assign ( 'viewB', $getViewB );
			$this->assign ( 'viewField', $getView ['fieldB'] );
		}
		$this->display ();
	}
	
	function read() {
		$this->edit ();
	}
	/**
	 * 
	 * 首字母小写
	 * @param unknown_type $str 字符串
	 */
	public function lowfirst($str) {
		$first = strtolower ( substr ( $str, 0, 1 ) );
		$end = substr ( $str, 1 );
		return $first . $end;
	}
	
	function edit() {
		$name = $this->getActionName ();
		//如果视图存在 自动创建视图现象
		$view = M ( 'views' );
		$getView = $view->where ( 'viewA like "' . $this->lowfirst ( $name ) . '"' )->find ();
		if ($getView) {
			$fields = M ( $getView ['viewB'] );
			$getViewB = $fields->where ( 'issystym = 0' )->select ();
			$this->assign ( 'viewB', $getViewB );
			$this->assign ( 'viewField', $getView ['fieldB'] );
		}
		//结束
		$model = M ( $name );
		$id = $_REQUEST [$model->getPk ()];
		$vo = $model->getById ( $id );
		$this->assign ( 'vo', $vo );
		$this->display ();
	}
	
	function update() {
		$name = $this->getActionName ();
		$model = D ( $name );
		if (false === $model->create ()) {
			$this->ajaxReturn ( '返回列表', $model->getError (), 0, 'json', $cid );
		} // 更新数据
		if (false != $model->where ( 'id=' . $_REQUEST ['id'] )->save ()) {
			//成功提示
			if (! empty ( $_REQUEST ['cid'] )) {
				$cid = U ( 'index', array ('cid' => $_REQUEST ['cid'] ) );
			} else {
				$cid = U ( 'index' );
			}
			$this->ajaxReturn ( '返回列表', '修改成功!', 4, 'json', $cid );
		} else {
			//错误提示
			$this->ajaxReturn ( '返回列表', $model->getError (), 0, 'json', $cid );
		}
	}
	/**
     +----------------------------------------------------------
	 * 默认删除操作
     +----------------------------------------------------------
	 * @access public
     +----------------------------------------------------------
	 * @return string
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	public function delete() {
		//删除指定记录
		$name = $this->getActionName ();
		$model = M ( $name );
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			if (isset ( $id )) {
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				$list = $model->where ( $condition )->setField ( 'delete', - 1 );
				if ($list !== false) {
					$this->success ( '删除成功！' );
				} else {
					$this->error ( '删除失败！' );
				}
			} else {
				$this->error ( '非法操作' );
			}
		}
	}
	public function foreverdelete() {
		//删除指定记录
		$name = $this->getActionName ();
		$model = D ( $name );
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			if (isset ( $id )) {
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				if (false !== $model->where ( $condition )->delete ()) {
					$this->ajaxReturn ( '', '删除成功!', 2 );
				} else {
					$this->ajaxReturn ( '', '删除失败', 0 );
				}
			} else {
				$this->ajaxReturn ( '', $model->getError (), 0 );
			}
		}
		$this->forward ();
	}
	
	public function clear() {
		//删除指定记录
		$name = $this->getActionName ();
		$model = D ( $name );
		if (! empty ( $model )) {
			if (false !== $model->where ( 'status=1' )->delete ()) {
				$this->assign ( "jumpUrl", $this->getReturnUrl () );
				$this->success ( L ( '_DELETE_SUCCESS_' ) );
			} else {
				$this->error ( L ( '_DELETE_FAIL_' ) );
			}
		}
		$this->forward ();
	}
	/**
     +----------------------------------------------------------
	 * 默认禁用操作
	 *
     +----------------------------------------------------------
	 * @access public
     +----------------------------------------------------------
	 * @return string
     +----------------------------------------------------------
	 * @throws FcsException
     +----------------------------------------------------------
	 */
	public function forbid() {
		$name = $this->getActionName ();
		$model = D ( $name );
		$pk = $model->getPk ();
		$id = $_REQUEST [$pk];
		$condition = array ($pk => array ('in', $id ) );
		$list = $model->forbid ( $condition );
		if ($list !== false) {
			$this->assign ( "jumpUrl", $this->getReturnUrl () );
			$this->success ( '状态禁用成功' );
		} else {
			$this->error ( '状态禁用失败！' );
		}
	}
	public function checkPass() {
		$name = $this->getActionName ();
		$model = D ( $name );
		$pk = $model->getPk ();
		$id = $_GET [$pk];
		$condition = array ($pk => array ('in', $id ) );
		if (false !== $model->checkPass ( $condition )) {
			$this->assign ( "jumpUrl", $this->getReturnUrl () );
			$this->success ( '状态批准成功！' );
		} else {
			$this->error ( '状态批准失败！' );
		}
	}
	
	public function recycle() {
		$name = $this->getActionName ();
		$model = D ( $name );
		$pk = $model->getPk ();
		$id = $_GET [$pk];
		$condition = array ($pk => array ('in', $id ) );
		if (false !== $model->recycle ( $condition )) {
			
			$this->assign ( "jumpUrl", $this->getReturnUrl () );
			$this->success ( '状态还原成功！' );
		
		} else {
			$this->error ( '状态还原失败！' );
		}
	}
	
	public function recycleBin() {
		$map = $this->_search ();
		$map ['delete'] = - 1;
		$name = $this->getActionName ();
		$model = D ( $name );
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		$this->display ();
	}
	/**
	 * 
	 * 自动矫正跳转子页面
	 * @param unknown_type $cid 分类ID
	 */
	public function autojump() {
		$name = $this->getActionName ();
		$model = M ( 'Views' );
		$getV = $model->where ( 'viewB = "' . $name . '"' )->find ();
		if ($getV) {
			redirect ( __APP__ . '/Admin/' . $getV ['viewA'] . '/index/cid/' . $_REQUEST ['cid'] );
		}
	}
	
	/**
     +----------------------------------------------------------
	 * 默认恢复操作
	 *
     +----------------------------------------------------------
	 * @access public
     +----------------------------------------------------------
	 * @return string
     +----------------------------------------------------------
	 * @throws FcsException
     +----------------------------------------------------------
	 */
	function resume() {
		//恢复指定记录
		$name = $this->getActionName ();
		$model = D ( $name );
		$pk = $model->getPk ();
		$id = $_GET [$pk];
		$condition = array ($pk => array ('in', $id ) );
		if (false !== $model->resume ( $condition )) {
			$this->assign ( "jumpUrl", $this->getReturnUrl () );
			$this->success ( '状态恢复成功！' );
		} else {
			$this->error ( '状态恢复失败！' );
		}
	}
	
	function saveSort() {
		$seqNoList = $_POST ['seqNoList'];
		if (! empty ( $seqNoList )) {
			//更新数据对象
			$name = $this->getActionName ();
			$model = D ( $name );
			$col = explode ( ',', $seqNoList );
			//启动事务
			$model->startTrans ();
			foreach ( $col as $val ) {
				$val = explode ( ':', $val );
				$model->id = $val [0];
				$model->sort = $val [1];
				$result = $model->save ();
				if (! $result) {
					break;
				}
			}
			//提交事务
			$model->commit ();
			if ($result !== false) {
				//采用普通方式跳转刷新页面
				$this->success ( '更新成功' );
			} else {
				$this->error ( $model->getError () );
			}
		}
	}
	/**
	 * 
	 * 判断输入是否合法
	 */
	public function checkOk() {
		if ($_POST ['val'] == '') {
			$this->ajaxReturn ( '', '输入不能为空！ ', 0 );
		}
		if (! empty ( $_POST ['preg'] )) {
			if (preg_match ( $_POST ['preg'], $_POST ['val'] ) == false) {
				$this->ajaxReturn ( '', '输入不合法，请查看帮助！', 0 );
			} else {
				$this->ajaxReturn ( '', '输入格式正确！', 1 );
			}
		} else {
			$this->ajaxReturn ( '', '输入格式正确！', 1 );
		}
	}
	/**
	 * 
	 * 检查模型英文名称是否重复
	 */
	public function checkRepeat() {
		$name = $this->getActionName ();
		$m = D ( $name );
		if ($_POST ['val'] == '') {
			$this->ajaxReturn ( '', '输入不能为空!', 0 );
		}
		$getChk = $m->where ( $_POST ['field'] . ' like "' . $_POST ['val'] . '"' )->find ();
		if (! empty ( $getChk )) {
			$this->ajaxReturn ( '', L ( 'CHECK_ERROR' ), 0 );
		} else {
			$this->ajaxReturn ( '', L ( 'CHECK_SUCCES' ), 1 );
		}
	}
	/**
	 * 
	 * 获取文件内容
	 * @param unknown_type $file 文件路径+文件名
	 */
	public function _getFileInfo($file) {
		$file = fopen ( $file, 'r' ) or exit ( '读取文件错误!' );
		//读取文件
		$fileInfo = '';
		while ( ! feof ( $file ) ) {
			$fileInfo .= fgets ( $file );
		}
		fclose ( $file );
		return $fileInfo;
	}
	/**
	 * 
	 * 向.php 和 .html 文件中插入内容
	 * @param unknown_type $file 文件路径+文件名
	 * @param unknown_type $start 开始游标
	 * @param unknown_type $end 结束游标
	 * @param unknown_type $content 插入内容
	 * 
	 */
	public function _fileInsert($file, $content) {
		$fileNew = fopen ( $file, 'w' );
		//写文件
		fputs ( $fileNew, stripslashes ( $content ) );
		fclose ( $file );
		return true;
	}
	/**
	 * 
	 * 判断模型是否系统模型
	 * @param unknown_type $model
	 */
	public function _issystem($name) {
		$model = M ( 'modul' );
		$chkModel = $model->where ( 'modelName = "' . strtolower ( $name ) . '"' )->find ();
		if ($chkModel ['issystym'] == 1) {
			return 'yes';
		} else {
			return 'no';
		}
	}
	//快速保存
	public function fun() {
		$name = $this->getActionName ();
		$model = M ( $name );
		$ids = explode ( '__', $_REQUEST ['id'] );
		
		$model->where ( 'id=' . $ids [0] )->setField ( $ids [1], stripslashes ( $_POST ['value'] ) );
		$this->ajaxReturn ( 1, '', 1 );
	}
	//针对优化页面的快速保存
	public function funs() {
		$model = M ( 'Seoinfo' );
		$ids = $_REQUEST ['id'];
		$data = $model->where ( '`object`="' . $ids . '"' )->find ();
		$map ['cnName'] = $_REQUEST ['value'];
		$map ['object'] = $ids;
		if ($data) {
			$model->where ( 'id=' . $data ['id'] )->save ( $map );
		} else {
			$model->add ( $map );
		}
		$this->ajaxReturn ( 1, '', 1 );
	}
	/**
	 * 
	 * 快速保存下拉是否被搜索
	 */
	public function selected() {
		$model = M ( 'Fields' );
		$model->where ( 'id=' . $_REQUEST ['id'] )->setField ( 'searched', $_REQUEST ['value'] );
		$modelView = D ( 'FieldsView' );
		$getData = $modelView->where ( 'fields.id=' . $_REQUEST ['id'] )->find ();
		$searchField = M ( 'Searchfields' );
		//先查询是否已经存在信息
		$getSearch = $searchField->where ( 'modulName="' . ucfirst ( $getData ['modelName'] ) . '" and fieldsName = "' . $getData ['fieldsName'] . '"' )->find ();
		//如果存在 则修改,不存在 则添加
		if ($getSearch) {
			//如果选择不搜索 ,则删除信息
			if (empty ( $_REQUEST ['value'] )) {
				$searchField->where ( 'id=' . $getSearch ['id'] )->delete ();
			} else {
				$searchField->where ( "id=" . $getSearch ['id'] )->setField ( 'searchType', $_REQUEST ['value'] );
			}
		} else {
			$data ['searchType'] = $_REQUEST ['value'];
			$data ['modulName'] = ucfirst ( $getData ['modelName'] );
			$data ['fieldsName'] = $getData ['fieldsName'];
			$data ['fieldsCnName'] = $getData ['viewName'];
			$searchField->add ( $data );
		}
		$this->ajaxReturn ( 1, '', 1 );
	
		//$this->ajaxReturn (  $searchField->getLastSql() );
	}
	/**
	 * 
	 * ajax 联动下拉菜单
	 */
	public function ajaxLinkage() {
		$oppBase = M ( ucfirst ( strtolower ( $_REQUEST ['oppBase'] ) ) );
		$getOpp = $oppBase->where ( $_REQUEST ['oppField'] . ' = ' . $_REQUEST ['id'] )->select ();
		$returnData = '<option value="">请选择</option>';
		foreach ( $getOpp as $key ) {
			$returnData .= '<option value="' . $key ['id'] . '">' . $key [$_REQUEST ['viewName']] . '</option>';
		}
		$this->ajaxReturn ( $returnData, $oppBase->getLastSql (), 1 );
	}
	/**
	 * 
	 * 复制信息
	 */
	public function copyinfo() {
		$name = $this->getActionName ();
		$model = M ( $name );
		$data = $model->find ( $_REQUEST ['id'] );
		array_shift($data);
		$model->add ( $data );
		$this->ajaxReturn ( $model->getLastInsID(), '', 1 );
	}
}