<?php
class InstallAction extends Action {
	function _initialize() {
		header ( "Content-type: text/html; charset=utf-8" );
		$step = 1;
		$this->assign ( 'step', $step );
	}
	public function index() {
		$step = 1;
		$this->assign ( 'step', $step );
		if (file_exists ( 'Conf/install.lock' )) {
			die ( '您已经成功安装了 jmapcms网站开发系统，如需要重新安装请删除Conf/install.lock 文件' );
		}
		$this->display ();
	}
	public function step2() {
		$step = 2;
		$this->assign ( 'step', $step );
		$env = $this->check_env ();
		$this->assign ( 'env', $env );
		$this->display ();
	}
	public function step3() {
		$step = 3;
		$this->assign ( 'step', $step );
		$this->display ();
	}
	public function step4() {
		$step = 4;
		$this->assign ( 'step', $step );
		$dirConfig = 'Conf/config.php';
		$getConfig = $this->isWriteAble ( $dirConfig );
		$dirRuntime = 'Runtime/';
		$getRuntime = $this->isWriteAble ( $dirRuntime );
		$dirLib = 'Lib/';
		$getLib = $this->isWriteAble ( $dirLib );
		$dirTpl = 'Tpl/';
		$getTpl = $this->isWriteAble ( $dirTpl );
		$dirUploads = 'uploads/';
		$getUploads = $this->isWriteAble ( $dirUploads );
		$dirImg = 'Public/Uploads/images/';
		$getImg = $this->isWriteAble ( $dirImg );
		$this->assign ( 'img', $getImg );
		$this->assign ( 'uploads', $getUploads );
		$this->assign ( 'tpl', $getTpl );
		$this->assign ( 'lib', $getLib );
		$this->assign ( 'runtime', $getRuntime );
		$this->assign ( 'config', $getConfig );
		if ($getImg == 1 && $getUploads == 1 && $getTpl == 1 && $getLib == 1 && $getRuntime == 1 && $getConfig == 1) {
			$pass = 1;
		} else {
			$pass = 0;
		}
		$this->assign ( 'pass', $pass );
		$this->display ();
	}
	public function step5() {
		$step = 5;
		$this->assign ( 'step', $step );
		$this->display ();
	}
	public function step6() {
		$step = 6;
		$this->assign ( 'step', $step );
		$dbname = strtolower ( $_REQUEST ['dbname'] );
		$dbhost = $_REQUEST ['dbhost'];
		$dbuser = $_REQUEST ['dbuser'];
		$dbpw = $_REQUEST ['dbpw'];
		$prefix = $_REQUEST ['tablepre'];
		$userName = $_REQUEST ['username'];
		$password = $_REQUEST ['password'];
		//连接数据库创建并选择
		$lnk = mysql_connect ( $dbhost, $dbuser, $dbpw ) or die ( '不能连接数据库 : ' . mysql_error () );
		if (! @mysql_select_db ( $dbname )) {
			@mysql_query ( "CREATE DATABASE " . $dbname );
			if (@mysql_error ()) {
				echo '创建数据失败，请查看您的帐号权限!';
				exit ();
			} else {
				mysql_select_db ( $dbname );
			}
		}
		$dbFile = 'sqlData\jmapcms.sql';
		if (file_exists ( $dbFile )) {
			$sql = file_get_contents ( $dbFile );
			$sql = str_replace ( 'jmap_', $prefix, $sql );
			$sql = str_replace ( "'jmapcms', 'jmapcms'", "'" . $userName . "','" . $password . "'", $sql );
			//将数据库分割成可执行的单条语句
			$sql = str_replace ( "\r", "\n", $sql );
			$ret = array ();
			$num = 0;
			$queriesarray = explode ( ";\n", trim ( $sql ) );
			unset ( $sql );
			foreach ( $queriesarray as $query ) {
				$ret [$num] = '';
				$queries = explode ( "\n", trim ( $query ) );
				$queries = array_filter ( $queries );
				foreach ( $queries as $query ) {
					$str1 = substr ( $query, 0, 1 );
					if ($str1 != '#' && $str1 != '-')
						$ret [$num] .= $query;
				}
				$num ++;
			}
			$this->assign ( 'sql', $ret );
			foreach ( $ret as $key ) {
				mysql_query ( 'set names "gbk"' );
				mysql_query ( iconv('utf-8', 'gbk', $key) );
			}
		
		//mysql_query ( $sql );
		}
		//快速保存配置文件
		$this->saveConfig ( 'DB_HOST', $dbhost );
		$this->saveConfig ( 'DB_USER', $dbuser );
		$this->saveConfig ( 'DB_PWD', $dbpw );
		$this->saveConfig ( 'DB_NAME', $dbname );
		$this->saveConfig ( 'DB_PREFIX', $prefix );
		//设置安装锁定
		$fp = fopen ( "Conf/install.lock", "a" );
		fclose ( $fp );
		$this->display ();
	}
	public function step7() {
		$step = 7;
		$this->assign ( 'step', $step );
		$this->display ();
	}
	/**
	 * 
	 * 快速保存配置选项
	 */
	public function saveConfig($conName, $conValue) {
		$getConfig = $this->_getFileInfo ( 'Conf/config.php' );
		$preg = '/\'' . $conName . '\'=>.*,/';
		$pregs = '\'' . $conName . '\'=>\'' . $conValue . '\',';
		$getConfig = preg_replace ( $preg, $pregs, $getConfig );
		$this->_fileInsert ( 'Conf/config.php', $getConfig );
	}
	/**
	 * 
	 * 向.php 和 .html 文件中插入内容
	 * @param unknown_type $file 文件路径+文件名
	 * @param unknown_type $start 开始游标
	 * @param unknown_type $end 结束游标
	 * @param unknown_type $content 插入内容
	 * 
	 */
	public function _fileInsert($file, $content) {
		$fileNew = fopen ( $file, 'w' );
		//写文件
		fputs ( $fileNew, $content );
		fclose ( $file );
		return true;
	}
	/**
	 * 
	 * 获取文件内容
	 * @param unknown_type $file 文件路径+文件名
	 */
	public function _getFileInfo($file) {
		$file = fopen ( $file, 'r' ) or exit ( '读取文件错误!' );
		//读取文件
		$fileInfo = '';
		while ( ! feof ( $file ) ) {
			$fileInfo .= fgets ( $file );
		}
		fclose ( $file );
		return $fileInfo;
	}
	//判断文件是否可读
	function isWriteAble($file) {
		if (is_dir ( $file )) {
			$dir = $file;
			$fp = fopen ( $dir . "/chkdir.test", 'w' );
			if ($fp) {
				@fclose ( $fp );
				@unlink ( $dir . "/chkdir.test" );
				$writeable = 1;
			} else {
				$writeable = 0;
			}
		} else {
			$fp = fopen ( $file, 'a+' );
			if ($fp) {
				@fclose ( $fp );
				$writeable = 1;
			} else {
				$writeable = 0;
			}
		}
		return $writeable;
	}
	//检查服务器配置
	function check_env() {
		//预定义查询变量
		$info = array ('safe_mode' => array ('运行于安全模式', 0 ), 'allow_url_fopen' => array ('访问 URL 对象', 'OFF', '建议关闭' ), 'register_globals' => array ('注册全局变量', 'OFF', '建议关闭' ), 'magic_quotes_gpc' => array ('魔术引号开启', 'OFF', '建议关闭' ), 'short_open_tag' => array ('短标记支持', 'OFF', '建议关闭' ), 'magic_quotes_runtime' => array ('自动转义溢出字符', 'OFF', '建议关闭' ), 'enable_dl' => array ('允许动态加载链接库', 'OFF', '建议打开' ), 'display_errors' => array ('显示错误信息', 0 ), 'post_max_size' => array ('post最大数据量', 0 ), 'upload_max_filesize' => array ('上传文件的最大大小', 0 ), 'memory_limit' => array ('脚本最大内存使用量', 1 ) );
		
		$fun = array ('mysql_close' => array ('MySQL数据库', 'ON', '推荐使用MySQL数据库' ), 'gd_info' => array ('图形处理 GD 库', 'ON', '建议打开GD库' ), 'socket_accept' => array ('Socket支持', 0 ), 'xml_set_object' => array ('XML解析支持', 'ON', '建议开启' ), 'gzclose' => array ('压缩文件支持(Zlib)', 0 ), 'mcrypt_cbc' => array ('MCrypt加密处理', 0 ), 'preg_match' => array ('PREL相容语法 PCRE', 'ON', '必须打开PREL语法兼容' ) );
		//根据查询条件,动态赋值
		$phpversiON = phpversion (); //获取php版本号
		$versiON_msg = versiON_compare ( PHP_VERSION, '5.2.0', '<' ) ? '推荐使用5.2.0以上版本' : '正常使用';
		$run_env = strtoupper ( php_sapi_name () ); //查看运行环境
		$os = PHP_OS;
		$is_rewrite = false; //预设rewrite为否定
		if (($is_apache = strpos ( $run_env, 'APACHE' )) !== false) {
			$apache_list = apache_get_modules ();
			$is_rewrite = array_search ( 'mod_rewrite', $apache_list ) ? true : false;
			unset ( $apache_list );
		}
		
		foreach ( $info as $key => &$val ) {
			$var = get_cfg_var ( $key ) ? get_cfg_var ( $key ) : ini_get ( $key );
			$val ['value'] = ($var == 0) ? 'OFF' : (($var == 1) ? 'ON' : $var);
			if (is_numeric ( $val [1] ) || $val ['value'] == $val [1]) {
				$val ['message'] = '<span class="blue">√</span>';
			} else {
				$val ['message'] = '<span class="red">' . $val [2] . '</span>';
			}
		}
		foreach ( $fun as $key => &$val ) {
			$val ['value'] = functiON_exists ( $key ) ? 'ON' : 'OFF';
			if (is_numeric ( $val [1] ) || $val ['value'] == $val [1]) {
				$val ['message'] = '<span class="blue">√</span>';
			} else {
				$val ['message'] = '<span class="red">' . $val [2] . '</span>';
			}
		}
		$moban = <<<HTML
    <table>
        <tr class='thead'><td colspan="2">服务器参数</td></tr>
        <tr><th class="tbhead">服务器域名/IP：</th><td>{$_SERVER['SERVER_NAME']} [{$_SERVER['REMOTE_ADDR']}]</td></tr>
        <tr><th class="tbhead">服务端口：</th><td>{$_SERVER['SERVER_PORT']}</td></tr>
        <tr><th class="tbhead">服务器类型/版本：</th><td>{$_SERVER['SERVER_SOFTWARE']}</td></tr>
        <tr><th class="tbhead">服务器操作系统：</th><td>{$os}</td></tr>
        <tr><th class="tbhead">网站根目录：</th><td>{$_SERVER['DOCUMENT_ROOT']}</td></tr>
        <tr><th class="tbhead">当前文件所在位置：</th><td>{$_SERVER['SCRIPT_FILENAME']}</td></tr>
    </table>
    <table>
    <tr class='thead'>
        <td>变量名称</td><td >当前状态</td><td>推荐</td>
    </tr>
    <tbody>
        <tr><th class='tbhead'>PHP版本</th><td>{$phpversiON}</td><td>{$versiON_msg}</td></tr>
        <tr><th class='tbhead'>PHP运行环境</th><td>{$run_env}</td><td></td></tr>
HTML;
		$moban .= "<tr><th class='tbhead'>是否开启rewrite</th><td>";
		if ($is_apache === false) {
			$moban .= "无法检测</td><td></td></tr>";
		} else {
			$moban .= ($is_rewrite) ? '<span color="green">开启</span>' : '<span class="red">未开启</span>';
			$moban .= "</td><td></td></tr>";
		}
		$moban .= "<tr class='thead'><td colspan='3'>PHP环境</td></tr>";
		foreach ( $info as $key => $val ) {
			$moban .= "<tr><th class='tbhead'>{$val[0]} [{$key}]</th><td>{$val['value']}</td><td>{$val['message']}</td></tr>";
		}
		$moban .= "<tr class='thead'><td colspan='3'>PHP模块检测</td></tr>";
		
		foreach ( $fun as $key => $val ) {
			$moban .= "<tr><th class='tbhead'>{$val[0]} [{$key}]</th><td>{$val['value']}</td><td>{$val['message']}</td></tr>";
		}
		$moban .= "</tbody></table></body></html>";
		return $moban;
	}
}