<?php
class JmapAction extends Action {
	/**
	 * 
	 * 初始化后台
	 */
	function _initialize() {
		if (! file_exists ( 'Conf/install.lock' )) {
			$this->redirect ( U ( 'install/index' ) );
		}
		header ( "Content-type: text/html; charset=utf-8" );
		import ( "ORG.Util.Page" );
		import ( "ORG.Net.IpLocation" );
		if (! file_exists ( 'Conf/install.lock' )) {
			echo '<script>location.href="' . U ( 'install/index' ) . '";</script>';
		}
		//调用ip
		$ip = new Iplocation ();
		$location = $ip->getlocation ();
		$ipAdd = iconv ( 'gbk', 'utf-8', $location ['country'] );
		//调用ip 结束
		//调用城市列表
		$city = M ( 'City' );
		$city = $city->select ();
		$this->assign ( 'cityClient', $city );
		foreach ( $city as $keys ) {
			if (strstr ( $ipAdd, $keys ['cityName'] )) {
				$yourIP = $keys ['id'];
				$yourAdd = $keys ['cityName'];
				break;
			}
		}
		//初始化城市
		Cookie::is_set ( 'cityClient' );
		if (Cookie::get ( 'cityClient' ) == '') {
			//判断：如果能找到所在城市那么初始化所在城市，如果没找到则使用北京为初始化
			if (empty ( $yourIP )) {
				Cookie::set ( 'cityClient', '1' );
				$this->assign ( 'cityName', '主站' );
			} else {
				Cookie::set ( 'cityClient', $yourIP );
				$this->assign ( 'cityName', $yourAdd );
			}
		} else {
			$city = M ( 'City' );
			$getCityName = $city->find ( Cookie::get ( 'cityClient' ) );
			$this->assign ( 'cityName', $getCityName ['cityName'] );
		}
		//判断会员登录
		Cookie::is_set ( 'userFlag' );
		if (Cookie::get ( 'userFlag' ) != '') {
			//调出会员信息
			$user = M ( C ( 'MEMBER_MODEL' ) );
			$userInfo = $user->where ( 'id = "' . Cookie::get ( 'userFlag' ) . '"' )->find ();
			$this->assign ( 'userInfo', $userInfo );
		}
		Cookie::is_set ( 'cart' );
		if (Cookie::get ( 'cart' ) == false) {
			Cookie::set ( 'cart', mktime () );
		}
		//滚动公告
		$notic = M ( 'Notic' );
		$getNotic = $notic->order ( 'id desc' )->find ();
		$this->assign ( 'notic', $getNotic );
	}
	
	/**
    +----------------------------------------------------------
	 * 探针模式
    +----------------------------------------------------------
	 */
	public function checkEnv() {
		load ( 'pointer', THINK_PATH . '/Tpl/Autoindex' ); //载入探针函数
		$env_table = check_env (); //根据当前函数获取当前环境
		echo $env_table;
	}
	public function get($id) {
		return $_REQUEST [$id];
	}
	/**
	 * 
	 * 字段自动增加数量
	 */
	public function autoAdd($models, $fields, $num) {
		$model = M ( ucfirst ( strtolower ( $models ) ) );
		$model->setInc ( $fields, 'id=' . get ( 'id' ), $num );
	}
	//查询输入是否重复
	public function repeat() {
		$model = M ( ucfirst ( strtolower ( $_REQUEST ['modul'] ) ) );
		$map [$_REQUEST ['field']] = $_REQUEST ['value'];
		if ($_REQUEST ['getId']) {
			$map ['id'] = array ('neq', $_REQUEST ['getId'] );
		}
		$data = $model->where ( $map )->find ();
		if (empty ( $data )) {
			$this->ajaxReturn ( '', $model->getLastSql (), 0 );
		} else {
			$this->ajaxReturn ( '', $model->getLastSql (), 1 );
		}
		$this->ajaxReturn ( '', $model->getLastSql (), 1 );
	}
	public function seopage($control) {
		$seo = M ( 'Seoinfo' );
		$seoInfo = $seo->where ( 'upper(object)="' . strtoupper ( $this->getActionName () ) . '/' . strtoupper ( $control ) . '"' )->find ();
		//替换动态数据
		$seoT = $seoInfo ['seoTitle'];
		$seoK = $seoInfo ['keywords'];
		$seoD = $seoInfo ['description'];
		$f = M ( 'Fields' );
		$m = M ( 'Modul' );
		if (preg_match_all ( '/\[\$[^\[\]]*_([0-9]{1,5})@([a-zA-Z]{2,10})@\]/', $seoT, $arr, PREG_PATTERN_ORDER )) {
			$idItem = $arr [1];
			$fieldItem = $arr [2];
			$reItem = $arr [0];
			//寻找模型
			$i = 0;
			foreach ( $idItem as $key ) {
				$data = $f->find ( $key );
				$modelIds = $data ['modulId'];
				$datam = $m->find ( $modelIds ); //寻找到对应的模型
				$c = M ( ucfirst ( $datam ['modelName'] ) );
				$datac = $c->where ( 'id = ' . $_REQUEST [$fieldItem [$i]] )->getField ( $data ['fieldsName'] );
				$seoT = str_replace ( $reItem [$i], $datac, $seoT );
				$seoK = str_replace ( $reItem [$i], $datac, $seoK );
				$seoD = str_replace ( $reItem [$i], $datac, $seoD );
				$i ++;
			}
			$seoInfo = array ('seoTitle' => $seoT, 'keywords' => $seoK, 'description' => $seoD );
		}
		$this->assign ( 'seoInfo', $seoInfo );
	
	}
	/**
	 * 
	 * 获取指定模型的信息列表,返回值为 get模型名称且首字母大写 如:getUser
	 * @param unknown_type $model 模型
	 * @param unknown_type $where 查询条件
	 * @param unknown_type $order 排序
	 * @param unknown_type $limit 极限,取多少条
	 */
	public function _getList($model, $where = NULL, $order = NULL, $limit = NULL, $assign = NULL) {
		$models = M ( ucfirst ( strtolower ( $model ) ) );
		$getData = $models->where ( $where )->order ( $order )->limit ( $limit )->select ();
		if ($assign == NULL) {
			$this->assign ( 'get' . ucfirst ( strtolower ( $model ) ), $getData );
		} else {
			$this->assign ( $assign, $getData );
		}
		return $getData;
	}
	/**
	 * 
	 * 获取字段中选择列表的值
	 */
	public function _getFSL($modelName, $field, $assign = NULL) {
		$modul = M ( 'Modul' );
		$getModel = $modul->where ( 'modelName = "' . strtolower ( $modelName ) . '"' )->find ();
		
		$fields = M ( 'Fields' );
		$getData = $fields->where ( 'fieldsName = "' . $field . '" and modulId = ' . $getModel ['id'] )->order ( 'id desc' )->find ();
		$return = explode ( '&&&', $getData ['selectItem'] );
		array_pop ( $return );
		$newArray = array ();
		$i = 0;
		foreach ( $return as $key ) {
			$getX = explode ( '|', $key );
			$newArray [$i] ['name'] = trim ( $getX [0] );
			$newArray [$i] ['value'] = trim ( $getX [1] );
			$i ++;
		}
		if ($assign == NULL) {
			$this->assign ( 'fieldSelectList', $newArray );
		} else {
			$this->assign ( $assign, $newArray );
		}
		return $return;
	}
	/**
	 * 
	 * 调用查询表的数量
	 */
	public function _getSelectNum($modelName, $where = NULL, $assign = NULL) {
		$model = M ( ucfirst ( strtolower ( $modelName ) ) );
		$getCount = $model->where ( $where )->count ();
		if ($assign) {
			$this->assign ( $assign, $getCount );
		} else {
			$this->assign ( 'get' . ucfirst ( strtolower ( $modelName ) ) . 'Num', $getCount );
		}
		return $getCount;
	}
	/**
	 * 
	 * ajax添加信息
	 * 其中必须传入模型的值
	 */
	public function insert() {
		$model = M ( ucfirst ( strtolower ( $_REQUEST ['modul'] ) ) );
		$data = $model->create ();
		if ($model->add ( $data )) {
			$this->ajaxReturn ( 1, '添加成功!', 1 );
		} else {
			$this->ajaxReturn ( 1, $model->getError (), 0 );
		}
	}
	/**
	 * 
	 * ajax获取指定模型中的一条记录的信息
	 */
	public function _ajaxGetInfo() {
		$model = M ( ucfirst ( strtolower ( $_REQUEST ['modul'] ) ) );
		$data = $model->where ( 'id = ' . $_REQUEST ['id'] )->find ();
		$this->ajaxReturn ( $data, $model->getLastSql (), 1 );
	
	}
	/**
	 * 
	 * ajax修改信息
	 * 模型参数,修改主键 必须传入
	 */
	public function update() {
		$model = M ( ucfirst ( strtolower ( $_REQUEST ['modul'] ) ) );
		$data = $model->create ();
		if ($model->save ( $data )) {
			$this->ajaxReturn ( 1, '修改成功!', 1 );
		} else {
			$this->ajaxReturn ( 1, $model->getError (), 0 );
		}
	}
	/**
	 * 
	 * 获取指定模型的指定ID信息
	 * @param unknown_type $model 模型名称
	 * @param unknown_type $id 指定ID
	 */
	public function _getInfo($model, $id = NULL, $assign = NULL) {
		$models = M ( ucfirst ( strtolower ( $model ) ) );
		if (empty ( $id )) {
			$getInfo = $models->find ( $_REQUEST ['id'] );
		} else {
			$getInfo = $models->find ( $id );
		}
		if (! empty ( $assign )) {
			$this->assign ( $assign, $getInfo );
		} else {
			$this->assign ( 'oneInfo', $getInfo );
		}
		return $getInfo;
	}
	/**
	 * 
	 * ajax删除指定模型和指定ID的值,其中id和模型名称都必须从外部传送过来
	 */
	public function _delete() {
		$getModel = $_REQUEST ['model'];
		$getId = $_REQUEST ['id'];
		$model = M ( ucfirst ( strtolower ( $getModel ) ) );
		$model->delete ( $getId );
		$this->ajaxReturn ( $model->getLastSql (), '删除成功!', 1 );
	}
	/**
	 * 
	 * 缓存保存当前地址，如果需要直接使用$this->_cookiePage(); 即可
	 */
	public function _returnPage($isSet = true) {
		Cookie::is_set ( 'returnPage' );
		Cookie::set ( 'returnPage', __SELF__ );
	}
	//获取广告框架信息
	public function _getFrameAd($id) {
		$model = D ( 'AdivView' );
		$getAd = $model->where ( 'adframe.id = ' . $id )->select ();
		return $getAd;
	}
	//获取广告信息
	public function _getAd($id) {
		$model = M ( 'Adiv' );
		$getAd = $model->where ( 'id = ' . $id )->find ();
		return $getAd;
	}
	//会员登出
	public function logout() {
		Cookie::delete ( 'userFlag' );
		$this->ajaxReturn ( 1, '登出成功!', 1 );
	}
	/**
	 * 
	 * 设置分站城市
	 */
	public function setCity() {
		$city = M ( 'city' );
		$getCity = $city->find ( $_REQUEST ['id'] );
		Cookie::set ( 'cityClient', $getCity ['id'] );
		$this->ajaxReturn ( $getCity ['cityName'], '', 1 );
	}
	//检验验证码是否正确  
	public function verifyCheck() {
		if (md5 ( $_REQUEST ['chkCode'] ) != Session::get ( 'verify' )) {
			$this->ajaxReturn ( '', '', 1 );
		} else {
			$this->ajaxReturn ( '', '', 0 );
		}
	}
	// 生成验证码  
	public function verify() {
		import ( "ORG.Util.Image" );
		Image::buildImageVerify ();
	}
	//    +------------------------------------以上是选择分类的代码------------------------------------------------------+ //
	/**
	 * 
	 * 调用分类信息
	 * @param unknown_type $oprate = 需要调用的模型名称
	 * @param int $selectId = 当前被选定的值
	 */
	public function _class($oprate, $selectId) {
		$classLevel = array ();
		$classLevel = $this->_getStru ( strtolower ( $oprate ) );
		$return = '';
		$selectArray = array ();
		if (! empty ( $selectId )) {
			$selectArray = $this->_selectStru ( $classLevel, $selectId );
		}
		$i = 0;
		foreach ( $classLevel as $key ) {
			$return .= $this->_classSelect ( $key, $oprate, $selectArray [$i] );
			$i ++;
		}
		return $return;
	}
	//ajax获取分类信息
	public function _ajaxSelectClass() {
		$class = M ( ucfirst ( $_REQUEST ['sonId'] ) );
		$getView = $this->_isMap ( $_REQUEST ['sonId'], true );
		$getField = $this->_isMaped ( $_REQUEST ['sonId'] );
		$sonClass = $class->where ( '`' . $getView ['idA'] . '` =' . $_REQUEST ['value'] )->select ();
		$returnData = '<option value="">请选择</option>';
		foreach ( $sonClass as $key ) {
			$returnData .= '<option value="' . $key ['id'] . '">' . $key [$getField ['fieldB']] . '</option>';
		}
		$this->ajaxReturn ( $returnData, $class->getlastsql (), 1 );
	}
	//获取分类导航
	/**
	 * @param unknown_type $oprate 分类的模型
	 * @param unknown_type $array 传入分类对应的ID数组，按大到小的顺序
	 * 分类说明：  分类初始化层次可以设置为 bid(大分类) sid(二级分类) tid(三级分类) fid(四级分类)  
	 */
	public function _classMenu($oprate, $array) {
		if (empty ( $array )) {
			return false;
		}
		$getView = $this->_getStru ( $oprate );
		$return = '';
		$get_val = array_values ( $array );
		$get_key = array_keys ( $array );
		if (! empty ( $getView )) {
			$i = 0;
			foreach ( $array as $key ) {
				if (! empty ( $key )) {
					$model = M ( ucfirst ( $getView [$i] ) );
					$getViewd = $this->_isMaped ( $getView [$i] );
					$data = $model->where ( 'id = ' . $key )->find ();
					$getParam = '';
					for($j = 0; $j <= $i; $j ++) {
						$getParam .= '/' . $get_key [$j] . '/' . $get_val [$j];
					}
					$return .= ' > <a href="__ACTION__' . $getParam . '">' . $data [$getViewd ['fieldB']] . '</a>';
					$i ++;
				}
			}
		}
		return $return;
	}
	//根据小导航获取大导航  和 _bigGetSmall 函数相反  最后一个参数一个是数字 一个是数组
	public function _smallGetBig($oprate, $classId) {
		$oprate = strtolower ( $oprate );
		$getModelItem = array_filter ( $this->_getStru ( $oprate ) ); //获取分类模型堆栈
		$getItem = array_filter ( $this->_selectStru ( $getModelItem, $classId ) ); //获取对应的分类堆栈
		/**
		 * 预留项：
		 * id 
		 * cid 视图查询时预留项
		 * aid 地区id
		 * uid 会员id
		 * 用户自定义
		 * 除以上外其他均可使用,以下预存四项，如果还有更多可以自定义添加
		 * 但是有更多的分类项目建议重新设计结构，分类项目越多服务器开销越大。
		 * bid 大分类
		 * sid 二级分类
		 * tid 三级分类
		 * fid 四级分类
		 */
		$arr_key = array ('bid', 'sid', 'tid', 'fid' );
		$return = array ();
		$i = 0;
		foreach ( $getItem as $key ) {
			$return [$arr_key [$i ++]] = $key;
		}
		return $return;
	}
	//根据大导航获取小导航 
	public function _bigGetSmall($oprate, $array) {
		$array = array_filter ( $array );
		if (empty ( $array )) {
			return false;
		}
		$getStru = $this->_getStru ( $oprate );
		$return = array ();
		if (! empty ( $getStru )) {
			$count = count ( $array ) - 1;
			$getViewd = $this->_isMaped ( $getStru [$count] );
			$get_val = array_values ( $array );
			if ($getViewd ['viewA'] == strtolower ( $oprate )) {
				$return = $get_val [$count];
			} else {
				$model = M ( ucfirst ( $getViewd ['viewA'] ) );
				$data = $model->where ( '`' . $getViewd ['idA'] . '` = ' . $get_val [$count] )->select ();
				$i = 0;
				foreach ( $data as $key ) {
					$return [$i ++] = $key ['id'];
				}
			}
		}
		return $return;
	}
	//返回分类选择
	public function _classSelect($oprate, $initOprate, $selectId) {
		$model = M ( $oprate );
		$returnData = $model->select ();
		$getField = $this->_isMaped ( $oprate );
		$return = '';
		if (strtolower ( $initOprate ) == $getField ['viewA']) {
			$ajaxFlag = '\'yes\'';
			$return = '<input type="hidden" value="' . $selectId . '" name="' . $getField ['idA'] . '" id="' . $getField ['viewA'] . '" />';
		} else {
			$ajaxFlag = '\'no\'';
		}
		$return .= '&nbsp;<select id="' . $oprate . '" name="' . $oprate . '" 
   			 onChange="ajaxSelectClass(this.value,\'' . $getField ['viewA'] . '\',' . $ajaxFlag . ')">
   						<option value="">请选择</option>';
		foreach ( $returnData as $key ) {
			$selectEd = '';
			if (! empty ( $selectId )) {
				if ($selectId == $key ['id']) {
					$selectEd = 'selected="selected"';
				} else {
					$selectEd = '';
				}
			}
			$return .= '<option value="' . $key ['id'] . '" ' . $selectEd . '>' . $key [$getField ['fieldB']] . '</option>';
		}
		$return .= '</select>';
		return $return;
	}
	//获取选中ID的堆栈
	public function _selectStru($array, $selectId) {
		$array = array_reverse ( $array );
		$idArray = array ();
		$i = 0;
		foreach ( $array as $key ) {
			$getView = $this->_isMap ( $key, true );
			if ($getView != false) {
				$model = M ( ucfirst ( $getView ['viewA'] ) );
				$getData = $model->where ( 'id = ' . $selectId )->find ();
				$idArray [$i] = $getData [$getView ['idA']];
				$i ++;
			}
		}
		$idArray [$i] = $selectId;
		return $idArray;
	}
	//获取分类结构且堆栈
	public function _getStru($oprate) {
		$oprate = strtolower ( $oprate );
		$top = 0;
		$array = array ();
		while ( $oprate != false ) {
			if ($this->_isMap ( $oprate ) == false) {
				break;
			}
			$array [$top] = $this->_isMap ( $oprate );
			$oprate = $array [$top];
			$top ++;
		}
		$array = array_reverse ( $array );
		return $array;
	}
	//判断视图是否存在
	public function _isMap($oprate, $all = false) {
		$view = M ( 'Views' );
		$getView = $view->where ( 'viewA = "' . $oprate . '"' )->find ();
		if (! empty ( $getView )) {
			if ($all == false) {
				return $getView ['viewB'];
			} else {
				return $getView;
			}
		} else {
			return false;
		}
	}
	//寻找被指向的视图
	public function _isMaped($oprate) {
		$view = M ( 'Views' );
		$getView = $view->where ( 'viewB = "' . $oprate . '"' )->find ();
		if (! empty ( $getView )) {
			return $getView;
		} else {
			return false;
		}
	}
	
	//    +------------------------------------以上是选择分类的代码------------------------------------------------------+ //
	

	/**
     +----------------------------------------------------------
	 * 根据表单生成查询条件
	 * 进行列表过滤
     +----------------------------------------------------------
	 * @access protected
     +----------------------------------------------------------
	 * @param string $name 数据对象名称
     +----------------------------------------------------------
	 * @return HashMap
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	protected function _search($name = '') {
		//生成查询条件
		if (empty ( $name )) {
			$name = $this->getActionName ();
		}
		$name = ucfirst ( strtolower ( $name ) );
		$model = D ( $name );
		$map = array ();
		if (! empty ( $_REQUEST ['cid'] ) && $_REQUEST ['cid'] != '') {
			$map ['cid'] = $_REQUEST ['cid'];
		}
		if (Cookie::get ( 'cityClient' ) != 1 && $this->_issystem ( $name ) == 'no' && $this->isMap ( $name ) == 'no' && $this->addCityClass ( $name ) == 'yes') {
			$map [strtolower ( $name ) . '.cityid'] = Cookie::get ( 'cityClient' );
		}
		foreach ( $model->getDbFields () as $key => $val ) {
			if (isset ( $_REQUEST [$val] ) && $_REQUEST [$val] != '') {
				$map [$val] = $_REQUEST [$val];
			}
		}
		return $map;
	
	}
	/**
	 * 
	 * 参与城市分类
	 */
	public function addCityClass($name) {
		$model = M ( 'modul' );
		$chkModel = $model->where ( 'modelName = "' . strtolower ( $name ) . '"' )->find ();
		if ($chkModel ['addCityClass'] == 0) {
			return 'yes';
		} else {
			return 'no';
		}
	}
	/**
	 * 
	 * 判断是否视图被指向
	 * @param unknown_type $name ：模型名称
	 */
	public function isMap($name) {
		$model = M ( 'Views' );
		$getData = $model->where ( 'viewB = "' . strtolower ( $name ) . '"' )->find ();
		if (! empty ( $getData )) {
			return 'yes';
		} else {
			return 'no';
		}
	}
	
	/**
     +----------------------------------------------------------
	 * 根据表单生成查询条件
	 * 进行列表过滤
     +----------------------------------------------------------
	 * @access protected
     +----------------------------------------------------------
	 * @param Model $model 数据对象
	 * @param HashMap $map 过滤条件
	 * @param string $sortBy 排序
	 * @param boolean $asc 是否正序
     +----------------------------------------------------------
	 * @return void
     +----------------------------------------------------------
	 * @throws ThinkExecption
     +----------------------------------------------------------
	 */
	protected function _list($model, $map, $sortBy) {
		$model = M ( ucfirst ( strtolower ( $model ) ) );
		$order = '';
		if (isset ( $_REQUEST ['_order'] )) {
			$order = $_REQUEST ['_order'];
			$asc = '';
			if ($_REQUEST ['_sort'] == 'asc') {
				$sort = 'desc';
			} else {
				$sort = 'asc';
			}
			$sortImg = $sort; //排序图标
		}
		//取得满足条件的记录数
		$count = $model->where ( $map )->count ();
		if ($count > 0) {
			//创建分页对象
			if (! empty ( $_REQUEST ['listRows'] )) {
				$listRows = $_REQUEST ['listRows'];
			} else {
				$listRows = '';
			}
			$p = new Page ( $count, $listRows );
			//分页查询数据
			if (! empty ( $order )) {
				$voList = $model->where ( $map )->order ( "`" . $order . "` " . $sort )->limit ( $p->firstRow . ',' . $p->listRows )->findAll ();
			} else {
				$voList = $model->where ( $map )->order ( $sortBy )->limit ( $p->firstRow . ',' . $p->listRows )->findAll ();
			}
			//分页跳转的时候保证查询条件
			foreach ( $map as $key => $val ) {
				if (! is_array ( $val )) {
					$p->parameter .= "$key=" . urlencode ( $val ) . "&";
				}
			}
			
			//分页显示
			$page = $p->show ();
			//模板赋值显示
			$this->assign ( 'sort', $sort );
			$this->assign ( 'order', $order );
			$this->assign ( 'pageCount', $count );
			$this->assign ( 'infoList', $voList );
			$this->assign ( 'sortImg', $sortImg );
			$this->assign ( "page", $page );
		}
		Cookie::set ( '_currentUrl_', __SELF__ );
		return;
	}
	protected function _listEdit($model, $map, $sortBy = '', $asc = false) {
		$model = M ( ucfirst ( strtolower ( $model ) ) );
		//排序字段 默认为主键名
		if (isset ( $_REQUEST ['_order'] )) {
			$order = $_REQUEST ['_order'];
		} else {
			$order = ! empty ( $sortBy ) ? $sortBy : $model->getPk ();
		}
		//排序方式默认按照倒序排列
		//接受 sost参数 0 表示倒序 非0都 表示正序
		if (isset ( $_REQUEST ['_sort'] )) {
			$sort = $_REQUEST ['_sort'] ? 'asc' : 'desc';
		} else {
			$sort = $asc ? 'asc' : 'desc';
		}
		//取得满足条件的记录数
		$count = $model->where ( $map )->count ();
		if ($count > 0) {
			import ( "@.ORG.Page" );
			//创建分页对象
			if (! empty ( $_REQUEST ['listRows'] )) {
				$listRows = $_REQUEST ['listRows'];
			} else {
				$listRows = '';
			}
			$p = new Page ( $count, $listRows );
			//分页查询数据
			

			$voList = $model->where ( $map )->order ( "`" . $order . "` " . $sort )->limit ( $p->firstRow . ',' . $p->listRows )->findAll ();
			//echo $model->getlastsql();
			//分页跳转的时候保证查询条件
			foreach ( $map as $key => $val ) {
				if (! is_array ( $val )) {
					$p->parameter .= "$key=" . urlencode ( $val ) . "&";
				}
			}
			//分页显示
			$page = $p->show ();
			//列表排序显示
			$sortImg = $sort; //排序图标
			$sortAlt = $sort == 'desc' ? '升序排列' : '倒序排列'; //排序提示
			$sort = $sort == 'desc' ? 1 : 0; //排序方式
			//模板赋值显示
			$this->assign ( 'list', $voList );
			$this->assign ( 'sort', $sort );
			$this->assign ( 'order', $order );
			$this->assign ( 'sortImg', $sortImg );
			$this->assign ( 'sortType', $sortAlt );
			$this->assign ( "page", $page );
		}
		Cookie::set ( '_currentUrl_', __SELF__ );
		return;
	}
	/**
	 * 
	 * 判断模型是否系统模型
	 * @param unknown_type $model
	 */
	public function _issystem($name) {
		$model = M ( 'modul' );
		$chkModel = $model->where ( 'modelName = "' . strtolower ( $name ) . '"' )->find ();
		if ($chkModel ['issystym'] == 1) {
			return 'yes';
		} else {
			return 'no';
		}
	}
	/**
	 * 
	 * ajax 联动下拉菜单
	 */
	public function ajaxLinkage() {
		$oppBase = M ( ucfirst ( strtolower ( $_REQUEST ['oppBase'] ) ) );
		$getOpp = $oppBase->where ( $_REQUEST ['oppField'] . ' = ' . $_REQUEST ['id'] )->select ();
		$returnData = '<option value="">请选择</option>';
		foreach ( $getOpp as $key ) {
			$returnData .= '<option value="' . $key ['id'] . '">' . $key [$_REQUEST ['viewName']] . '</option>';
		}
		$this->ajaxReturn ( $returnData, $oppBase->getLastSql (), 1 );
	}
	/**
	 * 
	 * ajax 字段联动下拉菜单
	 */
	public function ajaxLinkFiled() {
		$oppBase = M ( ucfirst ( strtolower ( $_REQUEST ['oppBase'] ) ) );
		$getOpp = $oppBase->where ( $_REQUEST ['oppField'] . ' = ' . $_REQUEST ['id'] )->select ();
		$returnData = '<option value="">请选择</option>';
		foreach ( $getOpp as $key ) {
			$returnData .= '<option value="' . $key ['fieldsName'] . '">' . $key [$_REQUEST ['viewName']] . '</option>';
		}
		$this->ajaxReturn ( $returnData, $oppBase->getLastSql (), 1 );
	}
	/**
	 * 
	 * ajax 字段联动选择标签
	 */
	public function ajaxLinkFiledLabel() {
		$oppBase = M ( ucfirst ( strtolower ( $_REQUEST ['oppBase'] ) ) );
		$getOpp = $oppBase->where ( $_REQUEST ['oppField'] . ' = ' . $_REQUEST ['id'] )->select ();
		$returnData = '';
		foreach ( $getOpp as $key ) {
			$returnData .= '<label title="' . $key ['viewName'] . '" value="' . $key ['fieldsName'] . '">' . $key [$_REQUEST ['fieldsName']] . '</option>';
		}
		$this->ajaxReturn ( $returnData, $oppBase->getLastSql (), 1 );
	}
	/**
	 * 
	 * 会员注册
	 */
	public function regUser() {
		$model = M ( C ( 'MEMBER_MODEL' ) );
		$data = $model->create ();
		if ($model->add ( $data )) {
			Cookie::is_set ( 'userFlag' );
			Cookie::set ( 'userFlag', $model->getLastInsID () );
			$this->ajaxReturn ( 1, '注册成功!', 1 );
		} else {
			$this->ajaxReturn ( 1, $model->getError (), 0 );
		}
	}
	/**
	 * 
	 * 加载会员信息
	 */
	public function loadUser() {
		if (Cookie::get ( 'userFlag' )) {
			$user = M ( C ( 'MEMBER_MODEL' ) );
			$userInfo = $user->where ( 'id = "' . Cookie::get ( 'userFlag' ) . '"' )->find (); //查找会员信息
			$group = M ( 'Usergroup' );
			$userGroup = $group->where ( 'id=' . $userInfo ['userGroup'] )->find ();
			echo '<a href="' . U ( 'user/manage' ) . '" style="font-weight:bold; color:#000"><img style="width:20px; height:20px; border:0px" src="' . getHead ( $userInfo ['id'], false ) . '">&nbsp;' . $userInfo ['userName'] . '</a> | 会员组:' . _getMFV ( $userInfo ['userGroup'], 'usergroup', 'groupName' ) . ' | <a href="javascript:logout()">退出</a>';
		} else {
			echo '<a href="javascript:login()">请登录</a> | <a href="javascript:reg()">注册</a>';
		}
	}
	/**
	 * 
	 * 检查登录是否登录成功
	 */
	public function chkLogin() {
		$user = M ( C ( 'MEMBER_MODEL' ) );
		$data = $user->create ();
		$userInfo = $user->where ( $data )->find ();
		if (! empty ( $userInfo )) {
			Cookie::is_set ( 'userFlag' );
			Cookie::set ( 'userFlag', $userInfo ['id'] );
			$this->ajaxReturn ( '', '登录成功!', 1 );
		} else {
			$this->ajaxReturn ( '', '用户名密码错误!', 0 );
		}
	}
	/**
	 * 
	 * 修改密码
	 */
	public function chgPassword() {
		$user = M ( C ( 'MEMBER_MODEL' ) );
		$data = $user->where ( 'id=' . Cookie::get ( 'userFlag' ) . ' and userPass = "' . $_REQUEST ['userName'] . '"' )->find ();
		if (! empty ( $data )) {
			$user->setField ( 'userPass', $_REQUEST ['userPass'], 'id=' . Cookie::get ( 'userFlag' ) );
			$this->ajaxReturn ( '', '密码修改成功!', 1 );
		} else {
			$this->ajaxReturn ( '', '旧密码输入错误!', 0 );
		}
	}
	/**
	 * 
	 * 找回密码
	 */
	public function findPass() {
		$user = M ( C ( 'MEMBER_MODEL' ) );
		$data = $user->where ( 'userName="' . $_REQUEST ['userName'] . '" and userEmail = "' . $_REQUEST ['userEmail'] . '"' )->find ();
		if (! empty ( $data )) {
			$user->setField ( 'userPass', '123456', 'userName="' . $_REQUEST ['userName'] . '"' );
			$this->ajaxReturn ( '', '您的密码已经初始化为 123456 ,请登录后及时更改!', 1 );
		} else {
			$this->ajaxReturn ( $user->getLastSql (), '注册账号和注册邮箱不对应!', 0 );
		}
	}
	public function foreverdelete() {
		//删除指定记录
		$model = M ( ucfirst ( strtolower ( $_REQUEST ['model'] ) ) );
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			if (isset ( $id )) {
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				if (false !== $model->where ( $condition )->delete ()) {
					$this->ajaxReturn ( '', '删除成功!', 2 );
				} else {
					$this->ajaxReturn ( '', '删除失败', 0 );
				}
			} else {
				$this->ajaxReturn ( '', $model->getError (), 0 );
			}
		}
		$this->forward ();
	}
	/**
	 * 
	 * ajax 添加购物车
	 */
	public function addCart() {
		$model = M ( 'Cart' );
		$map ['cartCode'] = Cookie::get ( 'cart' );
		$map ['proIdItem'] = $_REQUEST ['id'];
		$product = M ( 'Product' );
		$proData = $product->find ( $_REQUEST ['id'] );
		//如果存在多种价格可在这里设置
		$map ['proPrice'] = $proData ['proPrice'];
		$map ['proNum'] = $_REQUEST ['num'];
		$map ['proOprate'] = $_REQUEST ['oprate'];
		$data = $model->data ( $map )->add ();
		if (! empty ( $data )) {
			$this->ajaxReturn ( '', $model->getLastSql (), 1 );
		} else {
			$this->ajaxReturn ( $model->getError (), $model->getLastSql (), 0 );
		}
	}
	/**
	 * 
	 * 及时更新数量
	 */
	public function updatacart() {
		$model = M ( 'Cart' );
		$model->where ( 'id=' . $_REQUEST ['id'] )->setField ( 'proNum', $_REQUEST ['num'] );
		$data = $model->find ( $_REQUEST ['id'] );
		$this->ajaxReturn ( '', $data ['proPrice'] * $data ['proNum'], 1 );
	}
	/**
	 * 
	 * 及时更新当前总价
	 */
	public function ajaxLoadAllPrice($ajaxReturn = false) {
		$model = M ( 'Cart' );
		$data = $model->where ( 'cartCode="' . Cookie::get ( 'cart' ) . '"' )->select ();
		$return = 0;
		foreach ( $data as $key ) {
			$return += $key ['proPrice'] * $key ['proNum'];
		}
		if ($ajaxReturn) {
			return $return;
		} else {
			$this->ajaxReturn ( $return, '', 1 );
		}
	}
	/**
	 * 
	 * 整合当前购物车,使用数组方式整合统一提交能更可能的提高效率
	 */
	public function zhenghe() {
		$model = M ( 'Cart' );
		$data = $model->where ( 'cartCode="' . Cookie::get ( 'cart' ) . '"' )->select ();
		$newData = array ();
		foreach ( $data as $key ) {
			$flag = false;
			$i = 0;
			foreach ( $newData as $value ) {
				if ($flag == false) {
					if ($key ['proIdItem'] == $value ['proIdItem']) {
						$flag = true;
						$newData [$i] ['proNum'] = $value ['proNum'] + $key ['proNum'];
					}
				}
				$i ++;
			}
			if ($flag == false) {
				array_push ( $newData, $key );
			}
		}
		//先删除原始数据 ,然后保存新数据
		$model->where ( 'cartCode="' . Cookie::get ( 'cart' ) . '"' )->delete ();
		foreach ( $newData as $key ) {
			$model->data ( $key )->add ();
		}
		$this->ajaxReturn ( '', '', 1 );
	}
	/**
	 * 
	 * 控制器方式获得会员信息
	 */
	public function getUserInfo() {
		if (Cookie::get ( 'userFlag' ) != '') {
			//调出会员信息
			$user = M ( C ( 'MEMBER_MODEL' ) );
			return $user->where ( 'id = "' . Cookie::get ( 'userFlag' ) . '"' )->find ();
		}
	}
	/**
	 * 
	 * 加载购物车信息
	 */
	public function getAjaxCart() {
		if (Cookie::get ( 'cart' )) {
			$return = '<table cellpadding="0" cellspacing="0" border="0" width="100%" class="cart">';
			$map ['cartCode'] = Cookie::get ( 'cart' );
			$order = 'id desc';
			$limit = '30';
			$assign = 'cart';
			$data = $this->_getList ( 'cart', $map, $order, $limit, $assign );
			if (! empty ( $data )) {
				$allPrice = 0;
				foreach ( $data as $list ) {
					$return .= '<tr class="td"><td width="60">';
					$return .= '<a href="' . U ( 'product/show', array ('id' => $list ['proIdItem'] ) ) . '">' . getPic ( _getMFV ( $list ['proIdItem'], 'product', 'proPic' ), '50', '50' ) . '</a></td>
					<td><a href="' . U ( 'product/show', array ('id' => $list ['proIdItem'] ) ) . '">' . _getMFV ( $list ['proIdItem'], 'product', 'proTitle' ) . '</a></td>
			 		<td width="100" align="center">￥<span class="ajaxPrice">' . $list ['proPrice'] . '</span>×<span class="ajaxNum">' . $list ['proNum'] . '</span><br><a href="javascript:cartDel(\'cart\','.$list['id'].')">删除</a></td>
			        ';
					$return .= '</td></tr>';
					$allPrice += $list ['proPrice'] * $list ['proNum'];
				}
				echo $return . '</table><div style="text-align:right">总金额:￥<span class="ajaxPrice price">' . $allPrice . '</span><br /><a href="' . U ( 'product/cart' ) . '"><img src="/Public/Css/images/jiesuan.gif"></a></div>';
			} else {
				echo '购物车中还没有商品，赶紧选购吧！';
			}
		} else {
			echo '购物车中还没有商品，赶紧选购吧！';
		}
	}
	public function getAjaxCartNum() {
		$map ['cartCode'] = Cookie::get ( 'cart' );
		$order = 'id desc';
		$limit = '30';
		$assign = 'cart';
		$data = $this->_getList ( 'cart', $map, $order, $limit, $assign );
		if (! empty ( $data )) {
			$return = 0;
			foreach ( $data as $list ) {
				$return += $list ['proNum'];
			}
			echo $return . '件';
		} else {
			echo '0件';
		}
	}

}
?>