<?php
/*
Uploadify v2.1.0
Release Date: August 24, 2009

Copyright (c) 2009 Ronnie Garcia, Travis Nickels

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
$config = require_once './../../../../Conf/config.php';



if (! empty ( $_FILES )) {
	$tempFile = $_FILES ['Filedata'] ['tmp_name'];
	$targetPath = $_SERVER ['DOCUMENT_ROOT'] . $_REQUEST ['folder'] . '/';
	//@list ( $filesname, $type ) = explode ( ".", $_FILES ['Filedata'] ['name'] ); //获取扩展名
	$fileInfo = pathinfo($_FILES ['Filedata'] ['name']); 
	if (! empty ( $_COOKIE ['userFlag'] )) {
		$targetFile = str_replace ( '//', '/', $targetPath ) . $_COOKIE ['userFlag'] . '__' . date ( 'y_m_d_', mktime () ).rand(0,300) . $fileInfo['basename'];
	} else {
		$targetFile = str_replace ( '//', '/', $targetPath ) . 'admin__' . date ( 'y_m_d_', mktime () ).rand(0,300)   . $fileInfo['basename'];
	}
	move_uploaded_file ( $tempFile, iconv("UTF-8","gb2312",$targetFile) );
	
	if ($config['OPEN_WATER'] == true) {
		if ($config['WATER_TYPE'] == false) {
			imageWaterMark ( $targetFile, $config['WATER_POS'], "", $config['WATER_CONTENT'], $config['WATER_SIZE'], $config['TEXT_COLOR'], $config['X_OFFSET'], $config['Y_OFFSET'] );
		} else {
			imageWaterMark ( $targetFile, $config['WATER_POS'], $config['WATER_IMAGE'],"", $config['WATER_SIZE'], $config['TEXT_COLOR'], $config['X_OFFSET'], $config['Y_OFFSET'] );
		}
	}
	
	echo "1";
}

function imageWaterMark($groundImage, $waterPos = 0, $waterImage = "", $waterText = "", $fontSize = 24, $textColor = "#FF0000", $xOffset = -20, $yOffset = -20, $fontfile = './arial.ttf') 

{
	
	$isWaterImage = FALSE;
	
	//读取水印文件
	

	if (! empty ( $waterImage ) && file_exists ( $waterImage )) {
		
		$isWaterImage = TRUE;
		
		$water_info = getimagesize ( $waterImage );
		
		$water_w = $water_info [0]; //取得水印图片的宽
		

		$water_h = $water_info [1]; //取得水印图片的高
		

		switch ($water_info [2]) { //取得水印图片的格式 
			

			case 1 :
				$water_im = imagecreatefromgif ( $waterImage );
				break;
			
			case 2 :
				$water_im = imagecreatefromjpeg ( $waterImage );
				break;
			
			case 3 :
				$water_im = imagecreatefrompng ( $waterImage );
				break;
			
			default :
				return 1;
		
		}
	
	}
	
	//读取背景图片
	

	if (! empty ( $groundImage ) && file_exists ( $groundImage )) {
		
		$ground_info = getimagesize ( $groundImage );
		
		$ground_w = $ground_info [0]; //取得背景图片的宽
		

		$ground_h = $ground_info [1]; //取得背景图片的高
		

		switch ($ground_info [2]) { //取得背景图片的格式 
			

			case 1 :
				$ground_im = imagecreatefromgif ( $groundImage );
				break;
			
			case 2 :
				$ground_im = imagecreatefromjpeg ( $groundImage );
				break;
			
			case 3 :
				$ground_im = imagecreatefrompng ( $groundImage );
				break;
			
			default :
				return 1;
		
		}
	
	} else {
		
		return 2;
	
	}
	
	//水印位置
	

	if ($isWaterImage) { //图片水印 
		

		$w = $water_w;
		
		$h = $water_h;
		
		$label = "图片的";
	
	} else {
		
		//文字水印
		

		if (! file_exists ( $fontfile ))
			return 4;
		
		$temp = imagettfbbox ( $fontSize, 0, $fontfile, $waterText ); //取得使用 TrueType 字体的文本的范围
		

		$w = $temp [2] - $temp [6];
		
		$h = $temp [3] - $temp [7];
		
		unset ( $temp );
	
	}
	
	if (($ground_w < $w) || ($ground_h < $h)) {
		
		return 3;
	
	}
	
	switch ($waterPos) {
		
		case 0 : //随机
			

			$posX = rand ( 0, ($ground_w - $w) );
			
			$posY = rand ( 0, ($ground_h - $h) );
			
			break;
		
		case 1 : //1为顶端居左
			

			$posX = 0;
			
			$posY = 0;
			
			break;
		
		case 2 : //2为顶端居中
			

			$posX = ($ground_w - $w) / 2;
			
			$posY = 0;
			
			break;
		
		case 3 : //3为顶端居右
			

			$posX = $ground_w - $w;
			
			$posY = 0;
			
			break;
		
		case 4 : //4为中部居左
			

			$posX = 0;
			
			$posY = ($ground_h - $h) / 2;
			
			break;
		
		case 5 : //5为中部居中
			

			$posX = ($ground_w - $w) / 2;
			
			$posY = ($ground_h - $h) / 2;
			
			break;
		
		case 6 : //6为中部居右
			

			$posX = $ground_w - $w;
			
			$posY = ($ground_h - $h) / 2;
			
			break;
		
		case 7 : //7为底端居左
			

			$posX = 0;
			
			$posY = $ground_h - $h;
			
			break;
		
		case 8 : //8为底端居中
			

			$posX = ($ground_w - $w) / 2;
			
			$posY = $ground_h - $h;
			
			break;
		
		case 9 : //9为底端居右
			

			$posX = $ground_w - $w;
			
			$posY = $ground_h - $h;
			
			break;
		
		default : //随机
			

			$posX = rand ( 0, ($ground_w - $w) );
			
			$posY = rand ( 0, ($ground_h - $h) );
			
			break;
	
	}
	
	//设定图像的混色模式
	

	imagealphablending ( $ground_im, true );
	
	if ($isWaterImage) { //图片水印
		

		imagecopy ( $ground_im, $water_im, $posX + $xOffset, $posY + $yOffset, 0, 0, $water_w, $water_h ); //拷贝水印到目标文件        
	

	} else { //文字水印
		

		if (! empty ( $textColor ) && (strlen ( $textColor ) == 7)) {
			
			$R = hexdec ( substr ( $textColor, 1, 2 ) );
			
			$G = hexdec ( substr ( $textColor, 3, 2 ) );
			
			$B = hexdec ( substr ( $textColor, 5 ) );
		
		} else {
			
			return 5;
		
		}
		
		imagettftext ( $ground_im, $fontSize, 0, $posX + $xOffset, $posY + $h + $yOffset, imagecolorallocate ( $ground_im, $R, $G, $B ), $fontfile, $waterText );
	
	}
	
	//生成水印后的图片
	

	@unlink ( $groundImage );
	
	switch ($ground_info [2]) { //取得背景图片的格式
		

		case 1 :
			imagegif ( $ground_im, $groundImage );
			break;
		
		case 2 :
			imagejpeg ( $ground_im, $groundImage );
			break;
		
		case 3 :
			imagepng ( $ground_im, $groundImage );
			break;
		
		default :
			return 6;
	
	}
	
	//释放内存
	

	if (isset ( $water_info ))
		unset ( $water_info );
	
	if (isset ( $water_im ))
		imagedestroy ( $water_im );
	
	unset ( $ground_info );
	
	imagedestroy ( $ground_im );
	
	//
	

	return 0;

}

?>