<?php
class Site_Biquge extends Site_Base
{
    public static $siteUrl = 'http://www.biquge.com';

    public static $siteName = '笔趣阁';

    public $lockTime = 900;

    public $fetchImage = true;

    public $isReplaceFetch = false;

    protected $_infoFiles = '';

    protected $_chapterListUrl = null;

    protected $_denyBooks = array(9477,786,14314);

    public function __construct($detailUrl)
    {
        parent::__construct($detailUrl);

         preg_match('/\d+_(\d+)/i', $detailUrl, $matches);
         $this->_bookId = intval($matches[1]);
    }

    /**
      * 获取小说整体信息，如简介、ID之类的
      * @return void
      */
     public function getInfoFile()
     {
         $infoUrl = self::$siteUrl . '/0_' . $this->_bookId . '/';
         $this->_infoFiles = $this->getFile($infoUrl, 'gbk', 'utf-8');         
     }

    public function getFile($url, $inCharset = null, $outCharset = null)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //curl_setopt($ch, CURLOPT_REFERER, 'www.biquge.com');
        curl_setopt($ch, CURLOPT_USERAGENT, 'compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)');
        //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Host: www.biquge.com','Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8'));
        $result = curl_exec($ch);

        if (!empty($result) && !is_null($inCharset) && !is_null($outCharset))
        {
            $result = iconv($inCharset, $outCharset, $result);
        }

        return $result;
    }

    /**
      * 获取小说名
      * @return string
      */
     public function getBookName()
     {
        preg_match('/<h1>(.*)</h1>/is', $this->_infoFiles, $bookname);

        return trim($bookname[1]);
     }

    /**
      * 取得小说作者名
      * @return string
      */
    public function getAuthor()
    {
        preg_match('/<font color="green">(.*?)<\/font><\/span>/i', $this->_infoFiles, $author);
        return trim($author[1]);
    }

    /**
     * 取得小说简介
     * @return string
     */
    public function getBookInfo()
    {
        preg_match('/<div class="intro">(.*?)<\/div>/is', $this->_infoFiles, $bookinfo);
        if(!empty($bookinfo))
        {
             return analyzeText($bookinfo[1]);
        }
        else
        {
            return '';
        }
       
    }

    /**
     * 取得小说写作状态
     * @return int
     */
    public function getStatus()
    {
        preg_match('/<font color="orange">(.*?)<\/font>/i', $this->_infoFiles, $status);  
       
        if ($status[1] == '连载')
        {
            return 0;
        }

        return 1;
    }

    /**
     * 取得章节列表的url
     * @return string
     */
    public function getChapterListUrl()
    {
        if (!is_null($this->_chapterListUrl))
        {
            return $this->_chapterListUrl;
        }

        return $this->_chapterListUrl = self::$siteUrl . '/0_'.$this->getBookId().'/';
    }

       /**
        * 设置章节列表URL
        * @param string $url
        * @return void
        */
    public function setChapterListUrl($url)
    {
        $this->_chapterListUrl = $url;
    }

    /**
     * 取得小说所有章节地址
     * @return array
     */
    public function getChapterList()
    {
        $list = array('hasVolume' => false);
        $chapterListContent = $this->getFile($this->getChapterListUrl(), 'gb18030', 'utf-8');
        //preg_match_all('/<div class="Volume">.*?<\/div>(.*?)<\/div>/is', $chapterListContent, $matches);
        preg_match_all('/<dd>\<a\s*href=\"(\/\d+_\d+\/\d+\.html)\"\s*title=\".*?\">(.*?)\<\/a>\<\/dd>/is',$chapterListContent, $mmm);
        $urlArray = $mmm[1];
        $titleArray = $mmm[2];
        $array = array();

        if (!empty($urlArray))
        {
            foreach ($urlArray as $key => $value)
            {
                $array[] = array('url' => $value, 'title' => $titleArray[$key]);
            }
        }

        $list['chapters'] = $array;

        // 降低频率，防止被屏蔽
        sleep(1);
        $this->setChapterArray($list);
        return $list;
    }

    /**
     * 取得章节名
     * @param string $chapterContent
     * @return string
     */
    public function getChapterName($chapterContent)
    {
        preg_match('/<div class="Title">(.*)<\/div>/is', $chapterContent, $chaptername);

        return $this->analyzeChapterName(str_replace(array('正文','作品','分卷阅读'), '', $chaptername[1]));
    }

    /**
     * 从原始的单一章节内容中过滤出章节内容
     * @param string $chapterContent
     * @return string
     */
    public function filterChapterContent($chapterContent)
    {
        preg_match('/<div\s*id=\"content\">(.*?)\<div\s*id=\"bdshare\"/is', $chapterContent, $content);
        $c = $content[1];
        if ($this->isImage($content[1]))
        {
            preg_match_all('/<img\s*src=\"(.*?)\"/is', $content[1], $images);
            $c = implode("\n", $images[1]);
        }
        else
        {
            $c = strip_tags($this->analyzeContent($content[1]));
        }

        return $c;
    }

    /**
     * 取得单一章节内容
     * @param $contentUrl
     * @return string
     */
    public function getChapterContent($contentUrl)
    {
        return $this->getFile($contentUrl, 'gb18030', 'utf-8');
    }

    /**
     * 取得一条完整的章节内容URL
     * @param string $chapterHtml
     * @return string
     */
    public function getChapterContentUrl($chapterHtml)
    {
        return $this->siteUrl() . $chapterHtml;
    }

    /**
     * 判断内容是否为图片
     * @param string $chapterContent
     * @return boolean
     */
    public function isImage($chapterContent)
    {
        if (preg_match('/\w+\.(gif|jpg)/is', $chapterContent))
        {
            return true;
        }

        return false;
    }

    public function isCanSave($content)
    {
        if (empty($content))
        {
            return false;
        }

        return true;
    }

    /**
     * 获取一个完整的图片地址
     * @param string $image
     * @return string
     */
    public function getImageUrl($image)
    {
        return $image;
    }

    /**
     * 抓图片内容
     * @param $imageUrl
     * @return mixed|string
     */
    public function getImage($imageUrl)
    {
        //return getFile($imageUrl);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $imageUrl);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //curl_setopt($ch, CURLOPT_REFERER, 'pic.biquge.com');
        curl_setopt($ch, CURLOPT_USERAGENT, 'compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)');
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Host: pic.biquge.com:8080','Accept: image/png,image/*;q=0.8,*/*;q=0.5'));
        $contents = curl_exec($ch);

        //echo $imageUrl . "\n";
        return $contents;
    }

    /**
     * 抓取封面地址
     * @return array
     */

    /*public function getCoverUrl()
    {
        $return = false;
        preg_match('/<div class="bookcover"><a href=.*><img src="(.*)"><\/a><\/div>/i', $this->_infoFiles, $cover);
        if(!empty($cover[1]) && false !== strpos($cover[1], 'DownFiles'))
        {
            $url = explode('/', $cover[1]);
         
            $name = $url[count($url) - 1];
            if (!empty($name) && 'noimg.gif' != $name)
            {
                $fileext = array_pop(explode('.', $name));
                $imgurl = self::siteUrl() . $cover[1];
                $return = array('url'=>$imgurl,'fileext'=>$fileext);
            }
        }
         return $return;
    }*/

    /**
     * 在目标站点搜索小说
     * @param string $bookName
     * @param string $authorName
     * @return string|boolean
     */
    public static function searchBook($bookName, $authorName)
    {
        $searchUrl = self::siteUrl() . '/Book/Search.aspx';
        $post = array(
            'SearchClass' => 1,
            'SearchKey' => iconv('utf-8','gb18030',$bookName),
        );

        $handle = curl_init();
        curl_setopt($handle, CURLOPT_URL, $searchUrl);
        curl_setopt($handle, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($handle, CURLOPT_POST, 1);
        curl_setopt($handle, CURLOPT_POSTFIELDS, $post);
        $output = curl_exec($handle);
        curl_close($handle);

        if (empty($output) || !preg_match_all('/<div id=\"CListTitle\">(.*?)\<\/div>/i', $output, $matchs))
        {
            return false;
        }

        $authorPattern = '/'.$authorName.'/i';
        $bookPattern = '/'.$bookName.'/i';
        $urlPattern = '/Book\/\d+\/Index.aspx/i';

        foreach ($matchs[1] as $match)
        {
            $match = iconv('gb18030', 'utf-8', $match);
            if (false !== strpos($match, $bookName) && false !== strpos($match, $authorName))
            {
                preg_match($urlPattern, $match, $url);
                return self::siteUrl() . '/' . $url[0];
            }
        }

        return false;
    }

    /**
      * 返回更新列表地址，主要用于监控更新
      * @return string
      */
     public static function getListUrl($page)
     {
         return 'http://www.biquge.com/xiaoshuoliebiao/';
     }

     public function getContentRegex()
     {
         return array(
             'www.8yt.org',
             '全文字超速首发!',
             '八月天',
             '八月天小说网',
             '小说网（）',
             '8yt',
             '\[ww(.*?)m\]',
             '本章节由(.*?)书友上传',
             '╔(.*?)╝',
            '☆(.*)☆',
            '♀(.*)♀',
             '\(看小说(.*?)om\)',
             '更多手打(.*?)地址(:|：)?',
             '推荐阅读(：|:)',
             '最新最快更新的网站(：|:)?',
             '┏(.*?)┛',
             '【叶(.*?)】',
             '【(.*?)书】',
             '【悠(.*?)】',
             '看小说(.*?)子书',
             'xt\.com',
             '#(.*?)#',
             '[x|X][s|S]?(.*?)学网[\)]?',
             '(\()?(小说整理|电脑阅读)(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|оМ)(\)|）)?',
             '(\（|\()?电脑看小说(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
             '(\（|\()?更\/新\/(最|超)\/快(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
             '(\（|\()?请记住我们(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
             '(\（|\()?web用户(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|Ｏｍ|ｍ|оМ)(\)|）)?',
             '本(書|书)(.*?)(學|学)(網|网)',
             '更\/新\/最\/快',
             '手机轻松(.*?)整理',
             '\[ww(.*?)m\]',
             '本章节由(.*?)书友上传',
             '七路中文',
             '\/(ω|ｗ|w|W)(.*?)(ｍ|М|m|M|t)\/',
             '(ω|ｗ|w|W)(.*?)(ｍ|М|m|M|t)',
             '(\（|\()(.*?)手打(\)|）)',
             '\*\*(.*?)网(.*?)下载\*\*',
             'xt点com',
             'xt(.*?)子书',
             '小说阅读下载尽在小说网中文网更新超快小说更多',
             '小说网',
         );
     }

     public function getChaperNameRegex()
     {
         return array(
             //'(|(w|ω|W)(.*))?(ㄧ|一|1|１|1|l|⑴|①)(.*)(m|M|Ｍ|М|ｍ|n|ｎ|m|网|網|传)',
            //'(www.|ωωω.)*(1|１|１|ㄧ)\s*(6|６|б)(.*)[com|ｃom|om|m]',
            //'(１|1|l|①|⑴)\s*(6|６|б)(.*)s',
         );
     }

     /**
      * 返回更新列表
      * @param int $page
      * @return array
      */
     public static function getNewList($page = 1)
     {
         $result = array();
         $url = self::getListUrl($page);
         $content = getFile($url);
         $content = iconv('gbk', 'utf-8',$content); 
         
         //$content = self::proxyFetch($url,'gb18030', 'utf-8');
         if(!empty($content))
         {
             preg_match_all('/<span\s*class=\"s2\">\s*<a\s*href=\"(.*?)\">(.*?)\<\/a>\<\/span>/is', $content, $matches);
             $urlArray = $matches[1];
             $nameArray = $matches[2];
             foreach ($urlArray as $key => $value)
             {
                 $result[$value] = $nameArray[$key];
             }
         }

         return array_splice($result, 0, 6);
     }

    /**
     * 返回本站与采集站点分类之间的对应关系
     * @return int
     */
    public function getTypeId()
    {
        preg_match('/<i><a href="\/Book\/LC\/\d+\.aspx">(.*?)<\/a><\/i>/i',$this->_infoFiles,$match);       
        $type = trim($match[1]);
        return $this->getBookTypeId($type);
    }

    public static function siteUrl()
    {
        return self::$siteUrl;
    }

    public static function siteName()
    {
        return self::$siteName;
    }
}