<?php

class Site_Nuoshu extends Site_Base
{
    public static $siteUrl = 'http://www.nuoshu.com';

    public static $siteName = '诺书';

    public $lockTime = 1800;

    protected $_infoFiles = '';

    protected $_chapterListUrl = null;

    protected $_denyBooks = array(9477);

    public function __construct($detailUrl)
    {
        parent::__construct($detailUrl);
         preg_match('/(\d+)/i', $detailUrl, $matches);
         $this->_bookId = intval($matches[1]);
    }

    /**
      * 获取小说整体信息，如简介、ID之类的
      * @return void
      */
    public function getInfoFile()
    {
        $infoUrl = $this->_detailUrl;
        $this->_infoFiles = $this->getFile($infoUrl, 'gbk', 'utf-8');
    }

    /**
    public function getFile($url, $inCharset = null, $outCharset = null)
    {
        return self::proxyFetch($url, $inCharset, $outCharset);
    }
    /**/
    
    /**
     * 返回本站与采集站点分类之间的对应关系
     * @return int
     */
    public function getTypeId()
    {
        preg_match('/<span><strong>分类：<\/strong><a href=".*" title=".*">(.*)<\/a><\/span>/i',$this->_infoFiles,$match);
        $type = trim($match[1]);        
        return $this->getBookTypeId($type);
    }

    /**
      * 获取小说名
      * @return string
      */
    public function getBookName()
    {
        preg_match('/<h1>血蛮<em>/i', $this->_infoFiles, $bookname);
        return $bookname[1];
    }

    /**
      * 取得小说作者名
      * @return string
      */
    public function getAuthor()
    {
        preg_match('/<strong>作者：<\/strong>(.*)<\/em>/i', $this->_infoFiles, $author);
        return trim($author[1]);
    }

    /**
     * 取得小说简介
     * @return string
     */
    public function getBookInfo()
    {
      //  echo $this->_infoFiles;
        preg_match('/<\/a><\/strong>(.*?)<div class="wbutton">/is', $this->_infoFiles, $match);        
        $bookinfo = $match[1];
        $bookinfo = preg_replace('/<strong>.*/i','',$bookinfo);      
        return analyzeText($bookinfo);
    }

    /**
     * 取得小说写作状态
     * @return int
     */
    public function getStatus()
    {
        preg_match('/(<div id="lzico"><\/div>)/i', $this->_infoFiles, $status);
        if (!empty($status[1]))
        {
            return 0;
        }
        return 1;
    }

    /**
     * 取得章节列表的url
     * @return string
     */
    public function getChapterListUrl()
    {
        if (!is_null($this->_chapterListUrl))
        {
            return $this->_chapterListUrl;
        }

        preg_match('/<a href="(\/Html\/Book\/\d+\/\d+\/)" class="yuedu">点击阅读<\/a>/i',$this->_infoFiles,$match);      
        return $this->_chapterListUrl = self::$siteUrl . trim($match[1]);
    }

       /**
        * 设置章节列表URL
        * @param string $url
        * @return void
        */
    public function setChapterListUrl($url)
    {
        $this->_chapterListUrl = $url;
    }

    /**
     * 取得小说所有章节地址
     * @return array
     */
    public function getChapterList()
    {
        $list = array('hasVolume' => false);      
        $chapterListContent = $this->getFile($this->getChapterListUrl());
        preg_match_all('/<dd><a href="(.*)" title=".*">.*<\/a><\/dd>/is', $chapterListContent, $matches);
        $str = $matches[0][0];
        $a = explode ('</dd>', $str);
        foreach ( $a as $v) {
        preg_match('/<a href="(\d+\.shtml)" title=".*">(.*)<\/a>/i',$v,$match);
        if(!empty($match[1]))
        {
            $url  = $match[1];
            $title =$match[2];
            $chapters[] = array('url' => $url, 'title' => iconv('gbk', 'utf-8',$title));
            }
        }
        $list['chapters'] = $chapters;
        $this->setChapterArray($list);
        return $list;
    }

    /**
     * 取得章节名
     * @param string $chapterContent
     * @return string
     */
    public function getChapterName($chapterContent)
    {
        preg_match('/<div id="TextTitle">(.*?)\<\/div>/is', $chapterContent, $chaptername);

        return $this->analyzeChapterName(str_replace(array('正文','作品','最新章节'), '', $chaptername[1]));
    }

    /**
     * 从原始的单一章节内容中过滤出章节内容
     * @param string $chapterContent
     * @return string
     */
    public function filterChapterContent($chapterContent)
    {
        preg_match('/<div id="BookText">(.*?)<\/div>/is', $chapterContent, $content);        
        $result = $content[1];
        $result = $this->analyzeContent($result);
        
        return $result;
    }

    /**
     * 取得单一章节内容
     * @param $contentUrl
     * @return string
     */
    public function getChapterContent($contentUrl)
    {
        $content = $this->getFile($contentUrl);

        preg_match('/charset=(.*?)(\'|\")/i', $content, $charset);
        if(strpos(strtolower($charset[1]), 'utf-8') !== false)
        {
            $content = iconv('gbk', 'utf-8', $content);
        }
        else if(strpos(strtolower($charset[1]), 'gb2312') !== false)
        {
            $content = iconv('GB18030', 'utf-8', $content);
        }

        return $content;
    }

    /**
     * 取得一条完整的章节内容URL
     * @param string $chapterHtml
     * @return string
     */
    public function getChapterContentUrl($chapterHtml)
    {
        $url = $this->_chapterListUrl.$chapterHtml;
        return $url;
    }

    /**
     * 判断内容是否为图片
     * @param string $chapterContent
     * @return boolean
     */
    public function isImage($chapterContent)
    {
        if (preg_match('/DownFiles\/Book/is', $chapterContent))
        {
            return true;
        }
        return false;
    }

    /**
     * 获取一个完整的图片地址
     * @param string $image
     * @return string
     */
    public function getImageUrl($image)
    {
        return self::siteUrl() . $image;
    }

    /**
     * 在目标站点搜索小说
     * @param string $bookName
     * @param string $authorName
     * @return string|boolean
     */
    public static function searchBook($bookName, $authorName)
    {
        
    }

    /**
      * 返回更新列表地址，主要用于监控更新
      * @return string
      */
     public static function getListUrl()
     {         
         return self::$siteUrl. '/Book/ShowBookList.aspx';
     }

     public function getContentRegex()
     {
         return array(
            '\\\\(.*?)\\\\',
            '(\（|\()?电( ){0,}脑( ){0,}阅( ){0,}读(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|Ｏｍ|ｍ|оМ)(\)|）)?',
            '(\()?全文字(.*?)(學網|学网)(\)|）)?',
            '(<|《)?16(k|K)小(说|說)网(.*?)\.(сΝ|om|ｃｎ|Сｎ|ＣＮ|c-n|M|оМ)(>|》)',
            '(\()?本书转载(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|оМ)[\)]?',
            '１６(.*?)小(说|說)网',
            '(\()?(小说整理|电脑阅读)(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|оМ)(\)|）)?',
            '(\（|\()?电脑看小说(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
            '(\（|\()?更\/新\/(最|超)\/快(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
            '(\（|\()?请记住我们(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|ｍ|оМ)(\)|）)?',
            '(\（|\()?web用户(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|Ｏｍ|ｍ|оМ)(\)|）)?',
            '1⑹(.*?)(整理|首发)',
            '[x|X][s|S]?(.*?)学网[\)]?',
            '本(書|书)(.*?)(學|学)(網|网)',
            '更\/新\/最\/快',
            '手机轻松(.*?)整理',
            'wap(.*?)\|(k|K)',
            '(\(|\（|\[)www.16kbook.com(\)|\）|\])',
            '(手机访问|手机看小说|ｗ-α-р|ｗｗ`ｗ|ｗ-а-р|ωωω|ｗｗｗ|ｗａｐ|⑴⑹|ω)(.*?)(сΝ|om|ｃｎ|Сｎ|m|M|М|ＣＮ|c-n|Ｏｍ|ｍ|оМ)[\)]?',
            '(nuoshu.com|NUOSHU|ＮＵＯＳＨＵ.ｃＯＭ|http:\/\/wap\.|WｗW\.|WｗW.NuoShu.cOM)?',
            'wwW.ＮuoＳＨu.CＯm 首发',
            '\[ww(.*?)m\]',
            '本章节由(.*?)书友上传',
            '^^(.*?)^^',
            '╔(.*?)╝',
            '┏(.*?)┛',
            '１６ｋｘｓ．ｃｏｍ',
            'l⑹ＫXS.cΟM',
            '&lt;ahref=http:\/\/www.&gt;www.<\/a>',
            '(ＮＵＯＳＨＵ.ｃＯＭ|wap\.nuoshu\.com|)',
            '~~(.*?)~~',
            '诺书网',
            '(首.发|手机同步阅读请访问|在线免费看全文字小说|百度输入\"\"|诺书)',
            'wＷW.nＵoＳhu.Ｃom (诺书网免费小说手打网)',
            '手机同步阅读请访问http:\/\/wap.nuoshu.com',
            '提供本章节最新手打 书迷群∴17666325',
            '^诺^书^网^e^看免费提供^^',
            '提供本章节最新手打书迷群1∴①⑺⑥⑥⑥㈢②(５|5)',
            '\*\*免费提供本书TXT电子书下载\*\*',
            '\[本章由ｗWＷ\.为您提供\]',
            '\/(ω|ｗ|w|W)(.*?)(ｍ|М|m|M|t)\/',
            '(ω|ｗ|w|W)(.*?)(ｍ|М|m|M|t)',
            //'((|（)看小说(.*?)(）|\))',
            '(\（|\()看小说(.*?)(\)|）)',
            '追书网',
            '只要输入(.*?)章节内容',
            '本章由为您提供',
            '百度输入(.*?)文字小说',
            '==(.*?)==',
            '^^诺书网^^免费',
            '^^(.*?)网^^免费',
            '诺\*书\*网',
            '(\（|\()(.*?)手打(\)|）)',
            '\*\*(.*?)网(.*?)下载\*\*',
            '免费小说网',
            '诺书网',
            'nuoshu',
            '文字更新最快',
            '^^^^',
            '书迷群2∴⑨⑴⑨⑥㈨⑸⑤②',
            '免费提供本书TXT电子书下载'
         );
     }

     public function getChaperNameRegex()
     {
         return array(            
        //    '(www.|ωωω.|wap.)*(N|n|)\s*(S|s)*(W|w)*[com|ｃom|om|m|cn]',
         );
     }

     /**
      * 返回更新列表
      * @param int $page
      * @return array
      */
     public static function getNewList($page = 1)
     {
         $url = self::getListUrl() . '?page=' . $page;
         
         $result = array();
         //$content = self::proxyFetch($url, 'GB18030', 'utf-8');
         $content = iconv('gb18030', 'utf-8', getFile($url));
         if(!empty($content)){             
             preg_match_all('/<a href="(\/Book\/\d+\/Index\.aspx)" title="(.*)" class="f14" >.*<\/a> /i', $content, $match);
             $urlArray = $match[1];
             $nameArray = $match[2];
             foreach ($urlArray as $key => $value)
             {
                 $result[self::$siteUrl . $value] = $nameArray[$key];
             }
         }
         return $result;
     }

    public function isCanSave($content)
    {
        $content = str_replace('&nbsp;', ' ', $content);
        $content = preg_replace('/\s|\t|\n|\r/is', '', $content);
        $content = str_replace(' ', '', $content);
        $size = mb_strlen($content,'utf8');
        if (empty($content) || $size < 200 )
        {
            return false;
        }

        return true;
    }

    /**
     * 取得目标小说所属的分类ID
     * @return int
     */
    public function _getTypeId()
    {
        $typeid = $this->_typeId;
        if (empty($typeid))
        {
            if (!is_null($this->_chapterListUrl))
            {
                preg_match('/Html\/Book\/(\d+)\/'.$this->getBookId().'\//is', $this->getChapterListUrl(), $tmp);
                $typeid = $tmp[1];
            }

            if ($typeid !== '0' && empty($typeid))
            {
                if (is_null($this->_infoFiles))
                {
                     $this->_infoFiles = $this->getInfoFile();
                }
                preg_match('/<a\s*href=\"\/Html\/Book\/(\d+)\/'.$this->getBookId().'\/\"\s*class=\"yuedu\">点击阅读\<\/a>/is',$this->_infoFiles,$match);

                $typeid = $match[1];
            }
        }

        return $typeid;
    }

    public static function siteUrl()
    {
        return self::$siteUrl;
    }

    public static function siteName()
    {
        return self::$siteName;
    }
}