<?php
class iCollectLoad
{
    public static function loadClass($class)
    {
        $class = str_replace('_', '/', $class);
        $classFile = dirname(COLLECT_CLASS_PATH) . DS . $class . '.php';
        if (is_file($classFile))
        {
            require_once $classFile;
        }
    }
}

define('DS', DIRECTORY_SEPARATOR);
// 采集器运行根目录
define('COLLECT_PATH', dirname(__FILE__) . DS);
// 具体采集站点类存放目录
define('COLLECT_CLASS_PATH', COLLECT_PATH . 'class' . DS);

require_once dirname(COLLECT_PATH) . DS . 'init.php';
require_once COLLECT_PATH . 'collect.func.php';
require_once COLLECT_PATH . 'Spider.php';
require_once COLLECT_PATH . 'Updater.php';

spl_autoload_register('iCollectLoad::loadClass');

// 代理地址列表
$proxyList = array();