<?php
/**
 * 清理小说里的水印
 */
require_once dirname(dirname(__FILE__)) . '/init.php';

$date = $argv[1];
$size = $argv[2] ? $argv[2] : 5000;
$clean = $argv[3] ? true : false;
$sql = 'SELECT chapterid,bookid FROM '.Chapter::table().' WHERE date = '.S::sqlEscape($date) .' AND size >='. $size;

$chapters = $db->setQueryString($sql)->find();
if (empty($chapters))
{
    die("没有符合要求的章节\n");
}

foreach ($chapters as $chapter)
{
    $bookId = $chapter['bookid'];
    $chapterId = $chapter['chapterid'];
    $content = Chapter::single()->getContent($bookId, $chapterId);

    if (empty($content))
    {
        continue;
    }

    if (preg_match('/土土土/is', $content, $match) || preg_match('/凹凹/is', $content, $match))
    {
        echo "BID: $bookId    CID: $chapterId\n";
        if ($clean)
        {
            $content = analyzeText($content);
            $content = filter_content($content);
            $content = explode("\n\n", $content);
            $content = array_map(function($row) {
                if (empty($row)) {
                    return $row;
                }
                $c1 = mb_substr_count($row, '，');
                $c2 = mb_substr_count($row, '。');
                $c3 = mb_substr_count($row, '..');
                $c4 = mb_substr_count($row, ',');
                $c5 = mb_substr_count($row, '“');
                $c6 = mb_substr_count($row, '”');
                $c7 = mb_substr_count($row, '？');
                if ($c1 + $c2 + $c3 + $c4 + $c5 + $c6 + $c7 >= 2) {
                    return $row;
                } else {
                    return '';
                }
            }, $content);
            $content = array_filter($content);
            $content = implode("\n\n", $content);

            Chapter::single()->update($chapterId, $bookId, array('content'=>$content));
        }
    }
}