<?php
namespace collect\tools;

/**
 * 重新抓一次特定条件的章节
 */
require_once dirname(dirname(__FILE__)) . '/init.php';
use collect;

$sql = "select c.bookid,chapterid,chaptername,ct.listurl,ct.detailurl from ".\Chapter::table()." as c inner join ".\CollectList::table()." as ct on ct.bookid = c.bookid where chapterid in (6267614,6268436,6268437,6268857,6268936,6269420,6269423,6269424,6269944,6270153,6270154,6270156,6270157,6270158,6270163,6270350,6270389,6270399,6270400,6270401,6270405,6270418,6270494,6270502,6270503,6270510,6270520,6270525,6270526,6270528,6270532,6270535,6270536,6270539,6270543,6270544,6270555,6271140,6271143,6271144,6271146,6271162,6271193,6271217,6271218,6271267,6271268,6271369,6271374,6271379,6271381,6271382,6271442,6271451,6271515,6271522,6271545,6271571,6271590,6271591,6271592,6271605,6271608,6271609,6271612,6271622,6271625,6271629,6271641) AND ct.spider = 'Kenwen'";
$result = $db->setQueryString($sql)->find();

foreach ($result as $row)
{
    $bookid = $row['bookid'];
    $chapterid = $row['chapterid'];
    $name = $row['chaptername'];
    $spiderObj = \collect\Spider::factory($row['detailurl'], 'Kenwen');
    $spiderObj->setChapterListUrl($row['listurl']);
    $spiderObj->getChapterList();

    $chapterList = $spiderObj->getChapterArray();
    $updater = new \collect\Updater($spiderObj);

    if ($chapterList['hasVolume'])
    {
        $tmp = $updater->mergeVolume($chapterList);
        // 反转数组，应付头尾都相等的情况导致重复采集
        $tmp['chapters'] = array_reverse($tmp['chapters']);
        foreach ($tmp['chapters'] as $key => $v)
        {
            if ($updater->compare1($name, $v['title']))
            {
                $return = up($bookid, $chapterid, $spiderObj, $v['url']);
            }
        }
    }

    if (!$return)
    {
        $chapterList = $spiderObj->clearVolume($chapterList);
        $tmp['chapters'] = array_reverse($chapterList['chapters']);
        foreach ($tmp['chapters'] as $key => $v)
        {
            if ($updater->compare2($name, $v['title']))
            {
                $return = up($bookid, $chapterid, $spiderObj, $v['url']);
            }
        }
    }
}

function up($bookId, $chapterId, $spiderObj, $url)
{
    $url = $spiderObj->getChapterContentUrl($url);
    $i = 0;
    do
    {
       $chapterContent = $spiderObj->getChapterContent($url);
       $i++;
    } while (empty($chapterContent) && $i < 3);
    $content = $spiderObj->filterChapterContent($chapterContent);

    if (empty($content) || false !== strpos($content, '由于服务器压力过'))
    {
        return false;
    }

    $data['isimage'] = 0;
    // 如果 内容是图片&&当前采集器允许采集图片&&任务状态为0(0表示为假或空章)
    if (!$spiderObj->isImage($content))
    {
        $data['content'] = $content;
        \Chapter::single()->update($chapterId, $bookId, $data);

        return false;
    }

    return true;
}