<?php
/**
 * 汇总每天站内的广告点击数据
 * 1 3 * * * 
 */
require_once dirname(dirname(__FILE__)) . '/init.php';
$logTable = AdLog::table();
$fluxSumTable = 'ig_adfluxsum';
$spaceSumTable = 'ig_adspaceflux';
$fluxTable = 'ig_adflux';
$spaceArray = array('index', 'show', 'read', 'chapter', 'bbs', 'member', 'forum', 'other');
$typeArray = array(0, 1, 2, 3, 4);
$date = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('-1 day'));
if (isset($argv[1]))
{
    $yesterday = $argv[1];
}

class AdFluxSum
{
    private $_date;
    
    private $_addCondition = '';
    
    private $_ids = array();
    
    public function __construct($date)
    {
        $this->_date = $date;
        $this->_getIds();
    }
    
    public function getIds($type = 0)
    {
        $array = $this->_ids;
        
        return $array[$type];
    }
    
    public function getAddCondition()
    {
        return $this->_addCondition;
    }
    
    public function addCondition($condition)
    {
        $this->_addCondition = $condition;
    }
    
    private function _getIds()
    {
        $sql = 'SELECT adid,`type` FROM '.Ad::table();
        $result = $GLOBALS['db']->setQueryString($sql)->find();
        if (empty($result))
        {
            throw new Exception('无法获取到有效的广告');
        }
        
        $array = array();
        foreach ($result as $value)
        {
            $array[$value['type']][] = $value['adid'];
        }
        $this->_ids = $array;
    }
    
    public function getLogTable()
    {
        return $GLOBALS['logTable'];
    }
    
    public function getDate()
    {
        return $this->_date;
    }
    
    /**
     * 获取广告的总点击
     * @return int
     */
    public function getClick()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getLogTable()." WHERE `date`='".$this->getDate()."' " . $this->getAddCondition();
        
        return $GLOBALS['db']->getValue($sql);
    }
    
    /**
     * 获取广告的总有效点击（手机用户）
     * @return int
     */
    public function getValidClick()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getLogTable()." WHERE `date`='".$this->getDate() . "' AND valid = 1 " . $this->getAddCondition();

        return $GLOBALS['db']->getValue($sql);
    }
    
    /**
     * 获取用户产生的广告总点击
     * @return int
     */
    public function getUClick()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getLogTable()." WHERE `date`='".$this->getDate() . "' AND uid <> 0 " . $this->getAddCondition();
        
        return $GLOBALS['db']->getValue($sql);
    }
    
    /**
     * 获取总的用户有效广告点击（手机用户）
     */
    public function getUValidClick()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getLogTable()." WHERE `date`='".$this->getDate() . "' AND uid <> 0 AND valid = 1 " . $this->getAddCondition();
        
        return $GLOBALS['db']->getValue($sql);
    }
}

$idsArray = array();
$obj = new AdFluxSum($yesterday);

// 先汇总
foreach ($typeArray as $type)
{
    $ids = $obj->getIds($type);
    if (empty($ids) && 4 != $type)
    {
        continue;
    }
    
    is_array($ids) && $idsArray = array_merge($idsArray, $ids);
    $addCondition = 4 == $type ? '' : ' AND adid IN ('.implode(',', $ids).')';
    $obj->addCondition($addCondition);
    
    $data = array(
        'click' => $obj->getClick(),
        'valid_click' => $obj->getValidClick(),
        'u_click' => $obj->getUClick(),
        'u_valid_click' => $obj->getUValidClick(),
        'date' => $yesterday,
        'month' => date('m'),
        'type' => $type,
    );

    $db->insert($fluxSumTable)->value($data)->q();
}

// 汇总广告位数据
foreach ($spaceArray as $space)
{
    $addCondition = " AND space = '{$space}'";
    $obj->addCondition($addCondition);
    
    $data = array(
        'click' => $obj->getClick(),
        'valid_click' => $obj->getValidClick(),
        'u_click' => $obj->getUClick(),
        'u_valid_click' => $obj->getUValidClick(),
        'date' => $yesterday,
        'space' => $space,
    );
    $db->insert($spaceSumTable)->value($data)->q();
}

// 单条广告数据汇总
foreach ($idsArray as $id)
{
    $addCondition = " AND adid = '{$id}'";
    $obj->addCondition($addCondition);
    
    $data = array(
        'adid' => $id,
        'click' => $obj->getClick(),
        'valid_click' => $obj->getValidClick(),
        'u_click' => $obj->getUClick(),
        'u_valid_click' => $obj->getUValidClick(),
        'date' => $yesterday,
    );
    $db->insert($fluxTable)->value($data)->q();
}