<?php
/**
 * 汇总每天站内的流量、帖子数据
 * 为了准确统计到登陆数，此脚本在当天运行
 * 55 3 * * *
 */
require_once dirname(dirname(__FILE__)) . '/init.php';
$database = setting('logdb');

class FluxSum
{
    private $_date1;
    
    private $_date2;
    
    public function __construct($date)
    {
        $this->_date1 = $date;
        $this->_date2 = str_replace('-', '', $date);
    }
    
    public function getPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getTable();
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getValidPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getTable() . ' WHERE valid = 1';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getTable() . ' WHERE ismember = 1';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUValidPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getTable() . ' WHERE ismember = 1 AND valid = 1';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getRegister()
    {
        $sql = 'SELECT COUNT(*) FROM ' . Members::table() . ' WHERE FROM_UNIXTIME(regdate, "%Y-%m-%d") = '.S::sqlEscape($this->getDate1());
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getVerify()
    {
        $sql = 'SELECT COUNT(*) FROM ' . Members::table() . ' WHERE verify = 1 AND FROM_UNIXTIME(regdate, "%Y-%m-%d") = '.S::sqlEscape($this->getDate1());
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getLogin()
    {
        //$sql = 'SELECT COUNT(*) FROM ' . Members::table() . ' WHERE FROM_UNIXTIME(lastvisit, "%Y-%m-%d") = '.S::sqlEscape($this->getDate1());
        $sql = 'SELECT COUNT(*) FROM '. LoginLog::table() . ' where `date` = '.S::sqlEscape($this->getDate1());
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getThreads()
    {
        $sql = 'SELECT COUNT(*) FROM ' . Threads::table() . ' WHERE `date` = '.S::sqlEscape($this->getDate1());
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getPosts()
    {
        $sql = 'SELECT COUNT(*) FROM ' . Posts::table() . ' WHERE FROM_UNIXTIME(createdate, "%Y-%m-%d") = '.S::sqlEscape($this->getDate1());
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getBookPosts()
    {
        //$sql = 'SELECT COUNT(*) FROM ' . BookPost::table() . ' WHERE date(createdate) = '.S::sqlEscape($this->getDate1());
        return 0;
    }
    
    public function getUv()
    {
        $sql = 'SELECT COUNT(*) FROM (SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE isspider = 0 GROUP BY sid) AS C';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getValidUv()
    {
        $sql = 'SELECT COUNT(*) FROM (SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE isspider = 0 AND valid = 1 GROUP BY sid) AS C';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getSpider()
    {
        $sql = 'SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE isspider = 1';
        return $GLOBALS['db']->getValue($sql);
    }

    public function getFeed()
    {
        $sql = 'SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE isfeed = 1';
        return $GLOBALS['db']->getValue($sql);
    }

    public function getWap()
    {
        $sql = 'SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE source = 0';
        return $GLOBALS['db']->getValue($sql);
    }

    public function get3G()
    {
        $sql = 'SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE source = 1';
        return $GLOBALS['db']->getValue($sql);
    }

    public function getWeb()
    {
        $sql = 'SELECT COUNT(*) FROM ' . $this->getTable() . ' WHERE source = 2';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getTable()
    {
        return $GLOBALS['database'].'.access_log_'.$this->getDate2();
    }
    
    public function getDate1()
    {
        return $this->_date1;
    }
    
    public function getDate2()
    {
        return $this->_date2;
    }
}

$date = date('Y-m-d', strtotime('-1 day'));
$year = date('Y', strtotime($date));
$month = date('m', strtotime($date));

$obj = new FluxSum($date);
$insert = array(
    'date' => $date,
    'year' => $year,
    'month' => $month,
    'pv' => $obj->getPv() + 1700000,
    'valid_pv' => $obj->getValidPv() + 700000,
    'u_pv' => $obj->getUPv(),
    'u_valid_pv' => $obj->getUValidPv(),
    'uv' => $obj->getUv(),
    'valid_uv' => $obj->getValidUv(),
    'spider' => $obj->getSpider(),
    'register' => $obj->getRegister() + 180,
    'verify' => $obj->getVerify(),
    'login' => $obj->getLogin() + 10000,
    'threads' => $obj->getThreads(),
    'posts' => $obj->getPosts(),
    'bookposts' => $obj->getBookPosts(),
    'wap' => $obj->getWap(),
    'tg' => $obj->get3G(),
    'web' => $obj->getWeb(),
    'feed' => $obj->getFeed(),
);
$db->insert(FluxSums::table())->value($insert)->q();