<?php
/**
 * 整理每天的推广流量数据
 * 1 4 * * * 
 */
require_once dirname(dirname(__FILE__)) . '/init.php';

class iReward
{
    private $_db = 'u1db5';
    
    private $_ruid;
    
    private $_date;
    
    public function __construct($ruid, $date)
    {
        $this->_ruid = $ruid;
        $this->_date = $date;
    }
    
    public function getUv()
    {
        $sql = 'SELECT COUNT(c) FROM (SELECT COUNT(*) AS c FROM '.$this->getFullTable().' WHERE ruid = '.$this->getRuid().' GROUP BY sid) AS cc';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getValidUv()
    {
        $sql = 'SELECT COUNT(c) FROM (SELECT COUNT(*) AS c FROM '.$this->getFullTable().' WHERE valid = 1 AND ruid = '.$this->getRuid().' GROUP BY sid) AS cc';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getValidPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE valid = 1 AND ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE uid <> 0 AND ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUUv()
    {
        $sql = 'SELECT COUNT(c) FROM (SELECT COUNT(*) AS c FROM '.$this->getFullTable().' WHERE uid <> 0 AND ruid = '.$this->getRuid().' GROUP BY sid) AS cc';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUValidUv()
    {
        $sql = 'SELECT COUNT(c) FROM (SELECT COUNT(*) AS c FROM '.$this->getFullTable().' WHERE uid <> 0 AND valid = 1 AND ruid = '.$this->getRuid().' GROUP BY sid) AS cc';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getUValidPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE uid <> 0 AND valid = 1 AND ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getRegister()
    {
        $date = date('Y-m-d', $this->getTime());
        $sql = 'SELECT COUNT(*) FROM '.Reward::table().' WHERE ruid = '.$this->getRuid().' AND date(createdate) = '.S::sqlEscape($date);
        return $GLOBALS['db']->getValue($sql);
    }

    public function getNPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE new = 1 AND ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }

    public function getNValidPv()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->getFullTable().' WHERE new = 1 AND valid = 1 AND ruid='.$this->getRuid();
        return $GLOBALS['db']->getValue($sql);
    }

    public function getEntrance()
    {
        $date = date('Y-m-d', $this->getTime());
        $sql = 'SELECT COUNT(*) FROM '.EntranceLogs::table().' WHERE ruid = '.$this->getRuid().' AND date = '.S::sqlEscape($date);
        return $GLOBALS['db']->getValue($sql);
    }

    public function getValidEntrance()
    {
        $date = date('Y-m-d', $this->getTime());
        $sql = 'SELECT COUNT(*) FROM '.EntranceLogs::table().' WHERE valid = 1 AND ruid = '.$this->getRuid().' AND date = '.S::sqlEscape($date);
        return $GLOBALS['db']->getValue($sql);
    }

    public function getIsValidEntrance()
    {
        $date = date('Y-m-d', $this->getTime());
        $sql = 'SELECT COUNT(*) FROM '.EntranceLogs::table().' WHERE isvalid = 1 AND ruid = '.$this->getRuid().' AND date = '.S::sqlEscape($date);
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getValidU()
    {
        $date = date('Y-m-d', $this->getTime());
        $sql = 'SELECT uid FROM '.Reward::table().' WHERE ruid = '.$this->getRuid().' AND date(createdate) = '.S::sqlEscape($date);
        $result = $GLOBALS['db']->setQueryString($sql)->find();
        if (empty($result))
        {
            return 0;
        }
        
        $array = array();
        foreach ($result as $value)
        {
            $array[] = $value['uid'];
        }
        $sql = 'SELECT COUNT(*) FROM '.Members::table().' WHERE uid IN ('.implode(',', $array).') AND verify = 1';
        return $GLOBALS['db']->getValue($sql);
    }
    
    public function getRuid()
    {
        return $this->_ruid;
    }
    
    public function getFullTable()
    {
        return $this->_db . '.reward_log_'.$this->getDate();
    }
    
    public function getDate()
    {
        return $this->_date;
    }
    
    public function getTime()
    {
        return strtotime($this->getDate());
    }
}

$database = setting('dblog');
$date = date('Ymd', strtotime('-1 day'));
$d = date('Y-m-d', strtotime('-1 day'));
$fullDatabase = $database . '.reward_log_'.$date;

$sql = 'SELECT ruid FROM '.$fullDatabase.' GROUP BY ruid';
$result = $db->setQueryString($sql)->find();
if (empty($result))
{
    exit(0);
}

// 汇总
$pvSum = $uvSum = $validPvSum = $validUvSum = $uPvSum = $uUvSum = $uValidPvSum = $uValidUvSum
       = $registerSum = $validUSum = $entranceSum = $validEntranceSum = $isValidEntranceSum = $nPv = $nValidPv
       = $nPvSum = $nValidPvSum = 0;
foreach ($result as $value)
{
    $ruid = $value['ruid'];
    $obj = new iReward($ruid, $date);
    $pvSum += $pv = $obj->getPv();
    $uvSum += $uv = $obj->getUv();
    $validPvSum += $validPv = $obj->getValidPv();
    $validUvSum += $validUv = $obj->getValidUv();
    $uPvSum += $uPv = $obj->getUPv();
    $uUvSum += $uUv = $obj->getUUv();
    $uValidPvSum += $uValidPv = $obj->getUValidPv();
    $uValidUvSum += $uValidUv = $obj->getUValidUv();
    $registerSum += $register = $obj->getRegister();
    $validUSum += $validU = $obj->getValidU();
    $entranceSum += $entrance = $obj->getEntrance();
    $validEntranceSum += $validEntrance = $obj->getValidEntrance();
    $isValidEntranceSum += $isValidEntrance = $obj->getIsValidEntrance();

    $nPvSum += $nPv = $obj->getNPv();
    $nValidPvSum += $nValidPv = $obj->getNValidPv();

    
    $insert = array(
        'ruid' => $ruid,
        'pv' => $pv,
        'uv' => $uv,
        'valid_pv' => $validPv,
        'valid_uv' => $validUv,
        'u_pv' => $uPv,
        'u_uv' => $uUv,
        'u_valid_pv' => $uValidPv,
        'u_valid_uv' => $uValidUv,
        'register' => $register,
        'valid_u' => $validU,
        'date' => $d,
        'entrance' => $entrance,
        'valid_entrance' => $validEntrance,
        'isvalid_entrance' => $isValidEntrance,
        'n_pv' => $nPv,
        'n_valid_pv' => $nValidPv,
    );
    
    $db->insert(RewardFluxs::table())->value($insert)->q();
}

$sum = array(
    'pv' => $pvSum,
    'uv' => $uvSum,
    'valid_pv' => $validPvSum,
    'valid_uv' => $validUvSum,
	'u_pv' => $uPvSum,
    'u_uv' => $uUvSum,
    'u_valid_pv' => $uValidPvSum,
    'u_valid_uv' => $uValidUvSum,
    'register' => $registerSum,
    'valid_u' => $validUSum,
    'date' => $d,
    'entrance' => $entranceSum,
    'valid_entrance' => $validEntranceSum,
    'isvalid_entrance' => $isValidEntranceSum,
    'n_pv' => $nPvSum,
    'n_valid_pv' => $nValidPvSum,
);
$db->insert(RewardSums::table())->value($sum)->q();