<?php
/**
 * 自10000字开始,每1000字获得50酷币奖励
 * 自10万字开始,每1000字获得80酷币奖励
 * 自20万字开始,每1000字获得100酷币奖励
 * 自50万字开始,每1000字可以获得200酷币奖励
 * 1 2 * * *
 * User: yzxh24
 * Date: 11-6-14
 * Time: 下午9:29
 * To change this template use File | Settings | File Templates.
 */
require_once dirname(dirname(dirname(__FILE__))) . '/init.php';

// 每周一凌晨运行
if (date("D") != 'Mon')
{
    exit(0);
}
$denyBooks = array(17995,17195,15750,17401,17612);
$books = $db->select(array('bookid', 'bookname', 'size', 'authorid'))->from(Book::table())->where('type=2 AND size >= 10000 AND view = 1')->find();
if (empty($books))
{
    exit(0);
}

foreach ($books as $book)
{
    $bookId = $book['bookid'];
    if (in_array($bookId, $denyBooks))
    {
        continue;
    }
    $bookName = $book['bookname'];
    $size = $book['size'];
    $price = getPrice($size);
    if (!$price)
    {
        continue;
    }
    $uid = Authors::single()->getUid($book['authorid']);
    if (!$uid)
    {
        continue;
    }

    $sDate = date('Y-m-d', strtotime('-7 day'));
    $eDate = date('Y-m-d', strtotime('-1 day'));
    $dateRange = getDateRange($sDate, $eDate);
    $inArray = array();
    foreach ($dateRange as $value)
    {
        $inArray[] = S::sqlEscape($value);
    }
    $cSize = $db->getValue('SELECT SUM(`size`) AS cSize FROM '.Chapter::table().' WHERE display = 1 AND bookid = '.S::sqlEscape($bookId). ' AND `date` IN ('.implode(',', $inArray) . ')');
    if (!$cSize)
    {
        continue;
    }

    $credits = $price * floor($cSize / 1000);
    $userName = userName($uid);
    $iCredits = iCredits::single($uid, $userName);
    $iCredits->setUid($uid);
    $iCredits->setUserName($userName);
    $iCredits->addMoney($credits, false, false);
    $iCredits->log($uid, $userName, 'BookPay');

    $subject = '[系统消息]原创小说内容奖励';
    $message = '您的小说《'.$bookName.'》上周总共完成'.$cSize.'字更新，每千字奖励'.$price.setting('creditname').'，总共奖励'.$credits;
    Members::sendMessage($subject, $message, 1, 'admin', $uid);

    $db->insert(BookPayLog::table())->value(array('bid'=>$bookId,'size'=>$cSize,'uid'=>$uid,'username'=>$userName,'credits'=>$credits,'bookname'=>$bookName,'sdate'=>$sDate,'edate'=>$eDate,'createdate'=>CDATETIME,'date'=>CDATE,'price'=>$price))->q();
}

function getPrice($size)
{
    if ($size >= 500000)
    {
        return 200;
    }
    else if ($size >= 200000)
    {
        return 100;
    }
    else if ($size >= 100000)
    {
        return 80;
    }
    else
    {
        return 50;
    }
}

/**
 * 获取一个时间范围
 * @param string $startDate
 * @param string $endDate
 * @return array
 */
function getDateRange($startDate, $endDate)
{
    $days = (strtotime($endDate) - strtotime($startDate)) / 86400 + 1;
    $startMonth = date("m", strtotime($startDate));
    $startDay = date("d", strtotime($startDate));
    $startYear = date("Y", strtotime($startDate));
    $dates = array();
    for($i=0; $i<$days; $i++)
    {
        $dates[$i] = date("Y-m-d", mktime(0, 0, 0, $startMonth , ($startDay+$i), $startYear));
    }
    return $dates;
}