<?php
/**
 * 原创小说章节定时发布功能
 * 0 * * * * 
 * User: yzxh24
 * Date: 11-6-12
 * Time: 下午8:58
 * To change this template use File | Settings | File Templates.
 */
require_once dirname(dirname(dirname(__FILE__))) . '/init.php';

$year = date('Y');
$month = date('n');
$day = date('j');
$hour = date('G');

$sql = 'SELECT * FROM '.DraftCron::table().' WHERE `year` = '.S::sqlEscape($year).' AND `month` = '.S::sqlEscape($month).' AND `day` = '.S::sqlEscape($day).' AND hour = '.S::sqlEscape($hour) . ' AND status = 0';
$crons = $db->setQueryString($sql)->find();
if (empty($crons))
{
    exit(0);
}

foreach ($crons as $cron)
{
    $chapterId = $cron['cid'];
    $bookId = $cron['bid'];
    $id = $cron['id'];

    $drafts = $db->select()->from(Draft::table())->where(array('chapterid'=>$chapterId,'deleted'=>0))->asc('sort')->find();
    if (empty($drafts))
    {
        continue;
    }

    $content = array();
    foreach ($drafts as $draft)
    {
        $content[] = $draft['content'];
    }
    $data = array(
        'content' => implode("\n", $content),
        'display' => 1,
        'createdate' => CDATETIME, // 由于章节一早就生成了，所以这里修改创建时间
        'date' => CDATE,
    );
    Chapter::single()->update($chapterId, $bookId, $data);
    $db->update(DraftCron::table())->value(array('status'=>1, 'updatedate'=>CDATETIME))->where(array('id'=>$id))->q();
}