<?php
/**
 * 原创书精评数量根据字数而定,10万字以下每天可以设置5条
 * 10万字以上,每增加2万字,可设精评数量+1
 * 10 0 * * *
 */
require_once dirname(dirname(dirname(__FILE__))) . '/init.php';

$nomalSize = 100000;
$nomalNum = 5;
$addSplice = 20000;

$sql = 'SELECT bookid, size FROM '.Book::table().' WHERE `type` = 2 AND view = 1';
$books = $db->setQueryString($sql)->find();
if (empty($books))
{
    exit(0);
}

foreach ($books as $book)
{
    $bookId = $book['bookid'];
    $size = $book['size'];
    $num = $nomalNum;
    if ($size > $nomalSize)
    {
        $add = round(($size - $nomalSize) / $addSplice);
        $num = intval($nomalNum + $add); 
    }

    $managers = $db->select(array('uid'))->from(BookManagers::table())->where(array('bookid'=>$bookId,'status'=>1))->find();
    if (!empty($managers))
    {
        foreach ($managers as $manager)
        {
            echo $bookId . '...' . $uid . '...' . $num . "\n";
            $uid = $manager['uid'];
            $db->update(BookManagers::table())->value(array('digest'=>$num))->where(array('bookid'=>$bookId,'uid'=>$uid))->q();
        }
    }
    //$db->update(BookForum::table())->value(array('digest' => $nomalNum))->where('bookid='.$bookId);
    //updateBookForum($bookId);
    //echo $bookId . '...' . $num . "\n";
}