<?php
/**
 * 书会评论分表脚本，超过5W条书评的就单独存放
 */
require_once dirname(dirname(__FILE__)) . '/init.php';

$sql = 'SELECT bookid,posts FROM '.BookForum::table().' WHERE posts >= 50000 AND shard = 0';
$forums = $db->setQueryString($sql)->find();

if (empty($forums))
{
    die('没有符合条件的书会');
}

foreach ($forums as $forum)
{
    $bookId = $forum['bookid'];
    $posts = $forum['posts'];

    $t1 = 'bookposts' . $bookId;
    
    $postTable = 'CREATE TABLE `'.$t1."` (
`bookpostsid` int(11) NOT NULL,
`uid` int(11) NOT NULL,
`bookid` int(11) NOT NULL,
`message` mediumtext NOT NULL,
`loginip` char(20) NOT NULL,
`createdate` datetime NOT NULL,
`date` date DEFAULT NULL,
`digest` tinyint(1) NOT NULL DEFAULT '0',
`remarks` char(255) DEFAULT '',
`deleted` tinyint(1) NOT NULL DEFAULT '0',
`applydigest` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否申请过精华 1是 0否',
`isadvance` tinyint(1) DEFAULT '0' COMMENT '是否为高级评论',
`lastpost` int(10) NOT NULL,
UNIQUE KEY `postid` (`bookpostsid`),
KEY `digest` (`digest`),
KEY `date` (`date`),
KEY `advance` (`isadvance`),
KEY `last` (`lastpost`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;";

    $db->query($postTable);

    $max = 10000;
    if ($posts > $max)
    {
        // 分批插入数据，防止内存不足
        $per = ceil($posts / $max);
        for ($i = 0; $i <= $per; $i++)
        {
            $offset = $i * $max;
            $sql = 'SELECT bookpostsid,uid,message,bookid,loginip,createdate,date,digest,remarks,deleted,applydigest,isadvance,lastpost FROM '.BookPost::dtable().' WHERE bookid = '.$bookId.' LIMIT '.$offset.','.$max;
            $result = $db->setQueryString($sql)->find();
            foreach ($result as $item)
            {
                $insert = array(
                    'bookpostsid' => $item['bookpostsid'],
                    'uid' => $item['uid'],
                    'bookid' => $item['bookid'],
                    'message' => mysql_real_escape_string($item['message']),
                    'loginip' => $item['loginip'],
                    'createdate' => $item['createdate'],
                    'date' => $item['date'],
                    'digest' => $item['digest'],
                    'remarks' => $item['remarks'],
                    'deleted' => $item['deleted'],
                    'applydigest' => $item['applydigest'],
                    'isadvance' => $item['isadvance'],
                    'lastpost' => $item['lastpost'],
                );
                $db->insert($t1)->value($insert)->q();
            }
        }
    }
    else
    {
        $sql = 'SELECT bookpostsid,message,uid,bookid,loginip,createdate,date,digest,remarks,deleted,applydigest,isadvance,lastpost FROM '.BookPost::dtable().' WHERE bookid = '.$bookId;
        $result = $db->setQueryString($sql)->find();
        foreach ($result as $item)
        {
            $insert = array(
                'bookpostsid' => $item['bookpostsid'],
                'uid' => $item['uid'],
                'bookid' => $item['bookid'],
                'message' => mysql_real_escape_string($item['message']),
                'loginip' => $item['loginip'],
                'createdate' => $item['createdate'],
                'date' => $item['date'],
                'digest' => $item['digest'],
                'remarks' => $item['remarks'],
                'deleted' => $item['deleted'],
                'applydigest' => $item['applydigest'],
                'isadvance' => $item['isadvance'],
                'lastpost' => $item['lastpost'],
            );
            $db->insert($t1)->value($insert)->q();
        }
    }

    $db->update(BookForum::table())->value(array('shard'=>1))->where(array('bookid'=>$bookId))->q();
    updateBookForum($bookId);
}