<?php
/**
 * 服务器重启以后用来刷新缓存
 */
require_once dirname(dirname(__FILE__)) . '/init.php';

// 先重建书籍缓存
$books = $db->select(array('bookid'))->from(Book::table())->where('view = 1')->find();
foreach ($books as $book)
{
    echo "开始重建小说 {$book['bookid']}...";
    // 重建小说缓存
    updateBookInfo($book['bookid']);
    
    // 重建书会缓存
    updateBookForum($book['bookid']);
    
    // 重建章节列表缓存
    Chapter::single()->updateCache($book['bookid']);
    echo "完毕\n";
}

// 重建会员缓存，只重建最近两天活跃的用户
$timestr = strtotime('-2 day');
$members = $db->select(array('uid'))->from(Members::table())->where('lastactivity >= ' . $timestr)->find();
foreach ($members as $member)
{
    echo "开始重建用户 {$member['uid']}...";
    // 重建用户缓存
    Members::single()->updateOneCache($member['uid']);
    
    // 重建用户名缓存
    Members::single()->updateUserNameCache($member['uid']);
    echo "完毕\n";
}