$('document').ready(function(){
	$('.cldz').click(function(){
		$('#readview').slideToggle();
	});
	$('#default_view').click(function() {
		defaultView();
		$.cookie("rv", 'defaultView');
	});
	$('#pink_view').click(function() {
		pinkView();
		$.cookie("rv", 'pinkView');
	});
	$('#green_view').click(function() {
		greenView();
		$.cookie("rv", 'greenView');
	});
	$('#vista_view').click(function() {
		vistaView();
		$.cookie("rv", 'vistaView');
	});
	$('#user_view').click(function() {
		userView();
		$.cookie("rv", 'userView');
	});
	
	$('#style_bg_color').change(function() {
		var bgColor = $("#style_bg_color option:selected").val();
		$('body').css('background', bgColor);
	});
	$('#style_font').change(function() {
		var stFont = $("#style_font option:selected").val();
		$('#readtext p').css('font-family', stFont);
	});
	$('#style_ft_color').change(function() {
		var ftColor = $("#style_ft_color option:selected").val();
		$('#readtext p').css('color', ftColor);
	});
	$('#style_font_size').change(function() {
		var ftSize = $("#style_font_size option:selected").val();
		$('#readtext p').css('font-size', ftSize);
	});
	$('#style_margin').change(function() {
		var stMargin = $("#style_margin option:selected").val();
		$('#readcon').css('margin', stMargin);
	});
	$('#style_line_height').change(function() {
		var stLineHeight = $("#style_line_height option:selected").val();
		$('#readtext p').css('line-height', stLineHeight);
	});
	$('#save_user_view').click(function() {
		var bgColor = $("#style_bg_color option:selected").val();
		var stFont = $("#style_font option:selected").val();
		var ftColor = $("#style_ft_color option:selected").val();
		var ftSize = $("#style_font_size option:selected").val();
		var stMargin = $("#style_margin option:selected").val();
		var stLineHeight = $("#style_line_height option:selected").val();
		$.cookie("uv", 'userView');
		$.cookie("rv", 'userView');
		$.cookie("style_bg_color", bgColor);
		$.cookie("style_font", stFont);
		$.cookie("style_ft_color", ftColor);
		$.cookie("style_font_size", ftSize);
		$.cookie("style_margin", stMargin);
		$.cookie("style_line_height", stLineHeight);
		alert("保存自定义策略成功");
	});
	readView();	
});

function readView() {
	var readView = $.cookie('rv');
	if (readView != null) {
		switch (readView) {
			case 'defaultView': {
				defaultView();
				break;
			}
			case 'pinkView': {
				pinkView();
				break;
			}
			case 'greenView': {
				greenView();
				break;
			}
			case 'vistaView': {
				vistaView();
				break;
			}
			case 'userView': {
				userView();
				break;
			}
			default: {
				defaultView();
			}
		}
	}
}

function defaultView() {
	$('body').css('background', '#f0fafe');
	var cssObj = {
		'color' : '#454545',
		'line-height' : '1.8em',
		'font-family' : '宋体',
		'font-size' : '14px'
	};
	$('#readtext p').css(cssObj);
	$('#readcon').css('margin', '0 10%');
	$('#headSlected').html('默认策略');
}

function pinkView() {
	$('body').css('background', '#ffeff5');
	var cssObj = {
		'color' : '#a30355',
		'line-height' : '1.8em',
		'font-family' : '宋体',
		'font-size' : '14px'
	};
	$('#readtext p').css(cssObj);
	$('#readcon').css('margin', '0 10%');
	$('#headSlected').html('粉色言情');
}

function greenView() {
	$('body').css('background', '#eefaee');
	var cssObj = {
		'color' : '#00471e',
		'line-height' : '1.8em',
		'font-family' : '宋体',
		'font-size' : '14px'
	};
	$('#readtext p').css(cssObj);
	$('#readcon').css('margin', '0 10%');
	$('#headSlected').html('绿色健康');
}

function vistaView() {
	$('body').css('background', '#f0fafe');
	var cssObj = {
		'color' : '#454545',
		'line-height' : '1.8em',
		'font-family' : '微软雅黑',
		'font-size' : '14px'
	};
	$('#readtext p').css(cssObj);
	$('#readcon').css('margin', '0 20%');
	$('#headSlected').html('Vista宽屏');
}

function userView() {
	var view = $.cookie('uv');
	if (view != null && view == 'userView') {
		var bgColor = $.cookie('style_bg_color');
		if (bgColor != null) {
			$('body').css('background', bgColor);
		}
		var stFont = $.cookie('style_font');
		if (stFont != null) {
			$('#readtext p').css('font-family', stFont);
		}
		var ftColor = $.cookie('style_ft_color');
		if (ftColor != null) {
			$('#readtext p').css('color', ftColor);
		}
		var ftSize = $.cookie('style_font_size');
		if (ftSize != null) {
			$('#readtext p').css('font-size', ftSize);
		}
		var stMargin = $.cookie('style_margin');
		if (stMargin != null) {
			$('#readcon').css('margin', stMargin);
		}
		var stLineHeight = $.cookie('style_line_height');
		if (stLineHeight != null) {
			$('#readtext p').css('line-height', stLineHeight);
		}
		$('#headSlected').html('自定义策略');
	}
}