<?php
/**
 * @return CWwebUser
 */
function User()
{
	return Yii::app()->user;
}

/**
 * @return Application
 */
function App()
{
	return Yii::app();
}

/**
 * 构造一个url
 * @param string $route
 * @param array $params
 * @param string $anchor
 * @param string $ampersand
 * @return string
 */
function iUrl($route, $params=array(), $anchor = null, $ampersand='&')
{
    //return CController::createUrl($route, $params, $ampersand);
    return Yii::app()->createUrl($route, $params, $ampersand) . $anchor;
}

/**
 * 构造一条书籍连接地址
 * @param int $bookId
 * @return string
 */
function iBook($bookId)
{
    return iUrl('site/book/show', array('id'=>$bookId));
}

/**
 * 输出小说的封面
 * @param int $bookId
 * @return string
 */
function Cover($bookId)
{
    return Books::model()->getCoverUrl($bookId);
}

function H($text)
{
    return htmlspecialchars($text, ENT_QUOTES, Yii::app()->charset);
}

/**
 * 构造一个链接
 * @param string $text
 * @param mixed $url
 * @param array $htmlOptions
 * @return string
 */
function L($text, $url = '#', $htmlOptions = array()) 
{
    return CHtml::link($text, $url, $htmlOptions);
}

/**
 * 返回一个参数
 * @param string $name
 * @return mixed
 */
function Param($name) 
{
    return Yii::app()->params[$name];
}

function T($message, $category = 'stay', $params = array(), $source = null, $language = null)
{
    return Yii::t($category, $message, $params, $source, $language);
}

function C()
{
    return Yii::app()->clientScript;
}
?>