<?php
/**
* 文件操作助手
*
* @Copyright(c) 2007-2009
* @Author: iOrange
* @Email: yzxh24@gmail.com
* @Version $id:file 2009-10-18 11:46:38
*/
/* vim: set ts=4 sw=4: */
class IFileHelper extends CFileHelper
{
	public static function createDir($path, $mode = 0755)
	{
		if (is_dir($path) || @mkdir($path, $mode))
		{
			return true;
		}
		if (!self::createDir(dirname($path), $mode))
		{
			return false;
		}
		return @mkdir($path, $mode);
	}

	public function deleteDir($path)
	{
		if (is_dir($path) && !is_writeable($path))
		{
			if (!chmod($path, 0666))
			{
				return false;
			}
		}
		else
		{
			if (!is_dir($path))
			{
				return false;
			}
		}

		$path = rtrim($path, '/\\') . DIRECTORY_SEPARATOR;
		$dirInfo = glob($path . "*");
		foreach ($dirInfo as $info)
		{
			if (is_dir($info))
			{
				self::deleteDir($info);
			}
			else
			{
				unlink($info);
			}
		}
		@rmdir($path);

		return true;
	}

	public static function createFile($file, $content)
	{
		$folder = dirname($file);
		if (!is_dir($folder))
		{
			IFileHelper::createDir($folder);
		}

		if (is_dir($folder) && is_writable($folder))
		{
			file_put_contents($file, $content);
		}
	}

	public static function deleteFile($file)
	{
		if (is_file($file) && is_writable($file))
		{
			@unlink($file);
		}
	}

	public static function readFile($file)
	{
		$content = '';
		if (is_file($file))
		{
			$content = file_get_contents($file);
		}
		return $content;
	}

	public static function filterTag($content)
	{
		$source = array("<br/>", "<br />", "<BR />", "<BR>", "<br>", "<p>", "</p>", "<P>", "</P>", "&nbsp;", "&", "<", ">");
		$replace = array("\n", "\n", "\n", "\n", "\n", "\n", "", "\n", "\n", " ", "&amp;", "&lt;", "&gt;");
		$return = str_replace($source, $replace, $content);

		return $return;
	}
	
	/**
	 * 生成一个html文件
	 * @param Book $book
	 * @param Chapter $chapter
	 * @return void
	 */
	public static function createHtml($book, $chapter)
	{
		$webAppPath = Yii::app()->params['webAppPath'];
		$suffix = Yii::app()->params['staticSuffix'];
		$typeId = IFileHelper::selfType($book->bookid);
		$htmlFile = $webAppPath . 'read' . DS . $typeId . DS . $book->bookid . DS . $chapter->chapterid . $suffix;
		$readTemplateFile = $webAppPath . 'themes' . DS . 'web' . DS . 'views' . DS . 'book' . DS . 'read.php';
		
		if ($chapter->prevChapter($chapter->chapterid, $chapter->bookid))
		{
			$prevUrl = '/read/' . $typeId . '/' . $book->bookid . '/' . $chapter->prevChapter($chapter->chapterid, $chapter->bookid)->chapterid . $suffix;
		}
		
		if ($chapter->nextChapter($chapter->chapterid, $chapter->bookid))
		{
			$nextUrl = '/read/' . $typeId . '/' . $book->bookid . '/' . $chapter->nextChapter($chapter->chapterid, $chapter->bookid)->chapterid . $suffix;
		}
		$enterUrl = '/chapter/' . $book->bookid . $suffix;
		$homeUrl = '/';
		$showUrl = '/show/' . $book->bookid . $suffix;
		$chapterUrl = '/chapter/' . $book->bookid . $suffix;
		
		$chapterContent = $chapter->content;
		ob_start();
		include($readTemplateFile);
		$content = ob_get_clean();
		IFileHelper::createFile($htmlFile, $content);
	}
	
	public static function selfType($bookId)
	{
		return substr(md5($bookId), 0, 1);
	}
}