<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
$modules = require_once 'modules.php';
$params = require_once 'deploy_params.php';
$dbinfo = $params['db'];
unset($params['db']);

return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'My Web Application',

	// preloading 'log' component
	'preload'=>array('log'),

    'defaultController' => 'Default',

    'language' => 'zh_cn',
    
	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
        'application.extensions.*',
        'application.modules.site.*',
        'application.modules.admin.*',
	),

	// application components
	'components'=>array(
		'user'=>array(
    		'class' => 'site.components.WebUser',
			'allowAutoLogin'=>true,
    		'loginUrl' => 'admin/default/login',
		),
        'authManager' => array(
            'class' => 'admin.components.BackendAuthorManager',
            'connectionID' => 'db',
            'itemTable' => 'ig_auth_item',
            'assignmentTable' => 'ig_auth_assignment',
            'itemChildTable' => 'ig_auth_item_child',
            'defaultRoles' => array('Guest'),
        ),
        'adminUser' => array(
            'class' => 'admin.components.BackendWebUser',
			'allowAutoLogin'=>true,
    		'loginUrl' => '/admin/default/login',
        ),
		// uncomment the following to use a MySQL database
		'db'=>array(
			'connectionString' => "mysql:host={$dbinfo['host']};dbname={$dbinfo['database']}",
			'emulatePrepare' => true,
			'username' => "{$dbinfo['user']}",
			'password' => "{$dbinfo['password']}",
			'charset' => 'utf8',
		),
        'cache' => array(
            'class' => 'CFileCache',
        ),
        'urlManager' => array(
			'urlFormat' => 'path',
			'showScriptName' => false,
        ),
		'errorHandler'=>array(
			// use 'site/error' action to display errors
            'errorAction'=>'site/error',
        ),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
			),
		),
        'mailer' => array(
            'class' => 'application.extensions.mailer.EMailer',
            'pathViews' => 'application.views.email',
            'pathLayouts' => 'application.views.email.layouts'
        ),

	),

    'modules' => $modules,

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params' => $params,
);