<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
$dbconfig = require ROOT_PATH . 'include/Db.conf.php';
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'My Web Application',

	// preloading 'log' component
	'preload'=>array('log'),

    'defaultController' => 'Default',

    'language' => 'zh_cn',

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
        'application.extensions.*',
	),

	// application components
	'components'=>array(
		'db'=>array(
			'connectionString' => "mysql:host={$dbconfig['host']};dbname={$dbconfig['database']}",
			'emulatePrepare' => true,
			'username' => "{$dbconfig['user']}",
			'password' => "{$dbconfig['password']}",
			'charset' => 'utf8',
		),
        'cache' => array(
            'class' => 'CFileCache',
        ),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params' => $params,
);