<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * 后台控制器基类
 *
 * @author yzxh24
 */
class BackendController extends CController
{
    public $breadcrumbs = array();

    protected $actionPrefix = '';
    
	protected $actionMap = array();
    
    public function init()
    {
        // 应对swfupload上传BUG
        if (isset($_POST["PHPSESSID"]))
        {
            session_id($_POST["PHPSESSID"]);
        }
        parent::init();

        $urlManager = Yii::app()->getUrlManager();
        $urlManager->setUrlFormat('get');
        $urlManager->showScriptName = true;
    }

    public function actions()
    {
		$ret = array();
		foreach ($this->actionMap as $actionName => $className)
        {
			$ret[$actionName] = $this->actionPrefix . $className;
		}

		return $ret;
	}

    /**
     * 往面包屑导航条里增加内容
     * @param  $array
     * @return void
     */
    public function addBreadcrumb($readcrumb)
    {
        $this->breadcrumbs = array_merge($this->breadcrumbs, $readcrumb);
    }
    
    /**
     * action执行前做的一些操作
     * @param CAction $action
     */
    protected function beforeAction($action)
    {
        parent::beforeAction($action);

        if (Yii::app()->adminUser->isGuest && $this->action->id != 'login')
        {
            // 记录下当前页面地址，方便登录成功后跳回来
            $redirect = $this->createUrl('/'.Yii::app()->adminUser->loginUrl);
            //$redirect = Yii::app()->adminUser->loginUrl;
            $redirect['redirect'] = Yii::app()->request->getRequestUri();
            $this->redirect($redirect);
        }

        // 调试模式下直接通过
        if (YII_DEBUG || 1 == Yii::app()->adminUser->id)
        {
            return true;
        }

        $operateString = str_replace('/', '_', $this->route);
        if (!Yii::app()->adminUser->checkAccess($operateString))
        {
            // 提示无权操作
            throw new CHttpException(403);
        }

        return true;
    }
}