<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * 助手类
 *
 * @author yzxh24
 */
class iTool
{
    /**
     * 过滤掉一些隐藏字符
     * @param string $content
     * @return string
     */
    public static function filter($content)
    {
        return preg_replace('/[\x00-\x20]/i', '', $content);
    }
    
    /**
	 * 加密或解密字符串
	 * @param string $string
	 * @param string $action
	 * @return string
	 */
	public static function strCode($string, $action = 'ENCODE')
	{
		$action != 'ENCODE' && $string = base64_decode($string);
		$code = '';
		$key = substr(md5($_SERVER['HTTP_USER_AGENT'] . Config::getValue('cfg_key')), 8, 18);
		$keylen = strlen($key);
		$strlen = strlen($string);
		for ($i = 0; $i < $strlen; $i++)
		{
			$k = $i % $keylen;
			$code .= $string[$i] ^ $key[$k];
		}

		return ($action != 'DECODE' ? base64_encode($code) : $code);
	}

    /**
     * 生成一个condition
     * @param CDbCriteria $criteria
     * @return CDbCriteria
     */
    public static function condition($criteria)
    {
        $params = $_GET;
        unset($$params['page']);

        foreach ($params as $key => $value)
        {
            if (is_array($value) && !empty($value['value']))
            {
                $field = str_replace('-', '.', $key);

                $opreate = Operate::getOperate($value['operate']);
                if ($opreate == 'LIKE')
                {
                    $criteria->addSearchCondition($field, $value['value']);
                }
                else
                {
                    $criteria->compare($field, $value['value']);
                }
            }
        }
        
        return $criteria;
    }
}