<?php

/**
 * This is the model class for table "ig_adflux".
 */
class AdFlux extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_adflux':
	 * @var integer $id
	 * @var integer $adid
	 * @var integer $click
	 * @var integer $valid_click
	 * @var integer $u_click
	 * @var integer $u_valid_click
	 * @var string $date
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return AdFlux the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_adflux';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('adid, valid_click, date', 'required'),
			array('adid, click, valid_click, u_click, u_valid_click', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, adid, click, valid_click, u_click, u_valid_click, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'ad' => array(self::BELONGS_TO, 'Ad', 'adid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'adid' => '广告ID',
			'click' => '点击',
			'valid_click' => '有效点击',
			'u_click' => '会员点击',
			'u_valid_click' => '会员有效点击',
			'date' => '日期',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);

		$criteria->compare('adid',$this->adid);

		$criteria->compare('click',$this->click);

		$criteria->compare('valid_click',$this->valid_click);

		$criteria->compare('u_click',$this->u_click);

		$criteria->compare('u_valid_click',$this->u_valid_click);

		$criteria->compare('date',$this->date,true);

		return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}