<?php

/**
 * This is the model class for table "ig_adfluxsum".
 */
class AdFluxSum extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_adfluxsum':
	 * @var integer $id
	 * @var integer $click
	 * @var integer $valid_click
	 * @var integer $u_click
	 * @var integer $u_valid_click
	 * @var string $date
	 * @var string $month
	 * @var integer $type
	 */
    public static $type = array(0 => '点击',1 => '下载',2 => '广告票',3=>'提示票', 4=>'总数据');

	/**
	 * Returns the static model of the specified AR class.
	 * @return AdFluxSum the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_adfluxsum';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, month', 'required'),
			array('click, valid_click, u_click, u_valid_click, type', 'numerical', 'integerOnly'=>true),
			array('month', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, click, valid_click, u_click, u_valid_click, date, month, type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'click' => '点击',
			'valid_click' => '有效点击',
			'u_click' => '会员点击',
			'u_valid_click' => '会员有效点击',
			'date' => '日期',
			'type' => '类型',
		);
	}
}