<?php

/**
 * This is the model class for table "adlog".
 */
class AdLog extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'adlog':
	 * @var integer $adlogid
	 * @var integer $adid
	 * @var string $ip
	 * @var string $date
	 */

    public $c;
    
	/**
	 * Returns the static model of the specified AR class.
	 * @return AdLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'adlog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('adid, date', 'required'),
			array('adid', 'numerical', 'integerOnly'=>true),
			array('ip', 'length', 'max'=>16),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('adlogid, adid, ip, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'adlogid' => 'Adlogid',
			'adid' => 'Adid',
			'ip' => 'IP地址',
			'date' => '时间',
            'c' => '访问数'
		);
	}
}