<?php

/**
 * 跟model目录下的Ad类有冲突
 * This is the model class for table "ad".
 */
class Adb extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ad':
	 * @var integer $adid
	 * @var string $title
	 * @var string $url
	 * @var integer $type
	 * @var integer $status
	 * @var integer $count
	 * @var integer $day
	 * @var string $createdate
	 * @var integer $quota
	 */
    /**
     * 广告状态
     * @var array
     */
    public static $status = array(1 => '可用', 0 => '不可用');

    /**
     * 广告类型
     * @var array
     */
    public static $type = array(0 => '点击',1 => '下载',2 => '广告票',3=>'提示票',4=>'购物');
    
    /**
     * 是否允许随机
     * @var array
     */
    public static $isrand = array(1 => '允许', 0 => '禁止');

    /**
     * 广告投放位置
     * @var array
     */
    public static $spaces = array('index' => '首页','show' => '封面页', 'chapter' => '章节列表页', 'read' => '阅读页', 'bbs' => '社区', 'member' => '会员空间', 'forum' => '书会', 'other' => '其它');

    /**
     * SUM(day) AS count
     * @var int
     */
    public $count;

	/**
	 * Returns the static model of the specified AR class.
	 * @return Ad the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_ad';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, url, createdate', 'required'),
			array('type, status, count, day, quota, isrand', 'numerical', 'integerOnly'=>true),
			array('title, url', 'length', 'max'=>255),
			array('adid, title, url, type, status, count, day, createdate, quota, isrand, spaces, day_valid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	
	public function afterSave()
	{
	    Front::updateAdCache();
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
        );
    }

    public function defaultScope()
    {
        return array(
            'condition' => 'deleted = 0',
        );
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'adid' => 'ID',
			'title' => '广告名称',
			'url' => '广告地址',
			'type' => '广告类型',
			'status' => '状态',
			'count' => '总点击',
			'day' => '今日点击',
            'day_valid' => '今日有效点击',
			'createdate' => '创建时间',
			'quota' => '访问配额',
		    'isrand' => '允许随机',
		    'spaces' => '投放位置',
		);
	}
	
	public function getStatus($status)
	{
	    if (!$status)
	    {
	        echo '<font color=red>'.self::$status[$status].'</font>';
	    }
	    else
	    {
	        echo self::$status[$status];
	    }
	}
	
	public function isRand($isRand)
	{
	    if (!$isRand)
	    {
	        echo '<font color=red>'.self::$isrand[$isRand].'</font>';
	    }
	    else
	    {
	        echo self::$isrand[$isRand];
	    }
	}
}