<?php

/**
 * This is the model class for table "admin".
 */
class Admin extends CActiveRecord
{
    /**
     * 改密码用
     * @var string
     */
    public $oldPassword;
    public $newPassword;
    public $newPasswordConfirm;

	/**
	 * The followings are the available columns in table 'admin':
	 * @var integer $id
	 * @var string $admin
	 * @var string $passwd
	 * @var string $email
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Admin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_admin';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, password, email', 'required'),
			array('username', 'length', 'max'=>20),
			array('password', 'length', 'max'=>60),
			array('email', 'length', 'max'=>70),
            array('newPassword, newPasswordConfirm, oldPassword', 'required', 'on'=>'password'),
            array('newPassword, newPasswordConfirm', 'length', 'max'=>40,'min'=>6, 'on'=>'password'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, username, password, email', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => 'Admin',
			'password' => 'Passwd',
			'email' => 'Email',
            'newPasswordConfirm' => '确认密码',
            'newPassword' => '新密码',
            'oldPassword' => '旧密码',
		);
	}

    public function securePassword($password)
    {
        return md5($password);
    }
}