<?php

/**
 * This is the model class for table "applybm".
 */
class ApplyBm extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'applybm':
	 * @var integer $id
	 * @var string $username
	 * @var integer $uid
	 * @var integer $createdate
	 * @var integer $issuper
	 * @var integer $bookid
	 */
    public static $isSuper = array(0=>'不是',1=>'是');

	/**
	 * Returns the static model of the specified AR class.
	 * @return ApplyBm the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookapplybm';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, uid, createdate', 'required'),
			array('uid, createdate, issuper, bookid', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>16),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, username, uid, createdate, issuper, bookid', 'safe', 'on'=>'search'),
		);
	}

	public function relations()
    {
        return array(
            'book' => array(self::BELONGS_TO, 'Books', 'bookid'),
        );
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => '用户名',
			'uid' => 'UID',
			'createdate' => '创建时间',
			'issuper' => '是否为超管',
			'bookid' => '小说ID',
		);
	}
}