<?php
/**
 * 权限分配
 *
 * @author ouyang
 *
 */

class Assignment extends BaseActiveRecord
{
	/**
	 * 'auth_assignment'表字段定义:
	 * @var string $itemname    授权项:M_C_A格式
	 * @var string $userid      被授权人ID
	 * @var string $bizrule  
	 * @var string $data
	 */
	
	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

    /**
	 * 表名
	 */
	public function tableName()
    {
		return 'ig_auth_assignment';
	}

	/**
     * 规则
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('itemname', 'length', 'max' => 64),
			array('userid', 'length', 'max' => 64),
			array('itemname, userid', 'required'),
			array('user_id,itemname,bizrule,data', 'safe')
		);
	}
	
	/**
     * 关联
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'user' => array(self::BELONGS_TO, 'User', 'userid', 'alias' => 'user'),
            'authitem'=>array(self::BELONGS_TO, 'AuthItem', 'itemname', 'alias' => 'authitem')
        );
	}
	
	/**
     * 标签值
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'itemname' => '权限项',
			'userid' => '授权者ID',
			'bizrule' => '',
			'data' =>''
		);
	}
}