<?php
/**
 * Yii中RBAC权限管理
 * @author ouyang
 *
 * @link http://dongbeta.com/view/469.html
 */
class AuthItem extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'auth_item':
	 * @var string $name    权限名:行动名称,任务名称,角色名称
	 * @var integer $type   授权类型:operation（行动）,task（任务）和 role（角色）
	 * @var string $description
	 * @var string $bizrule
	 * @var string $data
	 *
	 */
	
	public static $TYPES = array('Operation', 'Task', 'Role');
	
	
	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
	
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_auth_item';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('name', 'length', 'max' => 64),
			array('name, type', 'required'),
			array('type', 'numerical', 'integerOnly' => true),
			array('name,type,description,bizrule,data', 'safe')
		);
	}
	
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'authAssignments' => array(self::HAS_MANY, 'AuthAssignment', 'itemname'),
			'authItemChildren' => array(self::HAS_MANY, 'AuthItemChild', 'child'),
		);
	}
	
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'name' => 'Name',
			'type' => 'Type',
			'description' => 'Description',
			'bizrule' => 'Bizrule',
			'data' => 'Data'
		);
	}

    /**
     * 查找关键字为$prefix的匹配数据
     * @param <string> $prefix
     * @return array()
     */
    public static function findLikeWith($prefix)
    {
         $criteria = new CDbCriteria();
         $criteria->condition = "name LIKE '{$prefix}%'";
         $result = self::model()->findAll($criteria);
         return $result;
    }
}